/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.LoaderPoolNode;
import org.netbeans.core.NbAuthenticator;
import org.netbeans.core.NbProxySelector;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.ShortcutsFolder;
import org.netbeans.core.WarmUpSupport;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.InstalledFileLocatorImpl;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.ModuleSystem;
import org.netbeans.core.startup.RunLevel;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.startup.StartLog;
import org.openide.LifecycleManager;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.windows.WindowManager;

public class NonGui
extends NbTopManager
implements Runnable,
RunLevel {
    private static int count;

    public NonGui() {
        assert (count++ == 0) : "Only one instance allowed";
    }

    public boolean isInteractive(int il) {
        return true;
    }

    public void run() {
        try {
            LoaderPoolNode.load();
        }
        catch (IOException ioe) {
            Logger.getLogger(NonGui.class.getName()).log(Level.WARNING, null, ioe);
        }
        StartLog.logProgress((String)"LoaderPool loaded");
        Splash.getInstance().increment(10);
        LoaderPoolNode.installationFinished();
        StartLog.logProgress((String)"LoaderPool notified");
        Splash.getInstance().increment(10);
        ProxySelector.setDefault(new NbProxySelector());
        this.initializeMainWindow();
        StartLog.logProgress((String)"Main window initialized");
        Splash.getInstance().increment(1);
        TopSecurityManager secman = new TopSecurityManager();
        System.setSecurityManager((SecurityManager)secman);
        TopSecurityManager.makeSwingUseSpecialClipboard((Clipboard)((Clipboard)Lookup.getDefault().lookup(ExClipboard.class)));
        Authenticator.setDefault(new NbAuthenticator());
        StartLog.logProgress((String)"Security managers installed");
        Splash.getInstance().increment(1);
        InstalledFileLocatorImpl.discardCache();
    }

    protected void initializeMainWindow() {
        if (!CLIOptions.isGui()) {
            return;
        }
        StartLog.logStart((String)"Main window initialization");
        try {
            Mutex.EVENT.writeAccess(new Runnable(){

                public void run() {
                    Thread.currentThread().setContextClassLoader(Main.getModuleSystem().getManager().getClassLoader());
                    Toolkit.getDefaultToolkit().getSystemEventQueue().push(new EventQueue());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NonGui.class, (String)"MSG_MainWindowInit"));
        Timer timerInit = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
            }
        });
        timerInit.setRepeats(false);
        timerInit.start();
        Splash.getInstance().increment(10);
        StartLog.logProgress((String)"Timer initialized");
        ShortcutsFolder.initShortcuts();
        Splash.getInstance().increment(1);
        StartLog.logProgress((String)"Shortcuts initialized");
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NonGui.class, (String)"MSG_WindowShowInit"));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NbTopManager.WindowSystem windowSystem;
                StartLog.logProgress((String)"Window system initialization");
                if (System.getProperty("netbeans.warmup.skip") == null && System.getProperty("netbeans.close") == null) {
                    final Frame mainWindow = WindowManager.getDefault().getMainWindow();
                    mainWindow.addComponentListener(new ComponentAdapter(){

                        public void componentShown(ComponentEvent evt) {
                            mainWindow.removeComponentListener(this);
                            WarmUpSupport.warmUp();
                        }
                    });
                }
                if ((windowSystem = (NbTopManager.WindowSystem)Lookup.getDefault().lookup(NbTopManager.WindowSystem.class)) != null) {
                    windowSystem.load();
                    StartLog.logProgress((String)"Window system loaded");
                    if (StartLog.willLog()) {
                        NonGui.waitForMainWindowPaint();
                    }
                    windowSystem.show();
                } else {
                    Logger.getLogger(NonGui.class.getName()).log(Level.WARNING, null, new NullPointerException("\n\n\nWindowSystem is not supplied!!!\\n\n"));
                }
                StartLog.logProgress((String)"Window system shown");
                if (!StartLog.willLog()) {
                    NonGui.maybeDie(null);
                }
            }
        });
        StartLog.logEnd((String)"Main window initialization");
    }

    private static void waitForMainWindowPaint() {
        Runnable r = new Runnable(){

            public void run() {
                try {
                    Class<?> clz = Class.forName("org.netbeans.performance.test.guitracker.LoggingRepaintManager");
                    Method m = clz.getMethod("measureStartup", new Class[0]);
                    Object o = m.invoke(null, new Object[0]);
                    NonGui.endOfStartupMeasuring(o);
                }
                catch (ClassNotFoundException e) {
                    StartLog.logProgress((String)e.toString());
                }
                catch (NoSuchMethodException e) {
                    StartLog.logProgress((String)e.toString());
                }
                catch (IllegalAccessException e) {
                    StartLog.logProgress((String)e.toString());
                }
                catch (InvocationTargetException e) {
                    StartLog.logProgress((String)e.toString());
                }
            }
        };
        new Thread(r).start();
    }

    private static void endOfStartupMeasuring(Object o) {
        StartLog.logProgress((String)"Startup memory and time measured");
        NonGui.maybeDie(o);
    }

    private static void maybeDie(Object o) {
        if (System.getProperty("netbeans.kill") != null) {
            TopSecurityManager.exit((int)5);
        }
        if (System.getProperty("netbeans.close") != null) {
            if (Boolean.getBoolean("netbeans.warm.close")) {
                new WarmUpSupport().run();
            }
            if (o != null) {
                StartLog.logMeasuredStartupTime((long)((Long)o));
            }
            LifecycleManager.getDefault().exit();
        }
    }

    static void doExit(int code) {
        TopSecurityManager.exit((int)code);
    }

    public ModuleSystem getModuleSystem() {
        return Main.getModuleSystem();
    }
}

