/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import org.netbeans.core.NbKeymap;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

class ShortcutsFolder {
    private static final String PROFILES_FOLDER = "Keymaps";
    private static final String SHORTCUTS_FOLDER = "Shortcuts";
    private static final String CURRENT_PROFILE_ATTRIBUTE = "currentKeymap";
    private static ShortcutsFolder shortcutsFolder;
    private Listener listener = new Listener();
    private FileObject profilesFileObject;
    private FileObject shortcutsFileObject;
    private FileObject currentFolder;
    private Logger debug = Logger.getLogger(ShortcutsFolder.class.getName());

    static void initShortcuts() {
        if (shortcutsFolder != null) {
            return;
        }
        shortcutsFolder = new ShortcutsFolder();
    }

    private ShortcutsFolder() {
        try {
            FileObject root = Repository.getDefault().getDefaultFileSystem().getRoot();
            this.profilesFileObject = root.getFileObject(PROFILES_FOLDER);
            if (this.profilesFileObject == null) {
                this.profilesFileObject = root.createFolder(PROFILES_FOLDER);
            }
            this.profilesFileObject.addFileChangeListener((FileChangeListener)this.listener);
            this.shortcutsFileObject = root.getFileObject(SHORTCUTS_FOLDER);
            if (this.shortcutsFileObject == null) {
                this.shortcutsFileObject = root.createFolder(SHORTCUTS_FOLDER);
            }
            this.shortcutsFileObject.addFileChangeListener((FileChangeListener)this.listener);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.refresh();
    }

    static void waitFinished() {
        ShortcutsFolder.shortcutsFolder.listener.task.waitFinished();
    }

    private void refresh() {
        NbKeymap keymap = (NbKeymap)Lookup.getDefault().lookup(Keymap.class);
        keymap.removeBindings();
        this.readShortcuts(keymap, this.shortcutsFileObject);
        String keymapName = (String)this.profilesFileObject.getAttribute(CURRENT_PROFILE_ATTRIBUTE);
        if (keymapName == null || "".equals(keymapName)) {
            keymapName = "NetBeans";
        }
        if (this.currentFolder != null) {
            this.currentFolder.removeFileChangeListener((FileChangeListener)this.listener);
        }
        this.currentFolder = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("Keymaps/" + keymapName);
        if (this.currentFolder == null) {
            try {
                this.currentFolder = this.profilesFileObject.createFolder(keymapName);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        if (this.currentFolder != null) {
            this.readShortcuts(keymap, this.currentFolder);
            this.currentFolder.addFileChangeListener((FileChangeListener)this.listener);
        }
    }

    private void readShortcuts(NbKeymap keymap, FileObject fileObject) {
        this.debug.fine("\nreadShortcuts " + fileObject);
        DataFolder folder = DataFolder.findFolder((FileObject)fileObject);
        Enumeration en = folder.children(false);
        while (en.hasMoreElements()) {
            InstanceCookie ic;
            DataObject dataObject = (DataObject)en.nextElement();
            if (dataObject instanceof DataFolder || (ic = (InstanceCookie)dataObject.getCookie(InstanceCookie.class)) == null) continue;
            try {
                Action action = (Action)ic.instanceCreate();
                String shortcuts = dataObject.getName();
                this.debug.fine("  " + shortcuts + " : " + action);
                KeyStroke[] keyStrokes = Utilities.stringToKeys((String)shortcuts);
                if (keyStrokes != null) {
                    ShortcutsFolder.addShortcut(keymap, action, keyStrokes);
                    continue;
                }
                this.debug.warning("Unrecognized shortcut name from " + dataObject.getPrimaryFile().getPath());
            }
            catch (ClassNotFoundException x) {
                Logger.getLogger(ShortcutsFolder.class.getName()).log(Level.WARNING, "{0} ignored; cannot load class {1}", new Object[]{dataObject.getPrimaryFile().getPath(), ic.instanceName()});
            }
            catch (Exception ex) {
                Logger.getLogger(ShortcutsFolder.class.getName()).log(Level.WARNING, null, ex);
            }
        }
    }

    private static void addShortcut(NbKeymap keymap, Action action, KeyStroke[] keyStrokes) {
        Keymap currentKeymap = keymap;
        int k = keyStrokes.length - 1;
        for (int i = 0; i < k; ++i) {
            Action a = currentKeymap.getAction(keyStrokes[i]);
            if (a == null) {
                a = keymap.createMapAction(new NbKeymap.SubKeymap(null), keyStrokes[i]);
                currentKeymap.addActionForKeyStroke(keyStrokes[i], a);
            }
            if (!(a instanceof NbKeymap.KeymapAction)) {
                return;
            }
            currentKeymap = ((NbKeymap.KeymapAction)a).getSubMap();
        }
        currentKeymap.addActionForKeyStroke(keyStrokes[k], action);
    }

    private class Listener
    extends FileChangeAdapter
    implements Runnable {
        private RequestProcessor.Task task = new RequestProcessor("ShortcutsFolder").create((Runnable)this);

        private Listener() {
        }

        public void run() {
            ShortcutsFolder.this.refresh();
        }

        public void fileDataCreated(FileEvent fe) {
            this.task.schedule(500);
        }

        public void fileChanged(FileEvent fe) {
            this.task.schedule(500);
        }

        public void fileDeleted(FileEvent fe) {
            this.task.schedule(500);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            if (fe.getName() != null && !ShortcutsFolder.CURRENT_PROFILE_ATTRIBUTE.equals(fe.getName())) {
                return;
            }
            this.task.schedule(500);
        }
    }
}

