/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

public class SVNStatusKind {
    private final int kind;
    private static final int none = 0;
    private static final int normal = 1;
    private static final int modified = 2;
    private static final int added = 3;
    private static final int deleted = 4;
    private static final int unversioned = 5;
    private static final int missing = 6;
    private static final int replaced = 7;
    private static final int merged = 8;
    private static final int conflicted = 9;
    private static final int obstructed = 10;
    private static final int ignored = 11;
    private static final int incomplete = 12;
    private static final int external = 13;
    private static final int locked = 14;
    public static final SVNStatusKind NONE = new SVNStatusKind(0);
    public static final SVNStatusKind NORMAL = new SVNStatusKind(1);
    public static final SVNStatusKind ADDED = new SVNStatusKind(3);
    public static final SVNStatusKind MISSING = new SVNStatusKind(6);
    public static final SVNStatusKind INCOMPLETE = new SVNStatusKind(12);
    public static final SVNStatusKind DELETED = new SVNStatusKind(4);
    public static final SVNStatusKind REPLACED = new SVNStatusKind(7);
    public static final SVNStatusKind MODIFIED = new SVNStatusKind(2);
    public static final SVNStatusKind MERGED = new SVNStatusKind(8);
    public static final SVNStatusKind CONFLICTED = new SVNStatusKind(9);
    public static final SVNStatusKind OBSTRUCTED = new SVNStatusKind(10);
    public static final SVNStatusKind IGNORED = new SVNStatusKind(11);
    public static final SVNStatusKind EXTERNAL = new SVNStatusKind(13);
    public static final SVNStatusKind UNVERSIONED = new SVNStatusKind(5);
    public static final SVNStatusKind LOCKED = new SVNStatusKind(14);

    private SVNStatusKind(int kind) throws IllegalArgumentException {
        this.kind = kind;
    }

    public int toInt() {
        return this.kind;
    }

    public static SVNStatusKind fromInt(int kind) {
        switch (kind) {
            case 0: {
                return NONE;
            }
            case 1: {
                return NORMAL;
            }
            case 3: {
                return ADDED;
            }
            case 6: {
                return MISSING;
            }
            case 4: {
                return DELETED;
            }
            case 7: {
                return REPLACED;
            }
            case 2: {
                return MODIFIED;
            }
            case 8: {
                return MERGED;
            }
            case 9: {
                return CONFLICTED;
            }
            case 11: {
                return IGNORED;
            }
            case 12: {
                return INCOMPLETE;
            }
            case 13: {
                return EXTERNAL;
            }
            case 5: {
                return UNVERSIONED;
            }
            case 14: {
                return LOCKED;
            }
            case 10: {
                return OBSTRUCTED;
            }
        }
        return null;
    }

    public static SVNStatusKind fromString(String kind) {
        if ("none".equals(kind) || "non-svn".equals(kind)) {
            return NONE;
        }
        if ("normal".equals(kind)) {
            return NORMAL;
        }
        if ("added".equals(kind)) {
            return ADDED;
        }
        if ("missing".equals(kind)) {
            return MISSING;
        }
        if ("deleted".equals(kind)) {
            return DELETED;
        }
        if ("replaced".equals(kind)) {
            return REPLACED;
        }
        if ("modified".equals(kind)) {
            return MODIFIED;
        }
        if ("merged".equals(kind)) {
            return MERGED;
        }
        if ("conflicted".equals(kind)) {
            return CONFLICTED;
        }
        if ("ignored".equals(kind)) {
            return IGNORED;
        }
        if ("incomplete".equals(kind)) {
            return INCOMPLETE;
        }
        if ("external".equals(kind)) {
            return EXTERNAL;
        }
        if ("unversioned".equals(kind)) {
            return UNVERSIONED;
        }
        if ("locked".equals(kind)) {
            return LOCKED;
        }
        if ("obstructed".equals(kind)) {
            return OBSTRUCTED;
        }
        throw new IllegalArgumentException("Unknown status " + kind);
    }

    public String toString() {
        switch (this.kind) {
            case 0: {
                return "non-svn";
            }
            case 1: {
                return "normal";
            }
            case 3: {
                return "added";
            }
            case 6: {
                return "missing";
            }
            case 4: {
                return "deleted";
            }
            case 7: {
                return "replaced";
            }
            case 2: {
                return "modified";
            }
            case 8: {
                return "merged";
            }
            case 9: {
                return "conflicted";
            }
            case 11: {
                return "ignored";
            }
            case 12: {
                return "incomplete";
            }
            case 13: {
                return "external";
            }
            case 14: {
                return "locked";
            }
            case 10: {
                return "obstructed";
            }
        }
        return "unversioned";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SVNStatusKind)) {
            return false;
        }
        return ((SVNStatusKind)obj).kind == this.kind;
    }

    public int hashCode() {
        return new Integer(this.kind).hashCode();
    }
}

