/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.File;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineStatusFromXml;
import org.tigris.subversion.svnclientadapter.utils.SVNStatusUtils;

abstract class CmdLineStatusPart {
    protected SVNStatusKind textStatus;
    protected SVNStatusKind propStatus;

    protected CmdLineStatusPart(SVNStatusKind textStatus, SVNStatusKind propStatus) {
        this.textStatus = textStatus;
        this.propStatus = propStatus;
    }

    public boolean isManaged() {
        return SVNStatusUtils.isManaged(this.textStatus);
    }

    public abstract boolean isCopied();

    public boolean hasRemote() {
        return this.isManaged() && this.getTextStatus() != SVNStatusKind.ADDED;
    }

    public SVNStatusKind getTextStatus() {
        return this.textStatus;
    }

    public SVNStatusKind getPropStatus() {
        return this.propStatus;
    }

    public abstract SVNStatusKind getRepositoryTextStatus();

    public abstract SVNStatusKind getRepositoryPropStatus();

    public abstract File getFile();

    public abstract String getPath();

    static class CmdLineStatusPartFromStdout
    extends CmdLineStatusPart {
        public static final int STATUS_FILE_WIDTH = 40;
        protected String path;
        protected File file;
        protected char history;

        CmdLineStatusPartFromStdout(String statusLine) {
            super(CmdLineStatusPartFromStdout.getTextStatus(statusLine.charAt(0)), CmdLineStatusPartFromStdout.getPropStatus(statusLine.charAt(1)));
            this.history = statusLine.charAt(3);
            this.path = statusLine.substring(40).trim();
            this.file = new File(this.path);
        }

        public boolean isCopied() {
            return this.history == '+';
        }

        private static SVNStatusKind getTextStatus(char statusChar) {
            switch (statusChar) {
                case ' ': {
                    return SVNStatusKind.NORMAL;
                }
                case 'A': {
                    return SVNStatusKind.ADDED;
                }
                case '!': {
                    return SVNStatusKind.MISSING;
                }
                case 'D': {
                    return SVNStatusKind.DELETED;
                }
                case 'R': {
                    return SVNStatusKind.REPLACED;
                }
                case 'M': {
                    return SVNStatusKind.MODIFIED;
                }
                case 'G': {
                    return SVNStatusKind.MERGED;
                }
                case 'C': {
                    return SVNStatusKind.CONFLICTED;
                }
                case '~': {
                    return SVNStatusKind.OBSTRUCTED;
                }
                case 'I': {
                    return SVNStatusKind.IGNORED;
                }
                case 'X': {
                    return SVNStatusKind.EXTERNAL;
                }
                case '?': {
                    return SVNStatusKind.UNVERSIONED;
                }
                case 'L': {
                    return SVNStatusKind.LOCKED;
                }
            }
            return SVNStatusKind.NONE;
        }

        private static SVNStatusKind getPropStatus(char statusChar) {
            switch (statusChar) {
                case ' ': {
                    return SVNStatusKind.NONE;
                }
                case 'C': {
                    return SVNStatusKind.CONFLICTED;
                }
                case 'M': {
                    return SVNStatusKind.MODIFIED;
                }
            }
            return SVNStatusKind.NORMAL;
        }

        public File getFile() {
            return this.file.getAbsoluteFile();
        }

        public String getPath() {
            return this.path;
        }

        public SVNStatusKind getRepositoryTextStatus() {
            return null;
        }

        public SVNStatusKind getRepositoryPropStatus() {
            return null;
        }
    }

    static class CmdLineStatusPartFromXml
    extends CmdLineStatusPart {
        private CmdLineStatusFromXml status;

        private CmdLineStatusPartFromXml(CmdLineStatusFromXml status) {
            super(status.getTextStatus(), status.getPropStatus());
            this.status = status;
        }

        public static CmdLineStatusPartFromXml[] createStatusParts(byte[] cmdLineResults) throws CmdLineException {
            CmdLineStatusFromXml[] statuses = CmdLineStatusFromXml.createStatuses(cmdLineResults);
            CmdLineStatusPartFromXml[] result = new CmdLineStatusPartFromXml[statuses.length];
            for (int i = 0; i < statuses.length; ++i) {
                result[i] = new CmdLineStatusPartFromXml(statuses[i]);
            }
            return result;
        }

        public File getFile() {
            return this.status.getFile();
        }

        public boolean isCopied() {
            return this.status.isCopied();
        }

        public SVNStatusKind getRepositoryTextStatus() {
            return this.status.getRepositoryTextStatus();
        }

        public SVNStatusKind getRepositoryPropStatus() {
            return this.status.getRepositoryPropStatus();
        }

        public String getPath() {
            return this.status.getPath();
        }
    }
}

