/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.File;
import java.text.MessageFormat;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.SVNAdmin;
import org.tigris.subversion.javahl.SVNClient;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.javahl.AbstractJhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlNotificationHandler;

public class JhlClientAdapter
extends AbstractJhlClientAdapter {
    private SVNAdmin svnAdmin;
    private static boolean availabilityCached = false;
    private static boolean available;
    private static StringBuffer javaHLErrors;

    public JhlClientAdapter() {
        this.svnClient = new SVNClient();
        this.svnAdmin = new SVNAdmin();
        this.notificationHandler = new JhlNotificationHandler();
        this.svnClient.notification2((Notify2)this.notificationHandler);
        this.svnClient.setPrompt((PromptUserPassword)new AbstractJhlClientAdapter.DefaultPromptUserPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAvailable() {
        if (!availabilityCached) {
            block43: {
                if (JhlClientAdapter.isOsWindows()) {
                    try {
                        System.loadLibrary("libapr");
                    }
                    catch (Exception e) {
                        javaHLErrors.append(e.getMessage()).append("\n");
                    }
                    catch (UnsatisfiedLinkError e) {
                        javaHLErrors.append(e.getMessage()).append("\n");
                    }
                    try {
                        System.loadLibrary("libapriconv");
                    }
                    catch (Exception e) {
                        javaHLErrors.append(e.getMessage()).append("\n");
                    }
                    catch (UnsatisfiedLinkError e) {
                        javaHLErrors.append(e.getMessage()).append("\n");
                    }
                    try {
                        System.loadLibrary("libeay32");
                    }
                    catch (Exception e) {
                        javaHLErrors.append(e.getMessage()).append("\n");
                    }
                    catch (UnsatisfiedLinkError e) {
                        javaHLErrors.append(e.getMessage()).append("\n");
                    }
                    try {
                        System.loadLibrary("libdb43");
                    }
                    catch (Exception e) {
                        javaHLErrors.append(e.getMessage()).append("\n");
                    }
                    catch (UnsatisfiedLinkError e) {
                        javaHLErrors.append(e.getMessage()).append("\n");
                    }
                    try {
                        System.loadLibrary("ssleay32");
                    }
                    catch (Exception e) {
                        javaHLErrors.append(e.getMessage()).append("\n");
                    }
                    catch (UnsatisfiedLinkError e) {
                        javaHLErrors.append(e.getMessage()).append("\n");
                    }
                    try {
                        System.loadLibrary("libaprutil");
                    }
                    catch (Exception e) {
                        javaHLErrors.append(e.getMessage()).append("\n");
                    }
                    catch (UnsatisfiedLinkError e) {
                        javaHLErrors.append(e.getMessage()).append("\n");
                    }
                    try {
                        System.loadLibrary("intl3_svn");
                    }
                    catch (Exception e) {
                        javaHLErrors.append(e.getMessage()).append("\n");
                    }
                    catch (UnsatisfiedLinkError e) {
                        javaHLErrors.append(e.getMessage()).append("\n");
                    }
                }
                available = false;
                try {
                    try {
                        String specifiedLibraryName = System.getProperty("subversion.native.library");
                        if (specifiedLibraryName != null) {
                            System.load(specifiedLibraryName);
                            available = true;
                        }
                    }
                    catch (UnsatisfiedLinkError ex) {
                        javaHLErrors.append(ex.getMessage()).append("\n");
                    }
                    if (available) break block43;
                    try {
                        System.loadLibrary("libsvnjavahl-1");
                    }
                    catch (UnsatisfiedLinkError ex) {
                        javaHLErrors.append(ex.getMessage() + "\n");
                        try {
                            System.loadLibrary("svnjavahl-1");
                        }
                        catch (UnsatisfiedLinkError e) {
                            javaHLErrors.append(e.getMessage()).append("\n");
                            System.loadLibrary("svnjavahl");
                        }
                    }
                    available = true;
                }
                catch (Exception e) {
                    available = false;
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                catch (UnsatisfiedLinkError e) {
                    available = false;
                    javaHLErrors.append(e.getMessage()).append("\n");
                }
                finally {
                    availabilityCached = true;
                }
            }
            if (!available) {
                String libraryPath = System.getProperty("java.library.path");
                if (libraryPath != null) {
                    javaHLErrors.append("java.library.path = " + libraryPath);
                }
            } else {
                try {
                    SVNClient svnClient = new SVNClient();
                    String dirname = svnClient.getAdminDirectoryName();
                    if (dirname != null) {
                        available = true;
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    available = false;
                    javaHLErrors.append("Incompatible JavaHL library loaded.  1.3.x or later required.");
                }
            }
        }
        return available;
    }

    public static String getLibraryLoadErrors() {
        if (JhlClientAdapter.isAvailable()) {
            return "";
        }
        return javaHLErrors.toString();
    }

    public void createRepository(File path, String repositoryType) throws SVNClientException {
        try {
            if (repositoryType == null) {
                repositoryType = "bdb";
            }
            this.notificationHandler.setCommand(23);
            String target = JhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine(MessageFormat.format("create --fstype {0} {1}", repositoryType, target));
            this.svnAdmin.create(target, false, false, null, repositoryType);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public boolean statusReturnsRemoteInfo() {
        return true;
    }

    static {
        javaHLErrors = new StringBuffer("Failed to load JavaHL Library.\nThese are the errors that were encountered:\n");
    }
}

