/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.utils;

import java.io.IOException;
import java.io.OutputStream;
import org.tigris.subversion.svnclientadapter.utils.ReaderThread;

public class Command {
    private Process process = null;
    private String command;
    private String[] parameters = new String[0];
    private OutputStream out = System.out;
    private OutputStream err = System.err;

    public Command(String command) {
        this.command = command;
    }

    public void setErr(OutputStream err) {
        this.err = err;
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    public void setParameters(String[] parameters) {
        this.parameters = parameters;
    }

    public Process getProcess() {
        return this.process;
    }

    public void kill() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
    }

    public void exec() throws IOException {
        String[] cmdArray = new String[this.parameters.length + 1];
        cmdArray[0] = this.command;
        System.arraycopy(this.parameters, 0, cmdArray, 1, this.parameters.length);
        this.process = Runtime.getRuntime().exec(cmdArray);
        if (this.process != null) {
            new ReaderThread(this.process.getInputStream(), this.out).start();
            new ReaderThread(this.process.getErrorStream(), this.err).start();
        }
    }

    public int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }
}

