/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.updatecenters.resources;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.autoupdate.AutoupdateClusterCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetBeansClusterCreator
extends AutoupdateClusterCreator {
    protected File findCluster(String clusterName) {
        File[] parent = new File[1];
        File conf = NetBeansClusterCreator.findConf(parent, new ArrayList());
        return conf != null && conf.isFile() && conf.canWrite() ? new File(parent[0], clusterName) : null;
    }

    private static File findConf(File[] parent, List<? super File> clusters) {
        StringTokenizer tok = new StringTokenizer(System.getProperty("netbeans.dirs"), File.pathSeparator);
        while (tok.hasMoreElements()) {
            File cluster = new File(tok.nextToken());
            clusters.add(cluster);
            if (!cluster.exists()) continue;
            if (parent[0] == null) {
                parent[0] = cluster.getParentFile();
            }
            if (parent[0].equals(cluster.getParentFile())) continue;
            return null;
        }
        return new File(new File(parent[0], "etc"), "netbeans.clusters");
    }

    protected File[] registerCluster(String clusterName, File cluster) throws IOException {
        File[] parent = new File[1];
        ArrayList<File> clusters = new ArrayList<File>();
        File conf = NetBeansClusterCreator.findConf(parent, clusters);
        assert (conf != null);
        clusters.add(cluster);
        FileOutputStream os = new FileOutputStream(conf, true);
        ((OutputStream)os).write(10);
        ((OutputStream)os).write(clusterName.getBytes());
        ((OutputStream)os).write(10);
        ((OutputStream)os).close();
        return clusters.toArray(new File[0]);
    }
}

