/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.netbeans.PatchByteCode;
import org.netbeans.ProxyClassLoader;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarClassLoader
extends ProxyClassLoader {
    private static final Logger LOGGER = Logger.getLogger(JarClassLoader.class.getName());
    private Source[] sources;
    private Set<JarFile> deadJars = null;

    public JarClassLoader(List<Union2<File, JarFile>> files, ClassLoader[] parents) {
        this(files, parents, true);
    }

    public JarClassLoader(List<Union2<File, JarFile>> files, ClassLoader[] parents, boolean transitive) {
        super(parents, transitive);
        this.sources = new Source[files.size()];
        try {
            int i = 0;
            for (Union2<File, JarFile> file : files) {
                if (file.hasFirst()) {
                    this.sources[i++] = new DirSource((File)file.first(), this);
                    continue;
                }
                this.sources[i++] = new JarSource((JarFile)file.second(), this);
            }
        }
        catch (MalformedURLException exc) {
            throw new IllegalArgumentException(exc.getMessage());
        }
    }

    final void addSources(List<Union2<File, JarFile>> newSources) {
        ArrayList<Source> l = new ArrayList<Source>(this.sources.length + newSources.size());
        l.addAll(Arrays.asList(this.sources));
        try {
            for (Union2<File, JarFile> file : newSources) {
                if (file.hasFirst()) {
                    l.add(new DirSource((File)file.first(), this));
                    continue;
                }
                l.add(new JarSource((JarFile)file.second(), this));
            }
        }
        catch (MalformedURLException exc) {
            throw new IllegalArgumentException(exc.getMessage());
        }
        this.sources = l.toArray(this.sources);
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        return Policy.getPolicy().getPermissions(cs);
    }

    protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        if (man == null) {
            return this.definePackage(name, null, null, null, null, null, null, null);
        }
        String path = name.replace('.', '/').concat("/");
        Attributes spec = man.getAttributes(path);
        Attributes main = man.getMainAttributes();
        String specTitle = JarClassLoader.getAttr(spec, main, Attributes.Name.SPECIFICATION_TITLE);
        String implTitle = JarClassLoader.getAttr(spec, main, Attributes.Name.IMPLEMENTATION_TITLE);
        String specVersion = JarClassLoader.getAttr(spec, main, Attributes.Name.SPECIFICATION_VERSION);
        String implVersion = JarClassLoader.getAttr(spec, main, Attributes.Name.IMPLEMENTATION_VERSION);
        String specVendor = JarClassLoader.getAttr(spec, main, Attributes.Name.SPECIFICATION_VENDOR);
        String implVendor = JarClassLoader.getAttr(spec, main, Attributes.Name.IMPLEMENTATION_VENDOR);
        String sealed = JarClassLoader.getAttr(spec, main, Attributes.Name.SEALED);
        URL sealBase = "true".equalsIgnoreCase(sealed) ? url : null;
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    private static String getAttr(Attributes spec, Attributes main, Attributes.Name name) {
        String val = null;
        if (spec != null) {
            val = spec.getValue(name);
        }
        if (val == null && main != null) {
            val = main.getValue(name);
        }
        return val;
    }

    @Override
    protected Class simpleFindClass(String name, String path, String pkgnameSlashes) {
        for (int i = 0; i < this.sources.length; ++i) {
            Source src = this.sources[i];
            byte[] data = src.getClassData(name, path);
            if (data == null) continue;
            byte[] d = PatchByteCode.patch(data, name);
            data = d;
            int j = name.lastIndexOf(46);
            String pkgName = name.substring(0, j);
            Package pkg = this.getPackageFast(pkgName, pkgnameSlashes, this.isSpecialResource(pkgnameSlashes));
            if (pkg != null) {
                if (pkg.isSealed() && !pkg.isSealed(src.getURL())) {
                    throw new SecurityException("sealing violation");
                }
            } else {
                Manifest man = src.getManifest();
                this.definePackage(pkgName, man, src.getURL());
            }
            return this.defineClass(name, data, 0, data.length, src.getProtectionDomain());
        }
        return null;
    }

    @Override
    protected URL findResource(String name) {
        for (int i = 0; i < this.sources.length; ++i) {
            URL item = this.sources[i].getResource(name);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> simpleFindResources(String name) {
        Vector<URL> v = new Vector<URL>(3);
        for (int i = 0; i < this.sources.length; ++i) {
            URL item = this.sources[i].getResource(name);
            if (item == null) continue;
            v.add(item);
        }
        return v.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        super.destroy();
        assert (this.deadJars == null) : "Already had dead JARs: " + this.deadJars;
        this.deadJars = new HashSet<JarFile>();
        try {
            for (int i = 0; i < this.sources.length; ++i) {
                String suffix;
                String prefix;
                JarFile origJar;
                File orig;
                if (!(this.sources[i] instanceof JarSource) || !(orig = new File((origJar = ((JarSource)this.sources[i]).getJarFile()).getName())).isFile()) continue;
                String name = orig.getName();
                int idx = name.lastIndexOf(46);
                if (idx == -1) {
                    prefix = name;
                    suffix = null;
                } else {
                    prefix = name.substring(0, idx);
                    suffix = name.substring(idx);
                }
                while (prefix.length() < 3) {
                    prefix = prefix + "x";
                }
                File temp = File.createTempFile(prefix, suffix);
                temp.deleteOnExit();
                FileInputStream is = new FileInputStream(orig);
                try {
                    FileOutputStream os = new FileOutputStream(temp);
                    try {
                        int j;
                        byte[] buf = new byte[4096];
                        while ((j = ((InputStream)is).read(buf)) != -1) {
                            ((OutputStream)os).write(buf, 0, j);
                        }
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                }
                finally {
                    ((InputStream)is).close();
                }
                JarFile tempJar = new JarFile(temp);
                origJar.close();
                this.deadJars.add(tempJar);
                this.sources[i] = new JarSource(tempJar, this);
                LOGGER.log(Level.FINE, "#21114: replacing {0} with {1}", new Object[]{orig, temp});
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, null, ioe);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        for (int i = 0; i < this.sources.length; ++i) {
            if (!(this.sources[i] instanceof JarSource)) continue;
            JarFile j = ((JarSource)this.sources[i]).getJarFile();
            File f = new File(j.getName());
            j.close();
            if (this.deadJars == null || !this.deadJars.contains(j)) continue;
            LOGGER.log(Level.FINE, "#21114: closing and deleting temporary JAR {0}", f);
            if (!f.isFile() || f.delete()) continue;
            LOGGER.log(Level.FINE, "(but failed to delete {0})", f);
        }
    }

    static class DirSource
    extends Source {
        File dir;

        public DirSource(File file, JarClassLoader jcl) throws MalformedURLException {
            super(file.toURI().toURL(), jcl);
            this.dir = file;
        }

        protected URL doGetResource(String name) throws MalformedURLException {
            File resFile = new File(this.dir, name);
            return resFile.exists() ? resFile.toURI().toURL() : null;
        }

        protected byte[] readClass(String name, String path) throws IOException {
            File clsFile = new File(this.dir, path.replace('/', File.separatorChar));
            if (!clsFile.exists()) {
                return null;
            }
            int len = (int)clsFile.length();
            byte[] data = new byte[len];
            FileInputStream is = new FileInputStream(clsFile);
            for (int count = 0; count < len; count += ((InputStream)is).read(data, count, len - count)) {
            }
            return data;
        }
    }

    static class JarSource
    extends Source {
        JarFile src;
        private String resPrefix;

        public JarSource(JarFile file, JarClassLoader jcl) throws MalformedURLException {
            super(new File(file.getName()).toURI().toURL(), jcl);
            this.src = file;
            this.resPrefix = "jar:" + new File(this.src.getName()).toURI() + "!/";
        }

        public Manifest getManifest() {
            try {
                return this.src.getManifest();
            }
            catch (IOException e) {
                return null;
            }
        }

        JarFile getJarFile() {
            return this.src;
        }

        protected URL doGetResource(String name) throws MalformedURLException {
            ZipEntry ze;
            try {
                ze = this.src.getEntry(name);
            }
            catch (IllegalStateException ex) {
                return null;
            }
            if (ze == null) {
                return null;
            }
            LOGGER.log(Level.FINER, "Loading {0} from {1}", new Object[]{name, this.src.getName()});
            return new URL(this.resPrefix + ze.getName());
        }

        protected byte[] readClass(String name, String path) throws IOException {
            ZipEntry ze;
            try {
                ze = this.src.getEntry(path);
            }
            catch (IllegalStateException ex) {
                return null;
            }
            if (ze == null) {
                return null;
            }
            LOGGER.log(Level.FINER, "Loading {0} from {1}", new Object[]{path, this.src.getName()});
            int len = (int)ze.getSize();
            byte[] data = new byte[len];
            InputStream is = this.src.getInputStream(ze);
            for (int count = 0; count < len; count += is.read(data, count, len - count)) {
            }
            return data;
        }
    }

    static abstract class Source {
        private URL url;
        private ProtectionDomain pd;
        protected JarClassLoader jcl;

        public Source(URL url, JarClassLoader jcl) {
            this.url = url;
            this.jcl = jcl;
        }

        public final URL getURL() {
            return this.url;
        }

        public final ProtectionDomain getProtectionDomain() {
            if (this.pd == null) {
                CodeSource cs = new CodeSource(this.url, new Certificate[0]);
                this.pd = new ProtectionDomain(cs, this.jcl.getPermissions(cs));
            }
            return this.pd;
        }

        public final URL getResource(String name) {
            try {
                return this.doGetResource(name);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, null, e);
                return null;
            }
        }

        protected abstract URL doGetResource(String var1) throws MalformedURLException;

        public final byte[] getClassData(String name, String path) {
            try {
                return this.readClass(name, path);
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, null, e);
                return null;
            }
        }

        protected abstract byte[] readClass(String var1, String var2) throws IOException;

        public Manifest getManifest() {
            return null;
        }
    }
}

