/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.ModuleManager;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Union2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Module
extends ModuleInfo {
    public static final String PROP_RELOADABLE = "reloadable";
    public static final String PROP_CLASS_LOADER = "classLoader";
    public static final String PROP_MANIFEST = "manifest";
    public static final String PROP_VALID = "valid";
    public static final String PROP_PROBLEMS = "problems";
    protected Manifest manifest;
    protected final ModuleManager mgr;
    protected final Events events;
    private final Object history;
    private boolean enabled;
    private final boolean autoload;
    protected boolean reloadable;
    private final boolean eager;
    private String codeNameBase;
    private int codeNameRelease;
    private String codeName;
    private String[] provides;
    private Dependency[] dependenciesA;
    private SpecificationVersion specVers;
    protected ClassLoader classloader = null;
    private PackageExport[] publicPackages;
    private Set friendNames;

    protected Module(ModuleManager mgr, Events ev, Object history, boolean reloadable, boolean autoload, boolean eager) throws IOException {
        if (autoload && eager) {
            throw new IllegalArgumentException("A module may not be both autoload and eager");
        }
        this.mgr = mgr;
        this.events = ev;
        this.history = history;
        this.reloadable = reloadable;
        this.autoload = autoload;
        this.eager = eager;
        this.enabled = false;
    }

    protected Module(ModuleManager mgr, Events ev, Manifest manifest, Object history, ClassLoader classloader) throws InvalidException {
        this.mgr = mgr;
        this.events = ev;
        this.manifest = manifest;
        this.history = history;
        this.classloader = classloader;
        this.reloadable = false;
        this.autoload = false;
        this.eager = false;
        this.enabled = false;
    }

    public ModuleManager getManager() {
        return this.mgr;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    void setEnabled(boolean enabled) {
        if (this.isFixed() && !enabled) {
            throw new IllegalStateException("Cannot disable a fixed module: " + (Object)((Object)this));
        }
        this.enabled = enabled;
    }

    public boolean isValid() {
        return this.mgr.get(this.getCodeNameBase()) == this;
    }

    public boolean isAutoload() {
        return this.autoload;
    }

    public boolean isEager() {
        return this.eager;
    }

    public Object getAttribute(String attr) {
        return this.getManifest().getMainAttributes().getValue(attr);
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getCodeNameBase() {
        return this.codeNameBase;
    }

    public int getCodeNameRelease() {
        return this.codeNameRelease;
    }

    public String[] getProvides() {
        return this.provides;
    }

    public final boolean provides(String token) {
        for (int i = 0; i < this.provides.length; ++i) {
            if (!this.provides[i].equals(token)) continue;
            return true;
        }
        return false;
    }

    public Set<Dependency> getDependencies() {
        return new HashSet<Dependency>(Arrays.asList(this.dependenciesA));
    }

    public final Dependency[] getDependenciesArray() {
        return this.dependenciesA;
    }

    public SpecificationVersion getSpecificationVersion() {
        return this.specVers;
    }

    public boolean owns(Class clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof Util.ModuleProvider) {
            return ((Util.ModuleProvider)((Object)cl)).getModule() == this;
        }
        return false;
    }

    public PackageExport[] getPublicPackages() {
        return this.publicPackages;
    }

    boolean isDeclaredAsFriend(Module module) {
        if (this.friendNames == null) {
            return true;
        }
        return this.friendNames.contains(module.getCodeNameBase());
    }

    protected void parseManifest() throws InvalidException {
        Attributes attr = this.manifest.getMainAttributes();
        this.codeName = attr.getValue("OpenIDE-Module");
        if (this.codeName == null) {
            InvalidException e = new InvalidException("Not a module: no OpenIDE-Module tag in manifest of " + (Object)((Object)this));
            Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(Module.class, (String)"EXC_not_a_module", (Object)this.toString()));
            throw e;
        }
        try {
            String exportsS;
            if (this.codeName.indexOf(44) != -1) {
                throw new InvalidException("Illegal code name syntax parsing OpenIDE-Module: " + this.codeName);
            }
            Dependency.create((int)1, (String)this.codeName);
            Object[] cnParse = Util.parseCodeName(this.codeName);
            this.codeNameBase = (String)cnParse[0];
            int n = this.codeNameRelease = cnParse[1] != null ? (Integer)cnParse[1] : -1;
            if (cnParse[2] != null) {
                throw new NumberFormatException(this.codeName);
            }
            String specVersS = attr.getValue("OpenIDE-Module-Specification-Version");
            if (specVersS != null) {
                try {
                    this.specVers = new SpecificationVersion(specVersS);
                }
                catch (NumberFormatException nfe) {
                    throw (InvalidException)new InvalidException("While parsing OpenIDE-Module-Specification-Version: " + nfe.toString()).initCause(nfe);
                }
            } else {
                this.specVers = null;
            }
            String providesS = attr.getValue("OpenIDE-Module-Provides");
            if (providesS == null) {
                this.provides = new String[0];
            } else {
                StringTokenizer tok = new StringTokenizer(providesS, ", ");
                this.provides = new String[tok.countTokens()];
                for (int i = 0; i < this.provides.length; ++i) {
                    String provide = tok.nextToken();
                    if (provide.indexOf(44) != -1) {
                        throw new InvalidException("Illegal code name syntax parsing OpenIDE-Module-Provides: " + provide);
                    }
                    Dependency.create((int)1, (String)provide);
                    if (provide.lastIndexOf(47) != -1) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Provides: " + provide);
                    }
                    this.provides[i] = provide;
                }
                if (new HashSet<String>(Arrays.asList(this.provides)).size() < this.provides.length) {
                    throw new IllegalArgumentException("Duplicate entries in OpenIDE-Module-Provides: " + providesS);
                }
            }
            String[] additionalProvides = this.mgr.refineProvides(this);
            if (additionalProvides != null) {
                if (this.provides == null) {
                    this.provides = additionalProvides;
                } else {
                    ArrayList<String> l = new ArrayList<String>();
                    l.addAll(Arrays.asList(this.provides));
                    l.addAll(Arrays.asList(additionalProvides));
                    this.provides = l.toArray(this.provides);
                }
            }
            if ((exportsS = attr.getValue("OpenIDE-Module-Public-Packages")) != null) {
                if (exportsS.trim().equals("-")) {
                    this.publicPackages = new PackageExport[0];
                } else {
                    StringTokenizer tok = new StringTokenizer(exportsS, ", ");
                    ArrayList<PackageExport> exports = new ArrayList<PackageExport>(Math.max(tok.countTokens(), 1));
                    while (tok.hasMoreTokens()) {
                        String pkg;
                        String piece = tok.nextToken();
                        if (piece.endsWith(".*")) {
                            pkg = piece.substring(0, piece.length() - 2);
                            Dependency.create((int)1, (String)pkg);
                            if (pkg.lastIndexOf(47) != -1) {
                                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
                            }
                            exports.add(new PackageExport(pkg.replace('.', '/') + '/', false));
                            continue;
                        }
                        if (piece.endsWith(".**")) {
                            pkg = piece.substring(0, piece.length() - 3);
                            Dependency.create((int)1, (String)pkg);
                            if (pkg.lastIndexOf(47) != -1) {
                                throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
                            }
                            exports.add(new PackageExport(pkg.replace('.', '/') + '/', true));
                            continue;
                        }
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
                    }
                    if (exports.isEmpty()) {
                        throw new IllegalArgumentException("Illegal OpenIDE-Module-Public-Packages: " + exportsS);
                    }
                    this.publicPackages = exports.toArray(new PackageExport[exports.size()]);
                }
            } else {
                Util.err.warning("module " + this.codeNameBase + " does not declare OpenIDE-Module-Public-Packages in its manifest, so all packages are considered public by default: http://www.netbeans.org/download/dev/javadoc/OpenAPIs/org/openide/doc-files/upgrade.html#3.4-public-packages");
                this.publicPackages = null;
            }
            String friends = attr.getValue("OpenIDE-Module-Friends");
            if (friends != null) {
                StringTokenizer tok = new StringTokenizer(friends, ", ");
                HashSet<String> set = new HashSet<String>();
                while (tok.hasMoreTokens()) {
                    String piece = tok.nextToken();
                    if (piece.indexOf(47) != -1) {
                        throw new IllegalArgumentException("May specify only module code name bases in OpenIDE-Module-Friends, not major release versions: " + piece);
                    }
                    Dependency.create((int)1, (String)piece);
                    set.add(piece);
                }
                if (set.isEmpty()) {
                    throw new IllegalArgumentException("Empty OpenIDE-Module-Friends: " + friends);
                }
                if (this.publicPackages == null || this.publicPackages.length == 0) {
                    throw new IllegalArgumentException("No use specifying OpenIDE-Module-Friends without any public packages: " + friends);
                }
                this.friendNames = set;
            }
            HashSet<Dependency> dependencies = new HashSet<Dependency>(20);
            Set openideDeps = Dependency.create((int)4, (String)attr.getValue("OpenIDE-Module-IDE-Dependencies"));
            if (!openideDeps.isEmpty()) {
                Dependency d = (Dependency)openideDeps.iterator().next();
                String name = d.getName();
                if (!name.startsWith("IDE/")) {
                    throw new IllegalStateException("Weird IDE dep: " + name);
                }
                dependencies.addAll(Dependency.create((int)1, (String)("org.openide/" + name.substring(4) + " > " + d.getVersion())));
                if (dependencies.size() != 1) {
                    throw new IllegalStateException("Should be singleton: " + dependencies);
                }
                Util.err.warning("the module " + this.codeNameBase + " uses OpenIDE-Module-IDE-Dependencies which is deprecated. See http://openide.netbeans.org/proposals/arch/modularize.html");
            }
            dependencies.addAll(Dependency.create((int)3, (String)attr.getValue("OpenIDE-Module-Java-Dependencies")));
            dependencies.addAll(Dependency.create((int)1, (String)attr.getValue("OpenIDE-Module-Module-Dependencies")));
            String pkgdeps = attr.getValue("OpenIDE-Module-Package-Dependencies");
            if (pkgdeps != null) {
                dependencies.addAll(Dependency.create((int)2, (String)pkgdeps));
            }
            dependencies.addAll(Dependency.create((int)5, (String)attr.getValue("OpenIDE-Module-Requires")));
            dependencies.addAll(Dependency.create((int)6, (String)attr.getValue("OpenIDE-Module-Needs")));
            dependencies.addAll(Dependency.create((int)7, (String)attr.getValue("OpenIDE-Module-Recommends")));
            this.mgr.refineDependencies(this, dependencies);
            this.dependenciesA = dependencies.toArray(new Dependency[dependencies.size()]);
        }
        catch (IllegalArgumentException iae) {
            throw (InvalidException)new InvalidException("While parsing " + this.codeName + " a dependency attribute: " + iae.toString()).initCause(iae);
        }
    }

    public abstract List<File> getAllJars();

    public boolean isReloadable() {
        return this.reloadable;
    }

    public abstract void setReloadable(boolean var1);

    public abstract void reload() throws IOException;

    public ClassLoader getClassLoader() throws IllegalArgumentException {
        if (!this.enabled) {
            throw new IllegalArgumentException("Not enabled: " + this.codeNameBase);
        }
        assert (this.classloader != null) : "Should have had a non-null loader for " + (Object)((Object)this);
        return this.classloader;
    }

    protected abstract void classLoaderUp(Set<Module> var1) throws IOException;

    protected abstract void classLoaderDown();

    protected abstract void cleanup();

    protected abstract void destroy();

    public abstract boolean isFixed();

    public File getJarFile() {
        return null;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public Set<Object> getProblems() {
        if (!this.isValid()) {
            throw new IllegalStateException("Not valid: " + (Object)((Object)this));
        }
        if (this.isEnabled()) {
            return Collections.emptySet();
        }
        HashSet<Object> problems = new HashSet<Object>();
        for (Union2<Dependency, InvalidException> problem : this.mgr.missingDependencies(this)) {
            if (problem.hasFirst()) {
                problems.add(problem.first());
                continue;
            }
            problems.add(problem.second());
        }
        return problems;
    }

    final void firePropertyChange0(String prop, Object old, Object nue) {
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.fine("Module.propertyChange: " + (Object)((Object)this) + " " + prop + ": " + old + " -> " + nue);
        }
        this.firePropertyChange(prop, old, nue);
    }

    public final Object getHistory() {
        return this.history;
    }

    public String toString() {
        String s = "Module:" + this.getCodeNameBase();
        if (!this.isValid()) {
            s = s + "[invalid]";
        }
        return s;
    }

    public static final class PackageExport {
        public final String pkg;
        public final boolean recursive;

        public PackageExport(String pkg, boolean recursive) {
            this.pkg = pkg;
            this.recursive = recursive;
        }

        public String toString() {
            return "PackageExport[" + this.pkg + (this.recursive ? "**/" : "") + "]";
        }
    }
}

