/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.ModuleFactory;
import org.netbeans.Util;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyClassLoader
extends ClassLoader
implements Util.PackageAccessibleClassLoader {
    private static final Logger LOGGER = Logger.getLogger(ProxyClassLoader.class.getName());
    private final Map<String, ClassLoader> domainsByPackage = new HashMap<String, ClassLoader>();
    private final Map<String, Package> packages = new HashMap<String, Package>();
    private ClassLoader[] parents;
    private boolean dead = false;
    private final boolean transitive;

    public ProxyClassLoader(ClassLoader[] parents) {
        this(parents, true);
    }

    public ProxyClassLoader(ClassLoader[] parents, boolean transitive) {
        if (parents.length == 0) {
            throw new IllegalArgumentException("ProxyClassLoader must have a parent");
        }
        this.transitive = transitive;
        HashSet<ClassLoader> check = new HashSet<ClassLoader>(Arrays.asList(parents));
        if (check.size() < parents.length) {
            throw new IllegalArgumentException("duplicate parents");
        }
        if (check.contains(null)) {
            throw new IllegalArgumentException("null parent in " + check);
        }
        this.parents = this.coalesceParents(parents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(ClassLoader[] nueparents) throws IllegalArgumentException {
        if (nueparents == null) {
            throw new IllegalArgumentException("null parents array");
        }
        for (int i = 0; i < nueparents.length; ++i) {
            if (nueparents[i] != null) continue;
            throw new IllegalArgumentException("null parent");
        }
        ClassLoader[] resParents = null;
        ModuleFactory moduleFactory = (ModuleFactory)Lookup.getDefault().lookup(ModuleFactory.class);
        resParents = moduleFactory != null && moduleFactory.removeBaseClassLoader() ? this.coalesceAppend(new ClassLoader[0], nueparents) : this.coalesceAppend(this.parents, nueparents);
        ProxyClassLoader proxyClassLoader = this;
        synchronized (proxyClassLoader) {
            this.parents = resParents;
        }
    }

    public void destroy() {
        this.dead = true;
    }

    private void zombieCheck(String hint) {
        if (this.dead) {
            this.dead = false;
        }
    }

    @Override
    protected final synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        this.zombieCheck(name);
        String filename = name.replace('.', '/').concat(".class");
        int idx = filename.lastIndexOf(47);
        if (idx == -1) {
            throw new ClassNotFoundException("Will not load classes from default package (" + name + ")");
        }
        String pkg = filename.substring(0, idx + 1);
        Class c = this.smartLoadClass(name, filename, pkg);
        if (c == null) {
            throw new ClassNotFoundException(name + " from " + this);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected Class simpleFindClass(String name, String fileName, String pkg) {
        return null;
    }

    private String stripInitialSlash(String resource) {
        if (resource.startsWith("/")) {
            LOGGER.log(Level.WARNING, "Should not use initial '/' in calls to ClassLoader.getResource(s): {0}", resource);
            return resource.substring(1);
        }
        return resource;
    }

    @Override
    public final URL getResource(String name) {
        String pkg;
        this.zombieCheck(name);
        name = this.stripInitialSlash(name);
        int slashIdx = name.lastIndexOf(47);
        if (slashIdx == -1) {
            ProxyClassLoader.printDefaultPackageWarning(name);
        }
        if (this.isSpecialResource(pkg = name.substring(0, slashIdx + 1))) {
            for (int i = 0; i < this.parents.length; ++i) {
                URL u;
                if (!this.shouldDelegateResource(pkg, this.parents[i]) || (u = this.parents[i] instanceof ProxyClassLoader ? ((ProxyClassLoader)this.parents[i]).findResource(name) : this.parents[i].getResource(name)) == null) continue;
                return u;
            }
            return this.findResource(name);
        }
        ClassLoader owner = this.domainsByPackage.get(pkg);
        if (owner != null) {
            if (owner instanceof ProxyClassLoader) {
                return ((ProxyClassLoader)owner).findResource(name);
            }
            return owner.getResource(name);
        }
        URL retVal = null;
        for (int i = 0; i < this.parents.length; ++i) {
            owner = this.parents[i];
            if (!this.shouldDelegateResource(pkg, owner) || (retVal = owner instanceof ProxyClassLoader ? ((ProxyClassLoader)owner).findResource(name) : owner.getResource(name)) == null) continue;
            String p = new String(pkg).intern();
            this.domainsByPackage.put(p, owner);
            if (owner instanceof ProxyClassLoader) {
                ((ProxyClassLoader)owner).domainsByPackage.put(p, owner);
            }
            return retVal;
        }
        retVal = this.findResource(name);
        if (retVal != null) {
            this.domainsByPackage.put(new String(pkg).intern(), this);
        }
        return retVal;
    }

    @Override
    protected URL findResource(String name) {
        return null;
    }

    @Override
    protected final synchronized Enumeration<URL> findResources(String name) throws IOException {
        this.zombieCheck(name);
        name = this.stripInitialSlash(name);
        int slashIdx = name.lastIndexOf(47);
        if (slashIdx == -1) {
            ProxyClassLoader.printDefaultPackageWarning(name);
        }
        String pkg = name.substring(0, slashIdx + 1);
        ArrayList<Enumeration<URL>> es = new ArrayList<Enumeration<URL>>(this.parents.length + 1);
        for (ClassLoader parent : this.parents) {
            if (!this.shouldDelegateResource(pkg, parent)) continue;
            if (parent instanceof ProxyClassLoader) {
                es.add(((ProxyClassLoader)parent).simpleFindResources(name));
                continue;
            }
            es.add(parent.getResources(name));
        }
        es.add(this.simpleFindResources(name));
        return Enumerations.concat(Collections.enumeration(es));
    }

    protected Enumeration<URL> simpleFindResources(String name) throws IOException {
        return super.findResources(name);
    }

    @Override
    protected Package getPackage(String name) {
        this.zombieCheck(name);
        return this.getPackageFast(name, name.replace('.', '/') + '/', true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackageFast(String name, String sname, boolean recurse) {
        Map<String, Package> map = this.packages;
        synchronized (map) {
            ClassLoader par;
            Package pkg = this.packages.get(name);
            if (pkg != null) {
                return pkg;
            }
            if (!recurse) {
                return null;
            }
            for (int i = 0; !(i >= this.parents.length || (par = this.parents[i]) instanceof ProxyClassLoader && this.shouldDelegateResource(sname, par) && (pkg = ((ProxyClassLoader)par).getPackageFast(name, sname, false)) != null); ++i) {
            }
            if (pkg == null && this.shouldDelegateResource(sname, this.getParent())) {
                pkg = super.getPackage(name);
            }
            if (pkg != null) {
                this.packages.put(name, pkg);
            }
            return pkg;
        }
    }

    @Override
    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        Map<String, Package> map = this.packages;
        synchronized (map) {
            try {
                Package pkg = super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
                this.packages.put(name, pkg);
                return pkg;
            }
            catch (IllegalArgumentException x) {
                Exceptions.attachMessage((Throwable)x, (String)"If you are getting this, probably it is because you have several modules trying to load from the same package. This is not supported (#71524).");
                throw x;
            }
        }
    }

    @Override
    protected synchronized Package[] getPackages() {
        return this.getPackages(new HashSet<ClassLoader>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Package[] getPackages(Set<ClassLoader> addedParents) {
        this.zombieCheck(null);
        HashMap<String, Package> all = new HashMap<String, Package>();
        this.addPackages(all, super.getPackages());
        for (int i = 0; i < this.parents.length; ++i) {
            ClassLoader par = this.parents[i];
            if (!(par instanceof ProxyClassLoader) || !addedParents.add(par)) continue;
            this.addPackages(all, ((ProxyClassLoader)par).getPackages(addedParents));
        }
        Map<String, Package> map = this.packages;
        synchronized (map) {
            all.keySet().removeAll(this.packages.keySet());
            this.packages.putAll(all);
        }
        return this.packages.values().toArray(new Package[this.packages.size()]);
    }

    @Override
    public Package getPackageAccessibly(String name) {
        return this.getPackage(name);
    }

    @Override
    public Package[] getPackagesAccessibly() {
        return this.getPackages();
    }

    private static void printDefaultPackageWarning(String name) {
        if (!"commons-logging.properties".equals(name) && !"jndi.properties".equals(name)) {
            LOGGER.log(Level.INFO, null, new IllegalStateException("You are trying to access file: " + name + " from the default package. Please see http://www.netbeans.org/download/dev/javadoc/org-openide-modules/org/openide/modules/doc-files/classpath.html#default_package"));
        }
    }

    private ClassLoader[] coalesceParents(ClassLoader[] loaders) throws IllegalArgumentException {
        int likelySize = loaders.length * 5 + 10;
        HashSet<ClassLoader> resultingUnique = new HashSet<ClassLoader>(likelySize);
        ArrayList<ClassLoader> resulting = new ArrayList<ClassLoader>(likelySize);
        for (int i = 0; i < loaders.length; ++i) {
            this.addRec(resultingUnique, resulting, loaders[i]);
        }
        ClassLoader[] ret = resulting.toArray(new ClassLoader[resulting.size()]);
        return ret;
    }

    private ClassLoader[] coalesceAppend(ClassLoader[] existing, ClassLoader[] appended) throws IllegalArgumentException {
        int likelySize = existing.length + 3;
        HashSet<ClassLoader> resultingUnique = new HashSet<ClassLoader>(likelySize);
        List<ClassLoader> existingL = Arrays.asList(existing);
        resultingUnique.addAll(existingL);
        if (resultingUnique.containsAll(Arrays.asList(appended))) {
            return existing;
        }
        ArrayList<ClassLoader> resulting = new ArrayList<ClassLoader>(likelySize);
        resulting.addAll(existingL);
        for (int i = 0; i < appended.length; ++i) {
            this.addRec(resultingUnique, resulting, appended[i]);
        }
        ClassLoader[] ret = resulting.toArray(new ClassLoader[resulting.size()]);
        return ret;
    }

    private void addRec(Set<ClassLoader> resultingUnique, List<ClassLoader> resulting, ClassLoader loader) throws IllegalArgumentException {
        if (loader == this) {
            throw new IllegalArgumentException("cycle in parents");
        }
        if (resultingUnique.contains(loader)) {
            return;
        }
        if (loader instanceof ProxyClassLoader && ((ProxyClassLoader)loader).transitive) {
            ClassLoader[] parents = ((ProxyClassLoader)loader).parents;
            for (int i = 0; i < parents.length; ++i) {
                this.addRec(resultingUnique, resulting, parents[i]);
            }
        }
        resultingUnique.add(loader);
        resulting.add(loader);
    }

    private final Class smartLoadClass(String name, String fileName, String pkg) throws ClassNotFoundException {
        ClassLoader owner;
        Class c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        ClassLoader classLoader = owner = this.isSpecialResource(pkg) ? null : this.domainsByPackage.get(pkg);
        if (owner == this) {
            return this.simpleFindClass(name, fileName, pkg);
        }
        if (owner != null) {
            if (owner instanceof ProxyClassLoader) {
                return ((ProxyClassLoader)owner).fullFindClass(name, fileName, pkg);
            }
            return owner.loadClass(name);
        }
        c = this.loadInOrder(name, fileName, pkg);
        if (c != null) {
            ClassLoader owner2 = ProxyClassLoader.getClassClassLoader(c);
            this.domainsByPackage.put(new String(pkg).intern(), owner2);
        }
        return c;
    }

    private static ClassLoader getClassClassLoader(final Class c) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return c.getClassLoader();
            }
        });
    }

    private final Class loadInOrder(String name, String fileName, String pkg) throws ClassNotFoundException {
        ClassNotFoundException cached = null;
        for (int i = 0; i < this.parents.length; ++i) {
            ClassLoader par = this.parents[i];
            if (!this.shouldDelegateResource(pkg, par)) continue;
            if (par instanceof ProxyClassLoader && ((ProxyClassLoader)par).shouldBeCheckedAsParentProxyClassLoader()) {
                ProxyClassLoader pcl = (ProxyClassLoader)par;
                Class c = pcl.fullFindClass(name, fileName, pkg);
                if (c == null || !pcl.transitive && ProxyClassLoader.getClassClassLoader(c) != pcl) continue;
                return c;
            }
            boolean skip = false;
            if (this.optimizeNBLoading() && (name.startsWith("org.netbeans.") || name.startsWith("org.openide.") || name.endsWith(".Bundle") || name.endsWith("BeanInfo") || name.endsWith("Editor")) && par.getResource(fileName) == null) {
                skip = true;
            }
            if (skip) continue;
            try {
                return par.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                cached = cnfe;
            }
        }
        Class c = this.simpleFindClass(name, fileName, pkg);
        if (c != null) {
            return c;
        }
        if (cached != null) {
            throw cached;
        }
        return null;
    }

    private synchronized Class fullFindClass(String name, String fileName, String pkg) {
        Class c = this.findLoadedClass(name);
        if (c == null && (c = this.simpleFindClass(name, fileName, pkg)) != null) {
            this.domainsByPackage.put(new String(pkg).intern(), this);
        }
        return c;
    }

    private void addPackages(Map<String, Package> all, Package[] pkgs) {
        for (int i = 0; i < pkgs.length; ++i) {
            all.put(pkgs[i].getName(), pkgs[i]);
        }
    }

    protected boolean shouldBeCheckedAsParentProxyClassLoader() {
        return true;
    }

    protected boolean optimizeNBLoading() {
        return true;
    }

    protected boolean isSpecialResource(String pkg) {
        if (pkg.startsWith("META-INF/")) {
            return true;
        }
        return pkg.length() == 0;
    }

    protected boolean shouldDelegateResource(String pkg, ClassLoader parent) {
        return true;
    }
}

