/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.platform.JavaPlatformProvider;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;

public class DefaultJavaPlatformProvider
implements JavaPlatformProvider,
FileChangeListener {
    private static final String PLATFORM_STORAGE = "Services/Platforms/org-netbeans-api-java-Platform";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private FileObject storage = Repository.getDefault().getDefaultFileSystem().findResource("Services/Platforms/org-netbeans-api-java-Platform");
    private JavaPlatform defaultPlatform;

    public DefaultJavaPlatformProvider() {
        if (this.storage != null) {
            this.storage.addFileChangeListener((FileChangeListener)this);
        }
    }

    public JavaPlatform[] getInstalledPlatforms() {
        ArrayList<JavaPlatform> platforms = new ArrayList<JavaPlatform>();
        if (this.storage != null) {
            try {
                for (FileObject platformDefinition : this.storage.getChildren()) {
                    DataObject dobj = DataObject.find((FileObject)platformDefinition);
                    InstanceCookie ic = (InstanceCookie)dobj.getCookie(InstanceCookie.class);
                    if (ic == null) {
                        ErrorManager.getDefault().log(16, "DefaultPlatformStorage: The file: " + platformDefinition.getNameExt() + " has no InstanceCookie");
                        continue;
                    }
                    if (ic instanceof InstanceCookie.Of) {
                        if (((InstanceCookie.Of)ic).instanceOf(JavaPlatform.class)) {
                            platforms.add((JavaPlatform)ic.instanceCreate());
                            continue;
                        }
                        ErrorManager.getDefault().log(16, "DefaultPlatformStorage: The file: " + platformDefinition.getNameExt() + " is not an instance of JavaPlatform");
                        continue;
                    }
                    Object instance = ic.instanceCreate();
                    if (instance instanceof JavaPlatform) {
                        platforms.add((JavaPlatform)instance);
                        continue;
                    }
                    ErrorManager.getDefault().log(16, "DefaultPlatformStorage: The file: " + platformDefinition.getNameExt() + " is not an instance of JavaPlatform");
                }
            }
            catch (ClassNotFoundException cnf) {
                ErrorManager.getDefault().notify((Throwable)cnf);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
        return platforms.toArray(new JavaPlatform[platforms.size()]);
    }

    public JavaPlatform getDefaultPlatform() {
        if (this.defaultPlatform == null) {
            JavaPlatform[] allPlatforms = this.getInstalledPlatforms();
            for (int i = 0; i < allPlatforms.length; ++i) {
                if (!"default_platform".equals(allPlatforms[i].getProperties().get("platform.ant.name"))) continue;
                this.defaultPlatform = allPlatforms[i];
                break;
            }
        }
        return this.defaultPlatform;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
        this.firePropertyChange();
    }

    public void fileChanged(FileEvent fe) {
        this.firePropertyChange();
    }

    public void fileDeleted(FileEvent fe) {
        this.firePropertyChange();
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.firePropertyChange();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    private void firePropertyChange() {
        this.pcs.firePropertyChange("installedPlatforms", null, null);
    }
}

