/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.hints.AddCastHint;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AddCastCreator
implements ErrorRule<Void> {
    static void computeType(CompilationInfo info, int offset, TypeMirror[] tm, ExpressionTree[] expression, Tree[] leaf) {
        for (TreePath path = info.getTreeUtilities().pathFor(offset); path != null; path = path.getParentPath()) {
            TypeMirror foundTM;
            Tree scope = path.getLeaf();
            TypeMirror expected = null;
            TypeMirror resolved = null;
            ExpressionTree found = null;
            if (scope.getKind() == Tree.Kind.VARIABLE && ((VariableTree)scope).getInitializer() != null) {
                expected = info.getTrees().getTypeMirror(path);
                found = ((VariableTree)scope).getInitializer();
                resolved = info.getTrees().getTypeMirror(new TreePath(path, found));
            }
            if (scope.getKind() == Tree.Kind.ASSIGNMENT) {
                expected = info.getTrees().getTypeMirror(path);
                found = ((AssignmentTree)scope).getExpression();
                resolved = info.getTrees().getTypeMirror(new TreePath(path, found));
            }
            if (scope.getKind() == Tree.Kind.RETURN) {
                TreePath parents;
                for (parents = path; parents != null && parents.getLeaf().getKind() != Tree.Kind.METHOD; parents = parents.getParentPath()) {
                }
                if (parents != null) {
                    expected = info.getTrees().getTypeMirror(new TreePath(parents, ((MethodTree)parents.getLeaf()).getReturnType()));
                    found = ((ReturnTree)scope).getExpression();
                    resolved = info.getTrees().getTypeMirror(new TreePath(path, found));
                }
            }
            if (expected == null || resolved == null || (foundTM = info.getTrees().getTypeMirror(new TreePath(path, found))).getKind() == TypeKind.EXECUTABLE || info.getTypes().isAssignable(foundTM, expected) || !info.getTypeUtilities().isCastable(resolved, expected) || foundTM.getKind() == TypeKind.ERROR || expected.getKind() == TypeKind.ERROR) continue;
            tm[0] = expected;
            expression[0] = found;
            leaf[0] = scope;
        }
    }

    @Override
    public Set<String> getCodes() {
        return Collections.singleton("compiler.err.prob.found.req");
    }

    @Override
    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        ArrayList<Fix> result = new ArrayList<Fix>();
        TypeMirror[] tm = new TypeMirror[1];
        ExpressionTree[] expression = new ExpressionTree[1];
        Tree[] leaf = new Tree[1];
        AddCastCreator.computeType(info, offset, tm, expression, leaf);
        if (tm[0] != null) {
            int position = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), expression[0]);
            result.add(new AddCastHint(info.getJavaSource(), (String)new HintDisplayNameVisitor().scan(expression[0], null), ((Object)Utilities.getTypeName((TypeMirror)tm[0], (boolean)false)).toString(), position));
        }
        return result;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return AddCastCreator.class.getName();
    }

    @Override
    public String getDisplayName() {
        return "Add Cast Fix";
    }

    @Override
    public String getDescription() {
        return "Add Cast Fix";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HintDisplayNameVisitor
    extends TreeScanner<String, Void> {
        private HintDisplayNameVisitor() {
        }

        @Override
        public String visitIdentifier(IdentifierTree tree, Void v) {
            return "..." + tree.getName().toString();
        }

        @Override
        public String visitMethodInvocation(MethodInvocationTree tree, Void v) {
            ExpressionTree methodSelect = tree.getMethodSelect();
            return "..." + this.simpleName(methodSelect) + "(...)";
        }

        @Override
        public String visitArrayAccess(ArrayAccessTree node, Void p) {
            return "..." + this.simpleName(node.getExpression()) + "[]";
        }

        @Override
        public String visitNewClass(NewClassTree nct, Void p) {
            return "...new " + this.simpleName(nct.getIdentifier()) + "(...)";
        }

        private String simpleName(Tree t) {
            if (t.getKind() == Tree.Kind.IDENTIFIER) {
                return ((IdentifierTree)t).getName().toString();
            }
            if (t.getKind() == Tree.Kind.MEMBER_SELECT) {
                return ((MemberSelectTree)t).getIdentifier().toString();
            }
            if (t.getKind() == Tree.Kind.METHOD_INVOCATION) {
                return (String)this.scan(t, null);
            }
            if (t.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                return this.simpleName(((ParameterizedTypeTree)t).getType()) + "<...>";
            }
            throw new IllegalStateException("Currently unsupported kind of tree: " + (Object)((Object)t.getKind()));
        }
    }
}

