/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.JavaHintsProvider;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;

public class AddParameterOrLocalFix
implements Fix {
    private FileObject file;
    private TypeMirrorHandle type;
    private String name;
    private boolean parameter;
    private int unresolvedVariable;

    public AddParameterOrLocalFix(CompilationInfo info, TypeMirror type, String name, boolean parameter, int unresolvedVariable) {
        this.file = info.getFileObject();
        if (type.getKind() == TypeKind.NULL) {
            type = info.getElements().getTypeElement("java.lang.Object").asType();
        }
        this.type = TypeMirrorHandle.create((TypeMirror)type);
        this.name = name;
        this.parameter = parameter;
        this.unresolvedVariable = unresolvedVariable;
    }

    public String getText() {
        return this.parameter ? "Create parameter " + this.name : "Create local variable " + this.name;
    }

    public ChangeInfo implement() {
        try {
            JavaSource js = JavaSource.forFileObject((FileObject)this.file);
            js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                public void cancel() {
                }

                public void run(WorkingCopy working) throws IOException {
                    working.toPhase(JavaSource.Phase.RESOLVED);
                    TypeMirror proposedType = AddParameterOrLocalFix.this.type.resolve((CompilationInfo)working);
                    if (proposedType == null) {
                        JavaHintsProvider.LOG.log(Level.INFO, "Cannot resolve proposed type.");
                        return;
                    }
                    TreeMaker make = working.getTreeMaker();
                    TreePath tp = working.getTreeUtilities().pathFor(AddParameterOrLocalFix.this.unresolvedVariable + 1);
                    assert (tp.getLeaf().getKind() == Tree.Kind.IDENTIFIER);
                    MethodTree targetTree = AddParameterOrLocalFix.this.findMethod(tp);
                    if (AddParameterOrLocalFix.this.parameter) {
                        if (targetTree == null) {
                            Logger.getLogger("global").log(Level.WARNING, "Add parameter - cannot find the method.");
                        }
                        MethodTree result = make.addMethodParameter(targetTree, make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)AddParameterOrLocalFix.this.name, make.Type(proposedType), null));
                        working.rewrite((Tree)targetTree, (Tree)result);
                    } else {
                        AddParameterOrLocalFix.this.resolveLocalVariable(working, tp, make, proposedType);
                    }
                }
            }).commit();
        }
        catch (IOException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        return null;
    }

    private void resolveLocalVariable(WorkingCopy wc, TreePath tp, TreeMaker make, TypeMirror proposedType) {
        ExpressionTree exp;
        String name = ((IdentifierTree)tp.getLeaf()).getName().toString();
        final Element el = wc.getTrees().getElement(tp);
        TreePath method = tp;
        while (method.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && method.getLeaf().getKind() != Tree.Kind.METHOD) {
            method = method.getParentPath();
        }
        if (method.getLeaf().getKind() != Tree.Kind.METHOD) {
            return;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class FirstUsage
        extends TreePathScanner<TreePath, Void> {
            private TreePath found;

            FirstUsage() {
            }

            @Override
            public TreePath visitIdentifier(IdentifierTree tree, Void v) {
                if (tree.getName().contentEquals(el.getSimpleName())) {
                    if (this.found == null) {
                        this.found = this.getCurrentPath();
                    }
                    return AddParameterOrLocalFix.this.findStatement(this.getCurrentPath());
                }
                return null;
            }

            @Override
            public TreePath visitBlock(BlockTree tree, Void v) {
                TreePath result = null;
                TreePath firstBranchStatementWithUsage = null;
                for (StatementTree statementTree : tree.getStatements()) {
                    TreePath currentResult = (TreePath)this.scan(statementTree, null);
                    if (currentResult != null && result == null) {
                        result = currentResult;
                        firstBranchStatementWithUsage = new TreePath(this.getCurrentPath(), statementTree);
                    }
                    if (currentResult == statementTree || result == null || result.getLeaf() == firstBranchStatementWithUsage.getLeaf()) continue;
                    result = firstBranchStatementWithUsage;
                }
                super.visitBlock(tree, v);
                return result;
            }

            @Override
            public TreePath reduce(TreePath tp1, TreePath tp2) {
                if (tp2 == null) {
                    return tp1;
                }
                return tp2;
            }
        }
        FirstUsage firstUsage = new FirstUsage();
        TreePath firstUse = (TreePath)firstUsage.scan(method, null);
        if (firstUse == null || !this.isStatement(firstUse.getLeaf())) {
            Logger.getLogger("global").log(Level.WARNING, "Add local variable - cannot find a statement.");
            return;
        }
        StatementTree statement = (StatementTree)firstUse.getLeaf();
        if (statement.getKind() == Tree.Kind.EXPRESSION_STATEMENT && (exp = ((ExpressionStatementTree)statement).getExpression()).getKind() == Tree.Kind.ASSIGNMENT) {
            AssignmentTree at = (AssignmentTree)exp;
            VariableTree vt = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)name, make.Type(proposedType), at.getExpression());
            wc.rewrite((Tree)statement, (Tree)vt);
            return;
        }
        Tree statementParent = firstUse.getParentPath().getLeaf();
        VariableTree vt = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)name, make.Type(proposedType), null);
        if (statementParent.getKind() == Tree.Kind.BLOCK) {
            BlockTree block = (BlockTree)statementParent;
            BlockTree nueBlock = make.insertBlockStatement(block, block.getStatements().indexOf(statement), (StatementTree)vt);
            wc.rewrite((Tree)block, (Tree)nueBlock);
        } else {
            BlockTree block = make.Block(Arrays.asList(vt, statement), false);
            wc.rewrite((Tree)statement, (Tree)block);
        }
    }

    private TreePath findStatement(TreePath tp) {
        TreePath statement = tp;
        while (statement.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            if (this.isStatement(statement.getLeaf())) {
                return statement;
            }
            statement = statement.getParentPath();
        }
        return null;
    }

    private MethodTree findMethod(TreePath tp) {
        TreePath method = tp;
        while (method.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            if (method.getLeaf().getKind() == Tree.Kind.METHOD) {
                return (MethodTree)method.getLeaf();
            }
            method = method.getParentPath();
        }
        return null;
    }

    private boolean isStatement(Tree t) {
        Class<? extends Tree> intClass = t.getKind().asInterface();
        return StatementTree.class.isAssignableFrom(intClass);
    }

    String toDebugString(CompilationInfo info) {
        return "AddParameterOrLocalFix:" + this.name + ":" + ((Object)this.type.resolve(info)).toString() + ":" + this.parameter;
    }
}

