/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.semantic.Utilities;
import org.netbeans.modules.java.hints.AddParameterOrLocalFix;
import org.netbeans.modules.java.hints.JavaHintsProvider;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreateElement
implements ErrorRule<Void> {
    private static final Set<Tree.Kind> STOP_LOOKING_FOR_METHOD = EnumSet.of(Tree.Kind.METHOD, Tree.Kind.CLASS, Tree.Kind.COMPILATION_UNIT);

    @Override
    public Set<String> getCodes() {
        return Collections.singleton("compiler.err.cant.resolve.location");
    }

    @Override
    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        return CreateElement.analyze(info, offset);
    }

    static List<Fix> analyze(CompilationInfo info, int offset) {
        TreePath errorPath = JavaHintsProvider.findUnresolvedElement(info, offset);
        if (errorPath == null) {
            return Collections.emptyList();
        }
        TreePath parent = null;
        TreePath firstClass = null;
        TreePath firstMethod = null;
        TreePath firstInitializer = null;
        for (TreePath path = info.getTreeUtilities().pathFor(offset + 1); path != null; path = path.getParentPath()) {
            if (parent != null && parent.getLeaf() == errorPath.getLeaf()) {
                parent = path;
            }
            if (path.getLeaf() == errorPath.getLeaf() && parent == null) {
                parent = path;
            }
            if (path.getLeaf().getKind() == Tree.Kind.CLASS && firstClass == null) {
                firstClass = path;
            }
            if (path.getLeaf().getKind() == Tree.Kind.METHOD && firstMethod == null && firstClass == null) {
                firstMethod = path;
            }
            if (path.getLeaf().getKind() != Tree.Kind.BLOCK || path.getParentPath().getLeaf().getKind() != Tree.Kind.CLASS || firstMethod != null || firstClass != null) continue;
            firstInitializer = path;
        }
        if (parent == null || parent.getLeaf() == errorPath.getLeaf() || firstClass == null) {
            return Collections.emptyList();
        }
        Element e = info.getTrees().getElement(errorPath);
        if (e == null) {
            return Collections.emptyList();
        }
        EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
        String simpleName = e.getSimpleName().toString();
        TypeElement source = (TypeElement)info.getTrees().getElement(firstClass);
        TypeElement target = null;
        boolean allowLocalVariables = true;
        if (errorPath.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
            TreePath exp = new TreePath(errorPath, ((MemberSelectTree)errorPath.getLeaf()).getExpression());
            Element targetElement = info.getTrees().getElement(exp);
            TypeMirror targetType = info.getTrees().getTypeMirror(exp);
            if (targetElement != null && targetType != null && targetType.getKind() != TypeKind.ERROR) {
                switch (targetElement.getKind()) {
                    case CLASS: 
                    case INTERFACE: 
                    case ENUM: 
                    case ANNOTATION_TYPE: {
                        target = (TypeElement)targetElement;
                        modifiers.add(Modifier.STATIC);
                        break;
                    }
                    case FIELD: 
                    case ENUM_CONSTANT: 
                    case LOCAL_VARIABLE: 
                    case PARAMETER: 
                    case EXCEPTION_PARAMETER: {
                        TypeMirror tm = targetElement.asType();
                        if (tm.getKind() != TypeKind.DECLARED) break;
                        target = (TypeElement)((DeclaredType)tm).asElement();
                        break;
                    }
                    case METHOD: {
                        Element el = info.getTypes().asElement(((ExecutableElement)targetElement).getReturnType());
                        if (el == null || !el.getKind().isClass() && !el.getKind().isInterface()) break;
                        target = (TypeElement)el;
                        break;
                    }
                    case CONSTRUCTOR: {
                        target = (TypeElement)targetElement.getEnclosingElement();
                    }
                }
            }
            allowLocalVariables = false;
        } else if (errorPath.getLeaf().getKind() == Tree.Kind.IDENTIFIER) {
            target = source;
            if (firstMethod != null && ((MethodTree)firstMethod.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                modifiers.add(Modifier.STATIC);
            }
        }
        if (target == null) {
            if (JavaHintsProvider.ERR.isLoggable(1)) {
                JavaHintsProvider.ERR.log(1, "target=null");
                JavaHintsProvider.ERR.log(1, "offset=" + offset);
                JavaHintsProvider.ERR.log(1, "errorTree=" + errorPath.getLeaf());
            }
            return Collections.emptyList();
        }
        modifiers.addAll(CreateElement.getAccessModifiers(source, target));
        ArrayList<Fix> result = new ArrayList<Fix>();
        EnumSet<FixTypes> fixTypes = EnumSet.noneOf(FixTypes.class);
        List<? extends TypeMirror> types = CreateElement.resolveType(fixTypes, info, parent, errorPath.getLeaf(), offset);
        if (types == null || types.isEmpty()) {
            return Collections.emptyList();
        }
        TypeMirror type = types.get(0);
        if (type == null || type.getKind() == TypeKind.VOID) {
            return Collections.emptyList();
        }
        if (CreateElement.containsErrorsOrTypevarsRecursively(type)) {
            return Collections.emptyList();
        }
        if (fixTypes.contains((Object)FixTypes.FIELD)) {
            result.add(new CreateFieldFix(info, simpleName, modifiers, target, type));
        }
        if (allowLocalVariables && (fixTypes.contains((Object)FixTypes.LOCAL) || types.contains((Object)FixTypes.PARAM))) {
            ExecutableElement ee = null;
            if (firstMethod != null) {
                ee = (ExecutableElement)info.getTrees().getElement(firstMethod);
            }
            if (ee != null && type != null) {
                int identifierPos = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), errorPath.getLeaf());
                if (ee != null && fixTypes.contains((Object)FixTypes.PARAM)) {
                    result.add(new AddParameterOrLocalFix(info, type, simpleName, true, identifierPos));
                }
                if (fixTypes.contains((Object)FixTypes.LOCAL)) {
                    result.add(new AddParameterOrLocalFix(info, type, simpleName, false, identifierPos));
                }
            }
        }
        return result;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return CreateElement.class.getName();
    }

    @Override
    public String getDisplayName() {
        return "Create Field Fix";
    }

    @Override
    public String getDescription() {
        return "Create Field Fix";
    }

    private static boolean containsErrorsOrTypevarsRecursively(TypeMirror tm) {
        switch (tm.getKind()) {
            case WILDCARD: 
            case TYPEVAR: 
            case ERROR: {
                return true;
            }
            case DECLARED: {
                DeclaredType type = (DeclaredType)tm;
                for (TypeMirror typeMirror : type.getTypeArguments()) {
                    if (!CreateElement.containsErrorsOrTypevarsRecursively(typeMirror)) continue;
                    return true;
                }
                return false;
            }
            case ARRAY: {
                return CreateElement.containsErrorsOrTypevarsRecursively(((ArrayType)tm).getComponentType());
            }
        }
        return false;
    }

    private static EnumSet<Modifier> getAccessModifiers(TypeElement source, TypeElement target) {
        Element targetPackage;
        TypeElement outterMostTarget;
        TypeElement outterMostSource = SourceUtils.getOutermostEnclosingTypeElement((Element)source);
        if (outterMostSource.equals(outterMostTarget = SourceUtils.getOutermostEnclosingTypeElement((Element)target))) {
            return EnumSet.of(Modifier.PRIVATE);
        }
        Element sourcePackage = outterMostSource.getEnclosingElement();
        if (((Object)sourcePackage).equals(targetPackage = outterMostTarget.getEnclosingElement())) {
            return EnumSet.noneOf(Modifier.class);
        }
        return EnumSet.of(Modifier.PUBLIC);
    }

    private static List<? extends TypeMirror> resolveType(Set<FixTypes> types, CompilationInfo info, TreePath currentPath, Tree unresolved, int offset) {
        switch (currentPath.getLeaf().getKind()) {
            case METHOD: {
                return CreateElement.computeMethod(types, info, currentPath, unresolved, offset);
            }
            case MEMBER_SELECT: {
                return CreateElement.computeMemberSelect(types, info, currentPath, unresolved, offset);
            }
            case ASSIGNMENT: {
                return CreateElement.computeAssignment(types, info, currentPath, unresolved, offset);
            }
            case ENHANCED_FOR_LOOP: {
                return CreateElement.computeEnhancedForLoop(types, info, currentPath, unresolved, offset);
            }
            case ARRAY_ACCESS: {
                return CreateElement.computeArrayAccess(types, info, currentPath, unresolved, offset);
            }
            case VARIABLE: {
                return CreateElement.computeVariableDeclaration(types, info, currentPath, unresolved, offset);
            }
            case ASSERT: {
                return CreateElement.computeAssert(types, info, currentPath, unresolved, offset);
            }
            case PARENTHESIZED: {
                return CreateElement.computeParenthesis(types, info, currentPath, unresolved, offset);
            }
            case DO_WHILE_LOOP: {
                return CreateElement.computePrimitiveType(types, info, ((DoWhileLoopTree)currentPath.getLeaf()).getCondition(), unresolved, TypeKind.BOOLEAN);
            }
            case FOR_LOOP: {
                return CreateElement.computePrimitiveType(types, info, ((ForLoopTree)currentPath.getLeaf()).getCondition(), unresolved, TypeKind.BOOLEAN);
            }
            case IF: {
                return CreateElement.computePrimitiveType(types, info, ((IfTree)currentPath.getLeaf()).getCondition(), unresolved, TypeKind.BOOLEAN);
            }
            case WHILE_LOOP: {
                return CreateElement.computePrimitiveType(types, info, ((WhileLoopTree)currentPath.getLeaf()).getCondition(), unresolved, TypeKind.BOOLEAN);
            }
            case SYNCHRONIZED: {
                return CreateElement.computeReferenceType(types, info, ((SynchronizedTree)currentPath.getLeaf()).getExpression(), unresolved, "java.lang.Object");
            }
            case THROW: {
                return CreateElement.computeReferenceType(types, info, ((ThrowTree)currentPath.getLeaf()).getExpression(), unresolved, "java.lang.Exception");
            }
            case INSTANCE_OF: {
                return CreateElement.computeReferenceType(types, info, ((InstanceOfTree)currentPath.getLeaf()).getExpression(), unresolved, "java.lang.Object");
            }
            case SWITCH: {
                return CreateElement.computePrimitiveType(types, info, ((SwitchTree)currentPath.getLeaf()).getExpression(), unresolved, TypeKind.INT);
            }
            case RETURN: {
                return CreateElement.computeReturn(types, info, currentPath, unresolved, offset);
            }
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case UNARY_PLUS: 
            case UNARY_MINUS: 
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: {
                return CreateElement.computeUnary(types, info, currentPath, unresolved, offset);
            }
            case MULTIPLY: 
            case DIVIDE: 
            case REMAINDER: 
            case PLUS: 
            case MINUS: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN_EQUAL: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: 
            case AND: 
            case XOR: 
            case OR: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: {
                return CreateElement.computeBinaryOperator(types, info, currentPath, unresolved, offset);
            }
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case OR_ASSIGNMENT: {
                return null;
            }
            case ARRAY_TYPE: 
            case BLOCK: 
            case BREAK: 
            case CATCH: 
            case CLASS: 
            case COMPILATION_UNIT: 
            case CONTINUE: 
            case EXPRESSION_STATEMENT: 
            case IMPORT: 
            case IDENTIFIER: 
            case TYPE_CAST: 
            case PARAMETERIZED_TYPE: 
            case TRY: 
            case EMPTY_STATEMENT: 
            case PRIMITIVE_TYPE: 
            case LABELED_STATEMENT: 
            case MODIFIERS: 
            case ERRONEOUS: 
            case OTHER: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case FLOAT_LITERAL: 
            case DOUBLE_LITERAL: 
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case STRING_LITERAL: 
            case NULL_LITERAL: 
            case TYPE_PARAMETER: {
                return null;
            }
            case CASE: 
            case ANNOTATION: 
            case CONDITIONAL_EXPRESSION: 
            case NEW_ARRAY: 
            case NEW_CLASS: 
            case UNBOUNDED_WILDCARD: 
            case EXTENDS_WILDCARD: 
            case SUPER_WILDCARD: {
                return null;
            }
        }
        return null;
    }

    private static List<? extends TypeMirror> computeBinaryOperator(Set<FixTypes> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        BinaryTree bt = (BinaryTree)parent.getLeaf();
        TreePath typeToResolve = null;
        if (bt.getLeftOperand() == error) {
            typeToResolve = new TreePath(parent, bt.getRightOperand());
        }
        if (bt.getRightOperand() == error) {
            typeToResolve = new TreePath(parent, bt.getLeftOperand());
        }
        types.add(FixTypes.PARAM);
        types.add(FixTypes.LOCAL);
        types.add(FixTypes.FIELD);
        return typeToResolve != null ? Collections.singletonList(info.getTrees().getTypeMirror(typeToResolve)) : null;
    }

    private static List<? extends TypeMirror> computeMethod(Set<FixTypes> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        MethodTree mt = (MethodTree)parent.getLeaf();
        if (mt.getBody() == null) {
            return null;
        }
        try {
            int bodyStart = Utilities.findBodyStart((Tree)parent.getLeaf(), (CompilationUnitTree)info.getCompilationUnit(), (SourcePositions)info.getTrees().getSourcePositions(), (Document)info.getDocument());
            int bodyEnd = (int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), parent.getLeaf());
            types.add(FixTypes.PARAM);
            types.add(FixTypes.LOCAL);
            types.add(FixTypes.FIELD);
            if (bodyStart <= offset && offset <= bodyEnd) {
                return Collections.singletonList(info.getElements().getTypeElement("java.lang.Object").asType());
            }
        }
        catch (IOException ex) {
            Logger.getLogger("global").log(Level.INFO, ex.getMessage(), ex);
        }
        return null;
    }

    private static List<? extends TypeMirror> computeMemberSelect(Set<FixTypes> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        MemberSelectTree ms = (MemberSelectTree)parent.getLeaf();
        if (!"class".equals(ms.getIdentifier().toString())) {
            types.add(FixTypes.FIELD);
            return Collections.singletonList(info.getElements().getTypeElement("java.lang.Object").asType());
        }
        return null;
    }

    private static List<? extends TypeMirror> computeAssignment(Set<FixTypes> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        AssignmentTree at = (AssignmentTree)parent.getLeaf();
        TypeMirror type = null;
        if (at.getVariable() == error && (type = info.getTrees().getTypeMirror(new TreePath(parent, at.getExpression()))).getKind() == TypeKind.EXECUTABLE) {
            type = ((ExecutableType)type).getReturnType();
        }
        if (at.getExpression() == error) {
            type = info.getTrees().getTypeMirror(new TreePath(parent, at.getVariable()));
        }
        if (type == null) {
            if (JavaHintsProvider.ERR.isLoggable(1)) {
                JavaHintsProvider.ERR.log(1, "offset=" + offset);
                JavaHintsProvider.ERR.log(1, "errorTree=" + error);
                JavaHintsProvider.ERR.log(1, "type=null");
            }
            return null;
        }
        types.add(FixTypes.PARAM);
        types.add(FixTypes.LOCAL);
        types.add(FixTypes.FIELD);
        return Collections.singletonList(type);
    }

    private static List<? extends TypeMirror> computeEnhancedForLoop(Set<FixTypes> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        EnhancedForLoopTree efl = (EnhancedForLoopTree)parent.getLeaf();
        if (efl.getExpression() != error) {
            return null;
        }
        types.add(FixTypes.PARAM);
        types.add(FixTypes.LOCAL);
        types.add(FixTypes.FIELD);
        TypeElement iterable = info.getElements().getTypeElement("java.lang.Iterable");
        TypeMirror argument = info.getTrees().getTypeMirror(new TreePath(new TreePath(parent, efl.getVariable()), efl.getVariable().getType()));
        return Collections.singletonList(info.getTypes().getDeclaredType(iterable, argument));
    }

    private static List<? extends TypeMirror> computeArrayAccess(Set<FixTypes> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        ArrayAccessTree aat = (ArrayAccessTree)parent.getLeaf();
        if (aat.getExpression() == error) {
            TreePath parentParent = parent.getParentPath();
            List<? extends TypeMirror> upperTypes = CreateElement.resolveType(types, info, parentParent, aat, offset);
            if (upperTypes == null) {
                return null;
            }
            ArrayList<ArrayType> arrayTypes = new ArrayList<ArrayType>();
            for (TypeMirror typeMirror : upperTypes) {
                arrayTypes.add(info.getTypes().getArrayType(typeMirror));
            }
            return arrayTypes;
        }
        if (aat.getIndex() == error) {
            types.add(FixTypes.PARAM);
            types.add(FixTypes.LOCAL);
            types.add(FixTypes.FIELD);
            return Collections.singletonList(info.getTypes().getPrimitiveType(TypeKind.INT));
        }
        return null;
    }

    private static List<? extends TypeMirror> computeVariableDeclaration(Set<FixTypes> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        VariableTree vt = (VariableTree)parent.getLeaf();
        if (vt.getInitializer() != error) {
            return null;
        }
        types.add(FixTypes.PARAM);
        types.add(FixTypes.LOCAL);
        types.add(FixTypes.FIELD);
        return Collections.singletonList(info.getTrees().getTypeMirror(new TreePath(parent, vt.getType())));
    }

    private static List<? extends TypeMirror> computeAssert(Set<FixTypes> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        AssertTree at = (AssertTree)parent.getLeaf();
        types.add(FixTypes.PARAM);
        types.add(FixTypes.LOCAL);
        types.add(FixTypes.FIELD);
        if (at.getCondition() == error) {
            return Collections.singletonList(info.getTypes().getPrimitiveType(TypeKind.BOOLEAN));
        }
        if (at.getDetail() == error) {
            return Collections.singletonList(info.getElements().getTypeElement("java.lang.Object").asType());
        }
        return null;
    }

    private static List<? extends TypeMirror> computeParenthesis(Set<FixTypes> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        ParenthesizedTree pt = (ParenthesizedTree)parent.getLeaf();
        if (pt.getExpression() != error) {
            return null;
        }
        TreePath parentParent = parent.getParentPath();
        List<? extends TypeMirror> upperTypes = CreateElement.resolveType(types, info, parentParent, pt, offset);
        if (upperTypes == null) {
            return null;
        }
        return upperTypes;
    }

    private static List<? extends TypeMirror> computePrimitiveType(Set<FixTypes> types, CompilationInfo info, Tree expression, Tree error, TypeKind kind) {
        if (expression == error) {
            types.add(FixTypes.PARAM);
            types.add(FixTypes.LOCAL);
            types.add(FixTypes.FIELD);
            return Collections.singletonList(info.getTypes().getPrimitiveType(kind));
        }
        return null;
    }

    private static List<? extends TypeMirror> computeReferenceType(Set<FixTypes> types, CompilationInfo info, Tree expression, Tree error, String type) {
        if (expression == error) {
            types.add(FixTypes.PARAM);
            types.add(FixTypes.LOCAL);
            types.add(FixTypes.FIELD);
            return Collections.singletonList(info.getElements().getTypeElement(type).asType());
        }
        return null;
    }

    private static List<? extends TypeMirror> computeUnary(Set<FixTypes> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        UnaryTree tree = (UnaryTree)parent.getLeaf();
        if (tree.getExpression() == error) {
            List<? extends TypeMirror> parentTypes = CreateElement.resolveType(types, info, parent.getParentPath(), tree, offset);
            if (parentTypes == null) {
                types.add(FixTypes.PARAM);
                types.add(FixTypes.LOCAL);
                types.add(FixTypes.FIELD);
                return Collections.singletonList(info.getTypes().getPrimitiveType(TypeKind.INT));
            }
            return parentTypes;
        }
        return null;
    }

    private static List<? extends TypeMirror> computeReturn(Set<FixTypes> types, CompilationInfo info, TreePath parent, Tree error, int offset) {
        ReturnTree rt = (ReturnTree)parent.getLeaf();
        if (rt.getExpression() == error) {
            TreePath method = CreateElement.findMethod(parent);
            if (method == null) {
                return null;
            }
            Element el = info.getTrees().getElement(method);
            if (el == null || el.getKind() != ElementKind.METHOD) {
                return null;
            }
            types.add(FixTypes.PARAM);
            types.add(FixTypes.LOCAL);
            types.add(FixTypes.FIELD);
            return Collections.singletonList(((ExecutableElement)el).getReturnType());
        }
        return null;
    }

    private static TreePath findMethod(TreePath tp) {
        while (!STOP_LOOKING_FOR_METHOD.contains((Object)tp.getLeaf().getKind())) {
            tp = tp.getParentPath();
        }
        if (tp.getLeaf().getKind() == Tree.Kind.METHOD) {
            return tp;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CreateFieldFix
    implements Fix {
        private FileObject targetFile;
        private ElementHandle<TypeElement> target;
        private TypeMirrorHandle proposedType;
        private ClasspathInfo cpInfo;
        private Set<Modifier> modifiers;
        private String name;
        private String inFQN;

        public CreateFieldFix(CompilationInfo info, String name, Set<Modifier> modifiers, TypeElement target, TypeMirror proposedType) {
            this.name = name;
            this.inFQN = target.getQualifiedName().toString();
            this.cpInfo = info.getClasspathInfo();
            this.modifiers = modifiers;
            this.targetFile = SourceUtils.getFile((Element)target, (ClasspathInfo)this.cpInfo);
            this.target = ElementHandle.create((Element)target);
            if (proposedType.getKind() == TypeKind.NULL) {
                proposedType = info.getElements().getTypeElement("java.lang.Object").asType();
            }
            this.proposedType = TypeMirrorHandle.create((TypeMirror)proposedType);
        }

        public String getText() {
            return "Create field " + this.name + " in " + this.inFQN;
        }

        public ChangeInfo implement() {
            try {
                JavaSource js = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[]{this.targetFile});
                js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy working) throws IOException {
                        working.toPhase(JavaSource.Phase.RESOLVED);
                        TypeElement targetType = (TypeElement)CreateFieldFix.this.target.resolve((CompilationInfo)working);
                        if (targetType == null) {
                            JavaHintsProvider.LOG.log(Level.INFO, "Cannot resolve target.");
                            return;
                        }
                        ClassTree targetTree = working.getTrees().getTree(targetType);
                        if (targetTree == null) {
                            JavaHintsProvider.LOG.log(Level.INFO, "Cannot resolve target tree: " + targetType.getQualifiedName() + ".");
                            return;
                        }
                        TypeMirror proposedType = CreateFieldFix.this.proposedType.resolve((CompilationInfo)working);
                        if (proposedType == null) {
                            JavaHintsProvider.LOG.log(Level.INFO, "Cannot resolve proposed type.");
                            return;
                        }
                        TreeMaker make = working.getTreeMaker();
                        TypeMirror tm = proposedType;
                        VariableTree var = null;
                        if (tm.getKind() == TypeKind.DECLARED || tm.getKind() == TypeKind.ARRAY) {
                            var = make.Variable(make.Modifiers(CreateFieldFix.this.modifiers), (CharSequence)CreateFieldFix.this.name, make.Type(tm), null);
                        }
                        if (tm.getKind().isPrimitive()) {
                            var = make.Variable(make.Modifiers(CreateFieldFix.this.modifiers), (CharSequence)CreateFieldFix.this.name, make.Type(tm), null);
                        }
                        assert (var != null) : tm.getKind();
                        ClassTree decl = make.addClassMember(targetTree, var);
                        working.rewrite((Tree)targetTree, (Tree)decl);
                    }
                }).commit();
            }
            catch (IOException e) {
                throw (IllegalStateException)new IllegalStateException().initCause(e);
            }
            return null;
        }

        String toDebugString(CompilationInfo info) {
            return "CreateFieldFix:" + this.name + ":" + this.target.getQualifiedName() + ":" + ((Object)this.proposedType.resolve(info)).toString() + ":" + this.modifiers;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FixTypes {
        PARAM,
        LOCAL,
        FIELD;

    }
}

