/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.LinkedList;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.LazyHintComputationFactory;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyHintComputation
implements CancellableTask<CompilationInfo> {
    private FileObject file;
    private boolean cancelled;
    private CreatorBasedLazyFixList delegate;

    public LazyHintComputation(FileObject file) {
        this.file = file;
    }

    public synchronized void cancel() {
        this.cancelled = true;
        if (this.delegate != null) {
            this.delegate.cancel();
        }
    }

    private synchronized void setDelegate(CreatorBasedLazyFixList delegate) {
        this.delegate = delegate;
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }

    private synchronized void resume() {
        this.cancelled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CompilationInfo info) {
        this.resume();
        boolean cancelled = false;
        LinkedList<CreatorBasedLazyFixList> toCompute = new LinkedList<CreatorBasedLazyFixList>();
        try {
            toCompute.addAll(LazyHintComputationFactory.getAndClearToCompute(this.file));
            if (this.isCancelled()) {
                cancelled = true;
                return;
            }
            while (!toCompute.isEmpty()) {
                if (this.isCancelled()) {
                    cancelled = true;
                    return;
                }
                CreatorBasedLazyFixList l = (CreatorBasedLazyFixList)toCompute.remove(0);
                this.setDelegate(l);
                l.compute(info);
                this.setDelegate(null);
                if (!this.isCancelled()) continue;
                toCompute.add(0, l);
                cancelled = true;
                return;
            }
        }
        finally {
            if (cancelled && !toCompute.isEmpty()) {
                for (CreatorBasedLazyFixList l : toCompute) {
                    LazyHintComputationFactory.addToCompute(this.file, l);
                }
            }
        }
    }
}

