/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.hints.UncaughtExceptionCreator;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MagicSurroundWithTryCatch
implements Fix {
    private JavaSource js;
    private List<TypeMirrorHandle> thandles;
    private int offset;
    private static final String[] STREAM_ALIKE_CLASSES = new String[]{"java.io.InputStream", "java.io.OutputStream", "java.io.Reader", "java.io.Writer"};

    public MagicSurroundWithTryCatch(JavaSource js, List<TypeMirrorHandle> thandles, int offset) {
        this.js = js;
        this.thandles = thandles;
        this.offset = offset;
    }

    public String getText() {
        return "Surround with try-catch";
    }

    private boolean isStreamAlike(CompilationInfo info, TypeMirror type) {
        for (String fqn : STREAM_ALIKE_CLASSES) {
            TypeElement inputStream = info.getElements().getTypeElement(fqn);
            if (!info.getTypes().isAssignable(type, inputStream.asType())) continue;
            return true;
        }
        return false;
    }

    public ChangeInfo implement() {
        try {
            this.js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                public void cancel() {
                }

                public void run(WorkingCopy wc) throws Exception {
                    TreePath catchTree;
                    TreePath currentPath;
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    for (currentPath = wc.getTreeUtilities().pathFor(MagicSurroundWithTryCatch.this.offset + 1); currentPath != null && !UncaughtExceptionCreator.STATEMENT_KINDS.contains((Object)currentPath.getLeaf().getKind()); currentPath = currentPath.getParentPath()) {
                    }
                    TreePath statement = currentPath;
                    boolean streamAlike = false;
                    if (statement.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                        Element curType = wc.getTrees().getElement(statement);
                        streamAlike = MagicSurroundWithTryCatch.this.isStreamAlike((CompilationInfo)wc, curType.asType());
                    }
                    for (catchTree = currentPath; catchTree != null && catchTree.getLeaf().getKind() != Tree.Kind.TRY && catchTree.getLeaf().getKind() != Tree.Kind.CLASS && catchTree.getLeaf().getKind() != Tree.Kind.CATCH; catchTree = catchTree.getParentPath()) {
                    }
                    if (catchTree.getLeaf().getKind() == Tree.Kind.TRY) {
                        new TransformerImpl(wc, MagicSurroundWithTryCatch.this.thandles, streamAlike, statement).scan(catchTree.getLeaf(), null);
                    } else {
                        TreePath blockTree;
                        for (blockTree = currentPath; blockTree != null && blockTree.getLeaf().getKind() != Tree.Kind.BLOCK; blockTree = blockTree.getParentPath()) {
                        }
                        new TransformerImpl(wc, MagicSurroundWithTryCatch.this.thandles, streamAlike, statement).scan(blockTree.getLeaf(), null);
                    }
                }
            }).commit();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TransformerImpl
    extends TreeScanner<Void, Void> {
        private WorkingCopy info;
        private List<TypeMirrorHandle> thandles;
        private boolean streamAlike;
        private TreePath statement;
        private TreeMaker make;

        public TransformerImpl(WorkingCopy info, List<TypeMirrorHandle> thandles, boolean streamAlike, TreePath statement) {
            this.info = info;
            this.thandles = thandles;
            this.streamAlike = streamAlike;
            this.statement = statement;
            this.make = info.getTreeMaker();
        }

        private StatementTree createExceptionsStatement() {
            TypeElement exceptions = this.info.getElements().getTypeElement("org.openide.util.Exceptions");
            if (exceptions == null) {
                return null;
            }
            return this.make.ExpressionStatement((ExpressionTree)this.make.MethodInvocation(Collections.emptyList(), (ExpressionTree)this.make.MemberSelect(this.make.QualIdent((Element)exceptions), (CharSequence)"printStackTrace"), Arrays.asList(this.make.Identifier((CharSequence)"ex"))));
        }

        private StatementTree createLogStatement() {
            if (!GeneratorUtils.supportsOverride((FileObject)this.info.getFileObject())) {
                return null;
            }
            TypeElement logger = this.info.getElements().getTypeElement("java.util.logging.Logger");
            TypeElement level = this.info.getElements().getTypeElement("java.util.logging.Level");
            if (logger == null || level == null) {
                return null;
            }
            MethodInvocationTree etExpression = this.make.MethodInvocation(Collections.emptyList(), (ExpressionTree)this.make.MemberSelect(this.make.QualIdent((Element)logger), (CharSequence)"getLogger"), Collections.singletonList(this.make.Literal((Object)"global")));
            MemberSelectTree levelExpression = this.make.MemberSelect(this.make.QualIdent((Element)level), (CharSequence)"SEVERE");
            return this.make.ExpressionStatement((ExpressionTree)this.make.MethodInvocation(Collections.emptyList(), (ExpressionTree)this.make.MemberSelect((ExpressionTree)etExpression, (CharSequence)"log"), Arrays.asList(levelExpression, this.make.Literal(null), this.make.Identifier((CharSequence)"ex"))));
        }

        private StatementTree createPrintStackTraceStatement() {
            return this.make.ExpressionStatement((ExpressionTree)this.make.MethodInvocation(Collections.emptyList(), (ExpressionTree)this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)"ex"), (CharSequence)"printStackTrace"), Collections.emptyList()));
        }

        private CatchTree createCatch(TypeMirror type) {
            StatementTree logStatement = this.createExceptionsStatement();
            if (logStatement == null) {
                logStatement = this.createLogStatement();
            }
            if (logStatement == null) {
                logStatement = this.createPrintStackTraceStatement();
            }
            return this.make.Catch(this.make.Variable(this.make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"ex", this.make.Type(type), null), this.make.Block(Collections.singletonList(logStatement), false));
        }

        private List<CatchTree> createCatches() {
            ArrayList<CatchTree> catches = new ArrayList<CatchTree>();
            for (TypeMirrorHandle th : this.thandles) {
                catches.add(this.createCatch(th.resolve((CompilationInfo)this.info)));
            }
            return catches;
        }

        @Override
        public Void visitTry(TryTree tt, Void p) {
            List<CatchTree> catches = this.createCatches();
            catches.addAll(tt.getCatches());
            if (!this.streamAlike) {
                this.info.rewrite((Tree)tt, (Tree)this.make.Try(tt.getBlock(), catches, tt.getFinallyBlock()));
            } else {
                VariableTree originalDeclaration = (VariableTree)this.statement.getLeaf();
                VariableTree declaration = this.make.Variable(this.make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)originalDeclaration.getName(), originalDeclaration.getType(), (ExpressionTree)this.make.Literal(null));
                ExpressionStatementTree assignment = this.make.ExpressionStatement((ExpressionTree)this.make.Assignment((ExpressionTree)this.make.Identifier((CharSequence)originalDeclaration.getName()), originalDeclaration.getInitializer()));
                ArrayList finallyStatements = new ArrayList(tt.getFinallyBlock() != null ? tt.getFinallyBlock().getStatements() : Collections.emptyList());
                finallyStatements.add(this.createFinallyCloseBlockStatement(originalDeclaration.getName()));
                BlockTree finallyTree = this.make.Block(finallyStatements, false);
                this.info.rewrite((Tree)originalDeclaration, (Tree)assignment);
                TryTree nueTry = this.make.Try(tt.getBlock(), catches, finallyTree);
                TreePath currentBlockCandidate = this.statement;
                while (currentBlockCandidate.getLeaf() != tt) {
                    currentBlockCandidate = currentBlockCandidate.getParentPath();
                }
                if (currentBlockCandidate.getLeaf().getKind() == Tree.Kind.BLOCK) {
                    BlockTree originalTree = (BlockTree)currentBlockCandidate.getLeaf();
                    ArrayList<? extends StatementTree> statements = new ArrayList<StatementTree>(originalTree.getStatements());
                    int index = statements.indexOf(tt);
                    statements.remove(index);
                    statements.add(index, nueTry);
                    statements.add(index, declaration);
                    this.info.rewrite((Tree)originalTree, (Tree)this.make.Block(statements, false));
                } else {
                    BlockTree nueBlock = this.make.Block(Arrays.asList(declaration, nueTry), false);
                    this.info.rewrite((Tree)tt, (Tree)nueBlock);
                }
            }
            return null;
        }

        private StatementTree createFinallyCloseBlockStatement(CharSequence name) {
            ExpressionStatementTree close = this.make.ExpressionStatement((ExpressionTree)this.make.MethodInvocation(Collections.emptyList(), (ExpressionTree)this.make.MemberSelect((ExpressionTree)this.make.Identifier(name), (CharSequence)"close"), Collections.emptyList()));
            TryTree tryStatement = this.make.Try(this.make.Block(Collections.singletonList(close), false), Collections.singletonList(this.createCatch(this.info.getElements().getTypeElement("java.io.IOException").asType())), null);
            return tryStatement;
        }

        @Override
        public Void visitBlock(BlockTree bt, Void p) {
            List<CatchTree> catches = this.createCatches();
            if (!this.streamAlike) {
                this.info.rewrite((Tree)bt, (Tree)this.make.Block(Collections.singletonList(this.make.Try(bt, catches, null)), false));
            } else {
                VariableTree originalDeclaration = (VariableTree)this.statement.getLeaf();
                VariableTree declaration = this.make.Variable(this.make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)originalDeclaration.getName(), originalDeclaration.getType(), (ExpressionTree)this.make.Identifier((CharSequence)"null"));
                ExpressionStatementTree assignment = this.make.ExpressionStatement((ExpressionTree)this.make.Assignment((ExpressionTree)this.make.Identifier((CharSequence)originalDeclaration.getName()), originalDeclaration.getInitializer()));
                BlockTree finallyTree = this.make.Block(Collections.singletonList(this.createFinallyCloseBlockStatement(originalDeclaration.getName())), false);
                this.info.rewrite((Tree)originalDeclaration, (Tree)assignment);
                this.info.rewrite((Tree)bt, (Tree)this.make.Block(Arrays.asList(declaration, this.make.Try(bt, catches, finallyTree)), false));
            }
            return null;
        }
    }
}

