/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.netbeans.modules.java.hints.Pair;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.java.hints.spi.Rule;
import org.netbeans.modules.java.hints.spi.TreeRule;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesManager {
    public static Logger LOG = Logger.getLogger("org.netbeans.modules.java.hints");
    private static final String INSTANCE_EXT = ".instance";
    private static final String RULES_FOLDER = "org-netbeans-modules-java-hints/rules/";
    private static final String ERRORS = "errors";
    private static final String HINTS = "hints";
    private static final String SUGGESTIONS = "suggestions";
    private static Map<String, List<ErrorRule>> errors = new HashMap<String, List<ErrorRule>>();
    private static Map<Tree.Kind, List<TreeRule>> hints = new HashMap<Tree.Kind, List<TreeRule>>();
    private static Map<Tree.Kind, List<TreeRule>> suggestions = new HashMap<Tree.Kind, List<TreeRule>>();
    private static TreeModel errorsTreeModel;
    private static TreeModel hintsTreeModel;
    private static TreeModel suggestionsTreeModel;
    private static RulesManager INSTANCE;

    private RulesManager() {
        RulesManager.initErrors();
        RulesManager.initHints();
        RulesManager.initSuggestions();
    }

    public static synchronized RulesManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RulesManager();
        }
        return INSTANCE;
    }

    public Map<String, List<ErrorRule>> getErrors() {
        return errors;
    }

    public Map<Tree.Kind, List<TreeRule>> getHints() {
        return hints;
    }

    public Map<Tree.Kind, List<TreeRule>> getHints(boolean onLine) {
        HashMap<Tree.Kind, List<TreeRule>> result = new HashMap<Tree.Kind, List<TreeRule>>();
        for (Map.Entry<Tree.Kind, List<TreeRule>> e : this.getHints().entrySet()) {
            LinkedList<TreeRule> nueRules = new LinkedList<TreeRule>();
            for (TreeRule r : e.getValue()) {
                if (!(r instanceof AbstractHint)) {
                    if (onLine) continue;
                    nueRules.add(r);
                    continue;
                }
                AbstractHint ah = (AbstractHint)r;
                Preferences p = ah.getPreferences();
                if (p == null) {
                    if (onLine) continue;
                    nueRules.add(r);
                    continue;
                }
                if (p.getInt("severity", AbstractHint.SEVERITY_DEFAULT.ordinal()) == AbstractHint.HintSeverity.CURRENT_LINE_WARNING.ordinal()) {
                    if (!onLine) continue;
                    nueRules.add(r);
                    continue;
                }
                if (onLine) continue;
                nueRules.add(r);
            }
            if (nueRules.isEmpty()) continue;
            result.put(e.getKey(), nueRules);
        }
        return result;
    }

    public Map<Tree.Kind, List<TreeRule>> getSuggestions() {
        return suggestions;
    }

    public TreeModel getErrorsTreeModel() {
        return errorsTreeModel;
    }

    public TreeModel getHintsTreeModel() {
        return hintsTreeModel;
    }

    public TreeModel getSuggestionsTreeModel() {
        return suggestionsTreeModel;
    }

    private static void initErrors() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        errorsTreeModel = new DefaultTreeModel(rootNode);
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject folder = fs.getRoot().getFileObject("org-netbeans-modules-java-hints/rules/errors");
        List<Pair<Rule, FileObject>> rules = RulesManager.readRules(folder);
        RulesManager.categorizeErrorRules(rules, errors, folder, rootNode);
    }

    private static void initHints() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        hintsTreeModel = new DefaultTreeModel(rootNode);
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject folder = fs.getRoot().getFileObject("org-netbeans-modules-java-hints/rules/hints");
        List<Pair<Rule, FileObject>> rules = RulesManager.readRules(folder);
        RulesManager.categorizeTreeRules(rules, hints, folder, rootNode);
    }

    private static void initSuggestions() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        suggestionsTreeModel = new DefaultTreeModel(rootNode);
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject folder = fs.getRoot().getFileObject("org-netbeans-modules-java-hints/rules/suggestions");
        List<Pair<Rule, FileObject>> rules = RulesManager.readRules(folder);
        RulesManager.categorizeTreeRules(rules, suggestions, folder, rootNode);
    }

    private static List<Pair<Rule, FileObject>> readRules(FileObject folder) {
        LinkedList<Pair<Rule, FileObject>> rules = new LinkedList<Pair<Rule, FileObject>>();
        if (folder == null) {
            return rules;
        }
        HashMap dir2node = new HashMap();
        Enumeration e = folder.getData(true);
        while (e.hasMoreElements()) {
            FileObject o = (FileObject)e.nextElement();
            String name = o.getNameExt().toLowerCase();
            if (!o.canRead()) continue;
            Rule r = null;
            if (name.endsWith(INSTANCE_EXT)) {
                r = RulesManager.instantiateRule(o);
            }
            if (r == null) continue;
            rules.add(new Pair<Rule, FileObject>(r, o));
        }
        return rules;
    }

    private static void categorizeErrorRules(List<Pair<Rule, FileObject>> rules, Map<String, List<ErrorRule>> dest, FileObject rootFolder, DefaultMutableTreeNode rootNode) {
        HashMap<FileObject, DefaultMutableTreeNode> dir2node = new HashMap<FileObject, DefaultMutableTreeNode>();
        dir2node.put(rootFolder, rootNode);
        for (Pair<Rule, FileObject> pair : rules) {
            Rule rule = pair.getA();
            FileObject fo = pair.getB();
            if (rule instanceof ErrorRule) {
                RulesManager.addRule((ErrorRule)rule, dest);
                FileObject parent = fo.getParent();
                DefaultMutableTreeNode category = (DefaultMutableTreeNode)dir2node.get(parent);
                if (category == null) {
                    category = new DefaultMutableTreeNode(parent);
                    rootNode.add(category);
                    dir2node.put(parent, category);
                }
                category.add(new DefaultMutableTreeNode(rule, false));
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fo.getPath() + "is not instance of ErrorRule");
        }
    }

    private static void categorizeTreeRules(List<Pair<Rule, FileObject>> rules, Map<Tree.Kind, List<TreeRule>> dest, FileObject rootFolder, DefaultMutableTreeNode rootNode) {
        HashMap<FileObject, DefaultMutableTreeNode> dir2node = new HashMap<FileObject, DefaultMutableTreeNode>();
        dir2node.put(rootFolder, rootNode);
        for (Pair<Rule, FileObject> pair : rules) {
            Rule rule = pair.getA();
            FileObject fo = pair.getB();
            if (rule instanceof TreeRule) {
                RulesManager.addRule((TreeRule)rule, dest);
                FileObject parent = fo.getParent();
                DefaultMutableTreeNode category = (DefaultMutableTreeNode)dir2node.get(parent);
                if (category == null) {
                    category = new DefaultMutableTreeNode(parent);
                    rootNode.add(category);
                    dir2node.put(parent, category);
                }
                category.add(new DefaultMutableTreeNode(rule, false));
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fo.getPath() + "is not instance of TreeRule");
        }
    }

    private static void addRule(TreeRule rule, Map<Tree.Kind, List<TreeRule>> dest) {
        for (Tree.Kind kind : rule.getTreeKinds()) {
            List<TreeRule> l = dest.get((Object)kind);
            if (l == null) {
                l = new LinkedList<TreeRule>();
                dest.put(kind, l);
            }
            l.add(rule);
        }
    }

    private static void addRule(ErrorRule rule, Map<String, List<ErrorRule>> dest) {
        for (String code : rule.getCodes()) {
            List<ErrorRule> l = dest.get(code);
            if (l == null) {
                l = new LinkedList<ErrorRule>();
                dest.put(code, l);
            }
            l.add(rule);
        }
    }

    private static Rule instantiateRule(FileObject fileObject) {
        try {
            DataObject dobj = DataObject.find((FileObject)fileObject);
            InstanceCookie ic = (InstanceCookie)dobj.getCookie(InstanceCookie.class);
            Object instance = ic.instanceCreate();
            if (instance instanceof Rule) {
                return (Rule)instance;
            }
            return null;
        }
        catch (IOException e) {
            LOG.log(Level.INFO, null, e);
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.INFO, null, e);
        }
        return null;
    }
}

