/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.modules.java.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.java.hints.infrastructure.RulesManager;
import org.netbeans.modules.java.hints.spi.TreeRule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionsTask
extends ScanningCancellableTask<CompilationInfo> {
    public void run(CompilationInfo info) throws Exception {
        this.resume();
        HashMap<Tree.Kind, List<TreeRule>> suggestions = new HashMap<Tree.Kind, List<TreeRule>>();
        suggestions.putAll(RulesManager.getInstance().getHints(true));
        for (Map.Entry<Tree.Kind, List<TreeRule>> e : RulesManager.getInstance().getSuggestions().entrySet()) {
            List rules = (List)suggestions.get((Object)e.getKey());
            if (rules != null) {
                LinkedList res = new LinkedList();
                res.addAll(rules);
                res.addAll(e.getValue());
                suggestions.put(e.getKey(), res);
                continue;
            }
            suggestions.put(e.getKey(), e.getValue());
        }
        if (suggestions.isEmpty()) {
            HintsController.setErrors((FileObject)info.getFileObject(), (String)SuggestionsTask.class.getName(), Collections.emptyList());
            return;
        }
        int position = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)info.getFileObject());
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        if (position != -1) {
            for (TreePath tp = info.getTreeUtilities().pathFor(position); tp != null; tp = tp.getParentPath()) {
                if (this.isCancelled()) {
                    return;
                }
                Tree.Kind k = tp.getLeaf().getKind();
                List rules = (List)suggestions.get((Object)k);
                if (rules == null) continue;
                for (TreeRule rule : rules) {
                    if (this.isCancelled()) {
                        return;
                    }
                    List<ErrorDescription> errors = rule.run(info, tp);
                    if (errors == null) continue;
                    result.addAll(errors);
                }
            }
        }
        if (this.isCancelled()) {
            return;
        }
        HintsController.setErrors((FileObject)info.getFileObject(), (String)SuggestionsTask.class.getName(), result);
    }
}

