/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.netbeans.modules.java.hints.infrastructure.RulesManager;
import org.netbeans.modules.java.hints.options.HintsPanelLogic;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

final class HintsPanel
extends JPanel
implements TreeCellRenderer {
    private DefaultTreeCellRenderer dr = new DefaultTreeCellRenderer();
    private JCheckBox renderer = new JCheckBox();
    private HintsPanelLogic logic;
    private JPanel customizerPanel;
    private JPanel descriptionPanel;
    private JTextArea descriptionTextArea;
    private JPanel detailsPanel;
    private JTree errorTree;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JPanel optionsPanel;
    private JComboBox severityComboBox;
    private JLabel severityLabel;
    private JCheckBox toProblemCheckBox;
    private JPanel treePanel;

    HintsPanel() {
        this.initComponents();
        this.errorTree.setCellRenderer(this);
        this.errorTree.setRootVisible(false);
        this.errorTree.setShowsRootHandles(true);
        this.errorTree.getSelectionModel().setSelectionMode(1);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_AsError"));
        model.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_AsWarning"));
        model.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_WarningOnCurrentLine"));
        this.severityComboBox.setModel(model);
        this.toProblemCheckBox.setVisible(false);
        this.update();
        this.errorTree.setModel(RulesManager.getInstance().getHintsTreeModel());
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.treePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.errorTree = new JTree();
        this.detailsPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.severityLabel = new JLabel();
        this.severityComboBox = new JComboBox();
        this.toProblemCheckBox = new JCheckBox();
        this.customizerPanel = new JPanel();
        this.descriptionPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setDividerLocation(320);
        this.jSplitPane1.setDividerSize(5);
        this.treePanel.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.errorTree);
        this.treePanel.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setLeftComponent(this.treePanel);
        this.detailsPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.detailsPanel.setLayout(new GridBagLayout());
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(HintsPanel.class, (String)"CTL_Options_Border")));
        this.optionsPanel.setLayout(new GridBagLayout());
        this.severityLabel.setLabelFor(this.severityComboBox);
        Mnemonics.setLocalizedText((JLabel)this.severityLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_ShowAs_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 7, 8, 0);
        this.optionsPanel.add((Component)this.severityLabel, gridBagConstraints);
        this.severityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 7, 8, 7);
        this.optionsPanel.add((Component)this.severityComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.toProblemCheckBox, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_InTasklist_CheckBox"));
        this.toProblemCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.toProblemCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 7, 6, 7);
        this.optionsPanel.add((Component)this.toProblemCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.optionsPanel.add((Component)this.customizerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.detailsPanel.add((Component)this.optionsPanel, gridBagConstraints);
        this.descriptionPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(HintsPanel.class, (String)"CTL_Description_Border")));
        this.descriptionPanel.setLayout(new GridBagLayout());
        this.descriptionTextArea.setColumns(20);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setRows(5);
        this.jScrollPane2.setViewportView(this.descriptionTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.descriptionPanel.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.detailsPanel.add((Component)this.descriptionPanel, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.detailsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
    }

    synchronized void update() {
        if (this.logic != null) {
            this.logic.disconnect();
        }
        this.logic = new HintsPanelLogic();
        this.logic.connect(this.errorTree, this.severityComboBox, this.toProblemCheckBox, this.customizerPanel, this.descriptionTextArea);
    }

    void cancel() {
        this.logic.disconnect();
        this.logic = null;
    }

    boolean isChanged() {
        return this.logic.isChanged();
    }

    void applyChanges() {
        this.logic.applyChanges();
        this.logic.disconnect();
        this.logic = null;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.renderer.setBackground(selected ? this.dr.getBackgroundSelectionColor() : this.dr.getBackgroundNonSelectionColor());
        this.renderer.setForeground(selected ? this.dr.getTextSelectionColor() : this.dr.getTextNonSelectionColor());
        this.renderer.setEnabled(true);
        Object data = ((DefaultMutableTreeNode)value).getUserObject();
        if (data instanceof FileObject) {
            FileObject fo = (FileObject)data;
            this.renderer.setText(this.getFileObjectLocalizedName(fo));
            this.renderer.setSelected(this.logic.isSelected((DefaultMutableTreeNode)value));
        } else if (data instanceof AbstractHint) {
            AbstractHint treeRule = (AbstractHint)data;
            this.renderer.setText(treeRule.getDisplayName());
            Preferences node = this.logic.getCurrentPrefernces(treeRule);
            this.renderer.setSelected(node.getBoolean("enabled", true));
        } else {
            this.renderer.setText(value.toString());
        }
        return this.renderer;
    }

    private String getFileObjectLocalizedName(FileObject fo) {
        Object o = fo.getAttribute("SystemFileSystem.localizingBundle");
        if (o instanceof String) {
            String bundleName = (String)o;
            try {
                ResourceBundle rb = NbBundle.getBundle((String)bundleName);
                String localizedName = rb.getString(fo.getPath());
                return localizedName;
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        return fo.getPath();
    }
}

