/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.ErrorManager;

public class JavadocForBinaryQueryImpl
implements JavadocForBinaryQueryImplementation {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(JavadocForBinaryQueryImpl.class.getName());

    public JavadocForBinaryQuery.Result findJavadoc(URL binary) {
        boolean log = ERR.isLoggable(1);
        Project project = FileOwnerQuery.getOwner((URI)URI.create(binary.toString()));
        if (project != null) {
            JavadocForBinaryQueryImplementation jfbqi = (JavadocForBinaryQueryImplementation)project.getLookup().lookup(JavadocForBinaryQueryImplementation.class);
            if (jfbqi != null) {
                JavadocForBinaryQuery.Result result = jfbqi.findJavadoc(binary);
                if (log) {
                    ERR.log("Project " + project + " reported for " + binary + ": " + (result != null ? Arrays.asList(result.getRoots()) : null));
                }
                return result;
            }
            if (log) {
                ERR.log("Project " + project + " did not have any JavadocForBinaryQueryImplementation");
            }
        } else if (log) {
            ERR.log("No project found for " + binary + "; cannot find Javadoc");
        }
        return null;
    }
}

