/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.java.project.support.ui.IncludeExcludeVisualizerPanel;
import org.netbeans.spi.project.support.ant.PathMatcher;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class IncludeExcludeVisualizer {
    private File[] roots = new File[0];
    private String includes = "**";
    private String excludes = "";
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>(1);
    private IncludeExcludeVisualizerPanel panel;
    private SortedSet<File> included = new TreeSet<File>();
    private SortedSet<File> excluded = new TreeSet<File>();
    private boolean busy = false;
    private boolean interrupted = false;
    private static final RequestProcessor RP = new RequestProcessor(IncludeExcludeVisualizer.class.getName());
    private final RequestProcessor.Task task = RP.create((Runnable)new RecalculateTask());
    private static final int DELAY = 200;
    private int scanCounter;
    private static final int GRANULARITY = 1000;

    public synchronized void setRoots(File[] roots) throws IllegalArgumentException {
        Parameters.notNull((CharSequence)"roots", (Object)roots);
        for (File root : roots) {
            if (root.isDirectory()) continue;
            throw new IllegalArgumentException(root.getAbsolutePath());
        }
        this.roots = roots;
        this.recalculate();
    }

    public synchronized String getIncludePattern() {
        return this.includes;
    }

    public synchronized void setIncludePattern(String pattern) {
        Parameters.notNull((CharSequence)"pattern", (Object)pattern);
        this.includes = pattern;
        this.updateIncludesExcludes();
        this.recalculate();
    }

    public synchronized String getExcludePattern() {
        return this.excludes;
    }

    public synchronized void setExcludePattern(String pattern) {
        Parameters.notNull((CharSequence)"pattern", (Object)pattern);
        this.excludes = pattern;
        this.updateIncludesExcludes();
        this.recalculate();
    }

    private synchronized void updateIncludesExcludes() {
        if (this.panel != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    IncludeExcludeVisualizer.this.panel.setFields(IncludeExcludeVisualizer.this.includes, IncludeExcludeVisualizer.this.excludes);
                }
            });
        }
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    synchronized void changedPatterns(String includes, String excludes) {
        this.includes = includes;
        this.excludes = excludes;
        this.recalculate();
        this.fireChange();
    }

    private synchronized void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    public synchronized JComponent getVisualizerPanel() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalThreadStateException("must be called in EQ");
        }
        if (this.panel == null) {
            this.panel = new IncludeExcludeVisualizerPanel(this);
            this.panel.setFields(this.includes, this.excludes);
            this.panel.setFiles(this.included.toArray(new File[this.included.size()]), this.excluded.toArray(new File[this.excluded.size()]), this.busy);
        }
        return this.panel;
    }

    private synchronized void recalculate() {
        this.interrupted = true;
        this.task.schedule(200);
    }

    private void updateFiles() {
        assert (Thread.holdsLock(this));
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                IncludeExcludeVisualizer includeExcludeVisualizer = IncludeExcludeVisualizer.this;
                synchronized (includeExcludeVisualizer) {
                    if (IncludeExcludeVisualizer.this.panel != null) {
                        IncludeExcludeVisualizer.this.panel.setFiles(IncludeExcludeVisualizer.this.included.toArray(new File[IncludeExcludeVisualizer.this.included.size()]), IncludeExcludeVisualizer.this.excluded.toArray(new File[IncludeExcludeVisualizer.this.excluded.size()]), IncludeExcludeVisualizer.this.busy);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(File d, String prefix, PathMatcher matcher, Pattern ignoredFiles) {
        String[] children = d.list();
        if (children == null) {
            return;
        }
        for (String child : children) {
            if (ignoredFiles.matcher(child).find()) continue;
            File f = new File(d, child);
            boolean dir = f.isDirectory();
            if (dir) {
                this.scan(f, prefix + child + "/", matcher, ignoredFiles);
                continue;
            }
            IncludeExcludeVisualizer includeExcludeVisualizer = this;
            synchronized (includeExcludeVisualizer) {
                if (this.interrupted) {
                    return;
                }
                if (matcher.matches(prefix + child, false)) {
                    this.included.add(f);
                } else {
                    this.excluded.add(f);
                }
                if (++this.scanCounter % 1000 == 0) {
                    this.updateFiles();
                }
            }
        }
    }

    private final class RecalculateTask
    implements Runnable {
        final Pattern ignoredFiles = Pattern.compile(NbPreferences.root().node("/org/netbeans/core").get("IgnoredFiles", "^(CVS|SCCS|vssver\\.scc|#.*#|%.*%|\\.(cvsignore|svn|DS_Store)|_svn)$|~$|^\\..*$"));

        private RecalculateTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String _excludes;
            String _includes;
            File[] _roots;
            IncludeExcludeVisualizer includeExcludeVisualizer = IncludeExcludeVisualizer.this;
            synchronized (includeExcludeVisualizer) {
                IncludeExcludeVisualizer.this.busy = true;
                IncludeExcludeVisualizer.this.included.clear();
                IncludeExcludeVisualizer.this.excluded.clear();
                _roots = (File[])IncludeExcludeVisualizer.this.roots.clone();
                _includes = IncludeExcludeVisualizer.this.includes;
                _excludes = IncludeExcludeVisualizer.this.excludes;
                IncludeExcludeVisualizer.this.interrupted = false;
                IncludeExcludeVisualizer.this.updateFiles();
            }
            PathMatcher matcher = new PathMatcher(_includes, _excludes, null);
            for (File root : _roots) {
                IncludeExcludeVisualizer.this.scan(root, "", matcher, this.ignoredFiles);
            }
            IncludeExcludeVisualizer includeExcludeVisualizer2 = IncludeExcludeVisualizer.this;
            synchronized (includeExcludeVisualizer2) {
                IncludeExcludeVisualizer.this.busy = false;
                IncludeExcludeVisualizer.this.updateFiles();
            }
        }
    }
}

