/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.binding;

import com.sun.java.util.ObservableList;
import com.sun.java.util.ObservableListListener;
import com.sun.java.util.ObservableMap;
import com.sun.java.util.ObservableMapListener;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetManager {
    private final ResultSet resultSet;
    private final List<Row> contents;
    private final ListImpl vendedList;
    private final Column[] columns;
    private final Map<Object, Column> columnMap;
    private final Set<Row> modified;
    private int size;

    public ResultSetManager(ResultSet resultSet) throws SQLException {
        this(resultSet, true);
    }

    public ResultSetManager(ResultSet resultSet, boolean useColumnNamesAsKeys) throws SQLException {
        this.resultSet = resultSet;
        if (resultSet == null) {
            throw new IllegalArgumentException("ResultSet must be non-null");
        }
        this.contents = new ArrayList<Row>(this.size);
        this.vendedList = new ListImpl();
        this.modified = new HashSet<Row>();
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        this.columnMap = new HashMap<Object, Column>(columnCount);
        this.columns = new Column[columnCount];
        for (int i = 0; i < metaData.getColumnCount(); ++i) {
            String key;
            String string = key = useColumnNamesAsKeys ? metaData.getColumnName(i + 1) : Integer.toString(i);
            if (this.columnMap.containsKey(key)) {
                int j = 2;
                while (this.columnMap.containsKey(key + j)) {
                    ++j;
                }
                key = key + j;
            }
            this.columns[i] = new Column(i, key, metaData.getColumnType(i + 1));
            this.columnMap.put(key, this.columns[i]);
        }
        this.fetchAll();
    }

    public final ResultSet getResultSet() {
        return this.resultSet;
    }

    public final List<Map<Object, Object>> getContentsAsList() {
        return this.vendedList;
    }

    private void fetchAll() throws SQLException {
        while (this.resultSet.next()) {
            ++this.size;
            Object[] rowData = new Object[this.columns.length];
            for (int i = 0; i < this.columns.length; ++i) {
                rowData[i] = this.resultSet.getObject(i + 1);
            }
            this.contents.add(new Row(rowData));
        }
    }

    private Row getRow(int index) {
        return this.contents.get(index);
    }

    private void rowChanged(Row entry) {
        this.modified.add(entry);
        this.vendedList.fireEntryChanged(this.vendedList.indexOf(entry));
    }

    public Set<Map<Object, Object>> getModifiedEntries() {
        HashSet<Map<Object, Object>> modifiedCopy = new HashSet<Map<Object, Object>>(this.modified);
        return modifiedCopy;
    }

    public void clearModifiedEntries() {
        this.modified.clear();
    }

    public Map<Object, Object> deleteRow(Map<Object, Object> row) {
        int index = this.contents.indexOf(row);
        if (index != -1) {
            this.contents.remove(index);
            --this.size;
            this.vendedList.fireEntryRemoved(index, row);
            return row;
        }
        return null;
    }

    public Map<Object, Object> addRow(int index) {
        Row newRow = new Row(new Object[this.columns.length]);
        this.contents.add(index, newRow);
        ++this.size;
        this.vendedList.fireEntryAdded(index);
        return newRow;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractIterator<T>
    implements Iterator<T> {
        protected int index;

        AbstractIterator() {
            this.index = ResultSetManager.this.columns.length > 0 ? -1 : 0;
        }

        @Override
        public final boolean hasNext() {
            return this.index < ResultSetManager.this.columns.length;
        }

        @Override
        public final T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.get(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract T get(int var1);
    }

    private static final class Column {
        private final int index;
        private final String name;
        private final int type;

        Column(int index, String name, int type) {
            this.index = index;
            this.name = name;
            this.type = type;
        }

        private String getName() {
            return this.name;
        }

        private int getZeroBasedIndex() {
            return this.index;
        }

        private int getType() {
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySetImpl
    extends AbstractSet<Object> {
        private KeySetImpl() {
        }

        @Override
        public int size() {
            return ResultSetManager.this.columns.length;
        }

        @Override
        public boolean contains(Object k) {
            return ResultSetManager.this.columnMap.containsKey(k);
        }

        @Override
        public Iterator<Object> iterator() {
            return new KeySetIteratorImpl();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySetIteratorImpl
    extends AbstractIterator<Object> {
        private KeySetIteratorImpl() {
        }

        @Override
        protected Object get(int index) {
            return ResultSetManager.this.columns[index];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ListImpl
    extends AbstractList<Map<Object, Object>>
    implements ObservableList<Map<Object, Object>> {
        private final List<ObservableListListener> listeners = new CopyOnWriteArrayList<ObservableListListener>();

        ListImpl() {
        }

        @Override
        public Map<Object, Object> get(int index) {
            return ResultSetManager.this.getRow(index);
        }

        @Override
        public int size() {
            return ResultSetManager.this.size;
        }

        @Override
        public void addObservableListListener(ObservableListListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeObservableListListener(ObservableListListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public boolean supportsElementPropertyChanged() {
            return true;
        }

        private void fireEntryChanged(int index) {
            for (ObservableListListener l : this.listeners) {
                l.listElementPropertyChanged(this, index);
            }
        }

        private void fireEntryRemoved(int index, Map<Object, Object> row) {
            ArrayList<Map<Object, Object>> removedList = new ArrayList<Map<Object, Object>>(1);
            removedList.add(row);
            for (ObservableListListener l : this.listeners) {
                l.listElementsRemoved(this, index, removedList);
            }
        }

        private void fireEntryAdded(int index) {
            for (ObservableListListener l : this.listeners) {
                l.listElementsAdded(this, index, 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Row
    implements Map<Object, Object>,
    ObservableMap<Object, Object> {
        private final Object[] contents;
        private List<ObservableMapListener> listeners;

        Row(Object[] contents) {
            this.contents = contents;
        }

        @Override
        public int size() {
            return ResultSetManager.this.columns.length;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return ResultSetManager.this.columnMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            for (int i = 0; i < this.contents.length; ++i) {
                if ((value != null || ResultSetManager.this.columns[i] != null) && (value == null || !value.equals(ResultSetManager.this.columns[i]))) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object get(Object key) {
            Column column = (Column)ResultSetManager.this.columnMap.get(key);
            if (column == null) {
                return null;
            }
            return this.contents[column.getZeroBasedIndex()];
        }

        @Override
        public Object put(Object key, Object value) {
            Column column = (Column)ResultSetManager.this.columnMap.get(key);
            if (column == null) {
                throw new IllegalArgumentException(key + " is not a valid column identifier");
            }
            Object oldValue = this.contents[column.getZeroBasedIndex()];
            this.contents[((Column)column).getZeroBasedIndex()] = value;
            if (this.listeners != null) {
                for (ObservableMapListener l : this.listeners) {
                    l.mapKeyValueChanged(this, key, oldValue);
                }
            }
            ResultSetManager.this.rowChanged(this);
            return oldValue;
        }

        @Override
        public Object remove(Object key) {
            return this.put(key, (Object)null);
        }

        @Override
        public void putAll(Map<? extends Object, ? extends Object> m) {
            for (Object object : m.keySet()) {
                this.put(object, m.get(object));
            }
        }

        @Override
        public void clear() {
            for (Object key : ResultSetManager.this.columnMap.keySet()) {
                this.put(key, (Object)null);
            }
        }

        @Override
        public Set<Object> keySet() {
            return new KeySetImpl();
        }

        @Override
        public Collection<Object> values() {
            return new ValueCollection();
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return new EntrySet();
        }

        @Override
        public void addObservableMapListener(ObservableMapListener listener) {
            if (this.listeners == null) {
                this.listeners = new CopyOnWriteArrayList<ObservableMapListener>();
            }
            this.listeners.add(listener);
        }

        @Override
        public void removeObservableMapListener(ObservableMapListener listener) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Row [");
            for (int i = 0; i < ResultSetManager.this.columns.length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(ResultSetManager.this.columns[i].getName());
                builder.append("=");
                builder.append(this.contents[i]);
            }
            builder.append("]");
            return builder.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class EntrySet
        extends AbstractSet<Map.Entry<Object, Object>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<Object, Object>> iterator() {
                return new EntrySetIterator();
            }

            @Override
            public int size() {
                return ResultSetManager.this.columns.length;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class EntrySetIterator
        extends AbstractIterator<Map.Entry<Object, Object>> {
            private EntrySetIterator() {
            }

            @Override
            protected Map.Entry<Object, Object> get(int index) {
                return new MapEntry(index);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class MapEntry
        implements Map.Entry<Object, Object> {
            private final int index;

            MapEntry(int index) {
                this.index = index;
            }

            @Override
            public Object getKey() {
                return ResultSetManager.this.columns[this.index];
            }

            @Override
            public Object getValue() {
                return Row.this.contents[this.index];
            }

            @Override
            public Object setValue(Object value) {
                return Row.this.put(ResultSetManager.this.columns[this.index], value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class ValueCollection
        extends AbstractCollection<Object> {
            private ValueCollection() {
            }

            @Override
            public int size() {
                return ResultSetManager.this.columns.length;
            }

            @Override
            public Iterator<Object> iterator() {
                return new ValueCollectionIterator();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class ValueCollectionIterator
        extends AbstractIterator<Object> {
            private ValueCollectionIterator() {
            }

            @Override
            protected Object get(int index) {
                return Row.this.contents[index];
            }
        }
    }
}

