/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.binding;

import com.sun.java.swing.binding.AbstractBindingHelper;
import com.sun.java.swing.binding.BindingBeanInfo;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.beans.binding.Binding;
import javax.swing.JCheckBox;

class JCheckBoxBindingHelper
extends AbstractBindingHelper {
    private final JCheckBox checkBox;
    private final PropertyDelegate delegate;
    private final ItemListener itemListener;
    private Binding.BindingController controller;

    public JCheckBoxBindingHelper(JCheckBox checkBox) {
        this.checkBox = checkBox;
        this.delegate = new PropertyDelegate();
        this.itemListener = new ItemHandler();
    }

    protected boolean shouldCreateBindingTarget(String property) {
        return property == "selected";
    }

    public void bind(Binding.BindingController controller, String property) {
        this.throwIfNonNull(this.controller);
        assert (property == "selected");
        this.controller = controller;
        this.updateComponentEnabledFromBinding();
        this.checkBox.addItemListener(this.itemListener);
    }

    public void unbind(Binding.BindingController controller, String property) {
        this.checkBox.removeItemListener(this.itemListener);
        this.controller = null;
    }

    public Object getPropertyDelegate() {
        return this.delegate;
    }

    public void sourceValueStateChanged(Binding.BindingController controller, String property) {
        this.updateComponentEnabledFromBinding();
    }

    protected Binding getBinding() {
        return this.controller.getBinding();
    }

    protected Component getComponent() {
        return this.checkBox;
    }

    private final class ItemHandler
    implements ItemListener {
        private ItemHandler() {
        }

        public void itemStateChanged(ItemEvent e) {
            JCheckBoxBindingHelper.this.delegate.fireSelectedChanged();
        }
    }

    public final class PropertyDelegate
    extends AbstractBindingHelper.DelegateBase {
        public void setSelected(boolean selected) {
            JCheckBoxBindingHelper.this.checkBox.setSelected(selected);
        }

        public boolean isSelected() {
            return JCheckBoxBindingHelper.this.checkBox.isSelected();
        }

        private void fireSelectedChanged() {
            this.firePropertyChange("selected", null, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PropertyDelegateBeanInfo
    extends BindingBeanInfo {
        @Override
        protected Class<?> getPropertyDelegateClass() {
            return PropertyDelegate.class;
        }

        @Override
        protected BindingBeanInfo.Property[] getPreferredProperties() {
            return new BindingBeanInfo.Property[]{new BindingBeanInfo.Property("selected", "Whether the check box is selected")};
        }
    }
}

