/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.binding;

import com.sun.java.swing.binding.AbstractListTableBindingSupport;
import com.sun.java.swing.binding.ListBindingManager;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.beans.binding.Binding;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JListBindingHelper
extends AbstractListTableBindingSupport {
    private final JList list;
    private final AbstractListTableBindingSupport.PropertyDelegate delegate;
    private BindingListModel model;
    private Binding elementsBinding;
    private Binding.BindingController elementsBindingController;
    private BindingListCellRenderer renderer;
    private List<?> rendererBindings;
    private boolean changingRenderer;

    public JListBindingHelper(JList list) {
        this.list = list;
        this.delegate = new AbstractListTableBindingSupport.PropertyDelegate();
        list.addPropertyChangeListener(this);
        list.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public Object getPropertyDelegate() {
        return this.delegate;
    }

    @Override
    protected void bindElements(Binding.BindingController controller) {
        this.model = new BindingListModel(controller);
        this.elementsBinding = controller.getBinding();
        this.elementsBindingController = controller;
    }

    @Override
    protected void unbindElements() {
        this.elementsBinding = null;
        this.elementsBindingController = null;
        if (this.model != null) {
            this.model.setElements(null);
            this.model = null;
            this.list.setModel(new DefaultListModel());
        }
        if (this.renderer != null) {
            this.renderer = null;
            this.setCellRenderer(null);
        }
    }

    @Override
    protected void setElements(List<?> elements) {
        this.model.setElements(elements);
        if (this.list.getModel() != this.model) {
            this.list.setModel(this.model);
        }
    }

    @Override
    protected List<?> getElements() {
        return this.model == null ? null : this.model.getElements();
    }

    @Override
    protected Object getSelectedElement() {
        int index = this.list.getSelectedIndex();
        if (index != -1) {
            return this.model.getElement(index);
        }
        return null;
    }

    @Override
    protected ListSelectionModel getSelectionModel() {
        return this.list.getSelectionModel();
    }

    @Override
    protected AbstractListTableBindingSupport.PropertyDelegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == "cellRenderer") {
            this.cellRendererChanged();
        } else {
            super.propertyChange(e);
        }
    }

    private void updateRenderer(boolean uninstall) {
        boolean resetRenderer = false;
        if (uninstall && this.renderer != null) {
            this.setCellRenderer(null);
            resetRenderer = true;
        }
        if (this.rendererBindings != null && this.rendererBindings.size() > 0) {
            this.resetBindingRenderer();
        } else if (resetRenderer) {
            this.setCellRenderer(this.createDefaultRenderer());
        }
    }

    private ListCellRenderer createDefaultRenderer() {
        ListCellRenderer listRenderer = (ListCellRenderer)UIManager.get("List.cellRenderer");
        if (listRenderer == null) {
            listRenderer = new DefaultListCellRenderer();
        }
        return listRenderer;
    }

    private void resetBindingRenderer() {
        ListCellRenderer listRenderer = this.list.getCellRenderer();
        if (listRenderer == null) {
            listRenderer = this.createDefaultRenderer();
        }
        this.renderer = new BindingListCellRenderer(listRenderer);
        this.setCellRenderer(this.renderer);
    }

    private void setCellRenderer(ListCellRenderer renderer) {
        this.changingRenderer = true;
        this.list.setCellRenderer(renderer);
        this.changingRenderer = false;
    }

    private void cellRendererChanged() {
        if (!this.changingRenderer) {
            this.updateRenderer(false);
        }
    }

    private final class BindingListCellRenderer
    implements ListCellRenderer {
        private final ListCellRenderer renderer;

        BindingListCellRenderer(ListCellRenderer renderer) {
            this.renderer = renderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BindingListModel
    extends ListBindingManager
    implements ListModel {
        private final List<ListDataListener> listeners;

        public BindingListModel(Binding.BindingController controller) {
            super(controller);
            this.listeners = new CopyOnWriteArrayList<ListDataListener>();
        }

        @Override
        protected void createColumnDescriptions(List<ListBindingManager.ColumnDescription> columns) {
            Binding binding = this.getController().getBinding();
            if (binding != null) {
                Binding elementsBinding = binding;
                JListBindingHelper.this.rendererBindings = null;
                for (Binding childBinding : elementsBinding.getBindings()) {
                    String targetPath = childBinding.getTargetPath();
                    if (targetPath != null) continue;
                    columns.add(new ListBindingManager.ColumnDescription(this, childBinding, 0, true, Object.class));
                }
            } else {
                JListBindingHelper.this.rendererBindings = null;
            }
        }

        @Override
        protected void allChanged() {
            this.contentsChanged(0, this.size());
            JListBindingHelper.this.updateRenderer(true);
        }

        @Override
        protected void valueChanged(int row, int column) {
            this.contentsChanged(row, row);
        }

        @Override
        protected void added(int index, int length) {
            ListDataEvent e = new ListDataEvent(this, 1, index, index + length - 1);
            for (ListDataListener listener : this.listeners) {
                listener.intervalAdded(e);
            }
        }

        @Override
        protected void removed(int index, int length) {
            ListDataEvent e = new ListDataEvent(this, 2, index, index + length - 1);
            for (ListDataListener listener : this.listeners) {
                listener.intervalRemoved(e);
            }
        }

        @Override
        protected void changed(int row) {
            this.contentsChanged(row, row);
        }

        private void contentsChanged(int row0, int row1) {
            ListDataEvent e = new ListDataEvent(this, 0, row0, row1);
            for (ListDataListener listener : this.listeners) {
                listener.contentsChanged(e);
            }
        }

        public Object getElementAt(int index) {
            return this.valueAt(index, 0);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        @Override
        public int getSize() {
            return this.size();
        }
    }
}

