/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.binding;

import com.sun.java.swing.binding.AbstractBindingHelper;
import com.sun.java.swing.binding.AbstractListTableBindingSupport;
import com.sun.java.swing.binding.ListBindingManager;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.beans.binding.Binding;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.binding.SwingBindingSupport;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JTableBindingHelper
extends AbstractListTableBindingSupport {
    private final JTable table;
    private final AbstractListTableBindingSupport.PropertyDelegate delegate;
    private BindingTableModel model;
    private Binding elementsBinding;
    private int lastAccessedRow;
    private int lastAccessedColumn;
    private Binding.BindingController elementsBindingController;
    private EditingBindingTarget editingBindingTarget;
    private List<Object> selectedElements;

    public JTableBindingHelper(JTable table) {
        this.table = table;
        this.delegate = new AbstractListTableBindingSupport.PropertyDelegate();
        table.addPropertyChangeListener(this);
        table.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public Object getPropertyDelegate() {
        return this.delegate;
    }

    @Override
    protected void bindElements(Binding.BindingController controller) {
        this.throwIfNonNull(this.elementsBindingController);
        this.replaceGenericEditorIfNecessary();
        this.elementsBinding = controller.getBinding();
        this.elementsBindingController = controller;
        this.model = new BindingTableModel(controller);
    }

    @Override
    protected void unbindElements() {
        this.unbindCellEditor(true);
        this.elementsBinding = null;
        this.elementsBindingController = null;
        if (this.model != null) {
            this.model.setElements(null);
            this.model = null;
            this.table.setModel(new DefaultTableModel());
        }
    }

    @Override
    protected void setElements(List<?> elements) {
        this.model.setElements(elements);
        if (this.table.getModel() != this.model) {
            this.table.setModel(this.model);
        }
    }

    @Override
    protected List<?> getElements() {
        return this.model == null ? null : this.model.getElements();
    }

    @Override
    protected Object getSelectedElement() {
        int index = this.table.getSelectedRow();
        if (index != -1) {
            return this.model.getElement(index);
        }
        return null;
    }

    private void unbindCellEditor(boolean stopIfNecessary) {
        if (this.editingBindingTarget != null) {
            this.editingBindingTarget.cleanup(stopIfNecessary);
            this.editingBindingTarget = null;
        }
    }

    private void cellEditorChanged() {
        this.unbindCellEditor(false);
        if (this.table.getCellEditor() != null) {
            this.editingBindingTarget = new EditingBindingTarget(this.table.getCellEditor(), this.model.getValueAt(this.lastAccessedRow, this.lastAccessedColumn), this.lastAccessedRow, this.lastAccessedColumn);
            Binding binding = this.model.getValueColumnDescription(this.lastAccessedColumn).getBinding();
            this.elementsBindingController.bind(binding, this.getElements().get(this.lastAccessedRow), this.editingBindingTarget, "value", true);
            this.editingBindingTarget.setBinding(binding);
        }
    }

    private void replaceGenericEditorIfNecessary() {
        TableCellEditor editor = this.table.getDefaultEditor(Object.class);
        if (!(editor instanceof GenericEditor)) {
            this.table.setDefaultEditor(Object.class, new GenericEditor());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        if (property == "tableCellEditor") {
            this.cellEditorChanged();
        } else {
            super.propertyChange(e);
        }
    }

    @Override
    protected ListSelectionModel getSelectionModel() {
        return this.table.getSelectionModel();
    }

    @Override
    protected AbstractListTableBindingSupport.PropertyDelegate getDelegate() {
        return this.delegate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BindingTableModel
    extends ListBindingManager
    implements TableModel {
        private final List<TableModelListener> listeners;

        BindingTableModel(Binding.BindingController controller) {
            super(controller);
            this.listeners = new CopyOnWriteArrayList<TableModelListener>();
        }

        @Override
        protected void createColumnDescriptions(List<ListBindingManager.ColumnDescription> columns) {
            if (JTableBindingHelper.this.elementsBinding != null) {
                for (Binding binding : JTableBindingHelper.this.elementsBinding.getBindings()) {
                    Integer column = binding.getValue(SwingBindingSupport.TableColumnParameter, null);
                    if (column == null) {
                        throw new IllegalArgumentException("JTable element binding must identify the column by way of SwingBindingSupport.TableColumnKey");
                    }
                    boolean isRenderer = false;
                    boolean isEditor = false;
                    boolean isValue = !isRenderer && !isEditor;
                    Class<Object> type = binding.getValue(SwingBindingSupport.TableColumnClassParameter, Object.class);
                    if (isValue && (isRenderer || isEditor) || isRenderer && (isValue || isEditor) || isEditor && (isValue || isRenderer) || !isValue && !isRenderer && !isEditor) {
                        throw new IllegalArgumentException("JTable element binding must include one of: SwingBindingSupport.TableValueKey, SwingBindingSupport.TableRendererKey SwingBindingSupport.TableEditorKey");
                    }
                    if (!isValue) continue;
                    columns.add(new ListBindingManager.ColumnDescription(this, binding, column, true, type));
                }
            }
        }

        private int getColumn(String path) {
            int value = 0;
            int max = path.length();
            for (int i = 0; i < max; ++i) {
                char aChar = path.charAt(i);
                if (aChar < '0' || aChar > '9') {
                    return -1;
                }
                value = value * 10 + (aChar - 48);
            }
            return value;
        }

        @Override
        public int getRowCount() {
            return this.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            JTableBindingHelper.this.lastAccessedRow = rowIndex;
            JTableBindingHelper.this.lastAccessedColumn = columnIndex;
            return this.valueAt(rowIndex, columnIndex);
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (JTableBindingHelper.this.editingBindingTarget != null && JTableBindingHelper.this.editingBindingTarget.getRow() == rowIndex && JTableBindingHelper.this.editingBindingTarget.getColumn() == columnIndex) {
                JTableBindingHelper.this.editingBindingTarget.setValue0(value);
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            ListBindingManager.ColumnDescription cd = this.getValueColumnDescription(columnIndex);
            if (cd != null) {
                return cd.getTargetType();
            }
            return Object.class;
        }

        @Override
        protected void allChanged() {
            this.fireTableModelEvent(new TableModelEvent(this, 0, Integer.MAX_VALUE));
        }

        @Override
        protected void valueChanged(int row, int column) {
            this.fireTableModelEvent(new TableModelEvent(this, row, row, column));
        }

        @Override
        protected void added(int row, int length) {
            this.fireTableModelEvent(new TableModelEvent(this, row, row + length - 1, -1, 1));
        }

        @Override
        protected void removed(int row, int length) {
            this.fireTableModelEvent(new TableModelEvent(this, row, row + length - 1, -1, -1));
        }

        @Override
        protected void changed(int row) {
            this.fireTableModelEvent(new TableModelEvent(this, row, row, -1));
        }

        @Override
        public String getColumnName(int columnIndex) {
            String path;
            Binding binding;
            ListBindingManager.ColumnDescription d = this.getValueColumnDescription(columnIndex);
            if (d != null && (binding = d.getBinding()) != null && (path = binding.getSourcePath()) != null) {
                String name = path;
                if (path.startsWith("${") && (path = path.substring(2)).endsWith("}")) {
                    if ((path = path.substring(0, path.length() - 1)).indexOf(46) != -1) {
                        path = path.substring(path.indexOf(46) + 1);
                        name = this.capitalize(path);
                    } else {
                        name = this.capitalize(path);
                    }
                }
                return name;
            }
            return "";
        }

        private String capitalize(String title) {
            StringBuilder builder = new StringBuilder(title);
            boolean lastWasUpper = false;
            for (int i = 0; i < builder.length(); ++i) {
                char aChar = builder.charAt(i);
                if (i == 0) {
                    builder.setCharAt(i, Character.toUpperCase(aChar));
                    lastWasUpper = true;
                    continue;
                }
                if (Character.isUpperCase(aChar)) {
                    if (!lastWasUpper) {
                        builder.insert(i, ' ');
                    }
                    lastWasUpper = true;
                    ++i;
                    continue;
                }
                lastWasUpper = false;
            }
            return builder.toString();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        private void fireTableModelEvent(TableModelEvent e) {
            for (TableModelListener listener : this.listeners) {
                listener.tableChanged(e);
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnCount();
        }
    }

    public final class EditingBindingTarget
    extends AbstractBindingHelper.DelegateBase
    implements CellEditorListener {
        private final CellEditor editor;
        private final int row;
        private final int column;
        private Binding binding;
        private boolean isEditing;
        private final Object iValue;
        private Object value;

        EditingBindingTarget(CellEditor editor, Object value, int row, int column) {
            this.editor = editor;
            this.row = row;
            this.column = column;
            editor.addCellEditorListener(this);
            this.value = value;
            this.iValue = value;
            this.isEditing = true;
        }

        private int getRow() {
            return this.row;
        }

        private int getColumn() {
            return this.column;
        }

        void setBinding(Binding binding) {
            this.binding = binding;
        }

        public void setValue(Object value) {
        }

        void setValue0(Object value) {
            this.value = value;
            this.firePropertyChange("value", null, null);
        }

        public Object getValue() {
            if (this.isEditing) {
                return this.editor.getCellEditorValue();
            }
            return this.value;
        }

        private Object getInitialValue() {
            return this.iValue;
        }

        public void editingStopped(ChangeEvent e) {
            this.isEditing = false;
            this.value = this.editor.getCellEditorValue();
        }

        public void editingCanceled(ChangeEvent e) {
            this.isEditing = false;
        }

        private void cleanup(boolean stopIfNecessary) {
            if (this.isEditing && stopIfNecessary) {
                this.editor.stopCellEditing();
            }
            if (this.binding != null) {
                this.editor.removeCellEditorListener(this);
                this.isEditing = false;
                Binding binding = this.binding;
                this.binding = null;
                JTableBindingHelper.this.elementsBindingController.unbindOnCommit(binding);
                this.firePropertyChange("value", null, null);
            }
        }
    }

    private static final class GenericEditor
    extends DefaultCellEditor {
        private boolean ignoreStop;

        GenericEditor() {
            super(new JTextField());
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.BLACK));
        }

        public Object getCellEditorValue() {
            this.ignoreStop = true;
            this.stopCellEditing();
            this.ignoreStop = false;
            return super.getCellEditorValue();
        }

        protected void fireEditingStopped() {
            if (!this.ignoreStop) {
                super.fireEditingStopped();
            }
        }
    }
}

