/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.binding;

import com.sun.java.swing.binding.AbstractBindingHelper;
import com.sun.java.swing.binding.BindingBeanInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.beans.binding.Binding;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.binding.SwingBindingSupport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

class JTextComponentBindingHelper
extends AbstractBindingHelper {
    private final JTextComponent textComponent;
    private final PropertyDelegate delegate;
    private final Handler handler;
    private final boolean preferFilter;
    private boolean inDocumentListener;
    private Document document;
    private boolean installedFilter;
    private boolean changingText;
    private DocumentFilter.FilterBypass filterBypass;
    private Binding.BindingController controller;

    JTextComponentBindingHelper(JTextComponent text, boolean preferFilter) {
        this.textComponent = text;
        this.preferFilter = preferFilter;
        this.delegate = new PropertyDelegate();
        this.handler = new Handler();
    }

    public Object getPropertyDelegate() {
        return this.delegate;
    }

    protected boolean shouldCreateBindingTarget(String property) {
        return property == "text";
    }

    public void bind(Binding.BindingController controller, String property) {
        this.throwIfNonNull(this.controller);
        assert (property == "text");
        this.controller = controller;
        this.textComponent.addPropertyChangeListener(this.handler);
        if (this.getChangeStrategy() != SwingBindingSupport.TextChangeStrategy.CHANGE_ON_TYPE) {
            this.textComponent.addFocusListener(this.handler);
        }
        if (this.getChangeStrategy() == SwingBindingSupport.TextChangeStrategy.CHANGE_ON_ACTION_OR_FOCUS_LOST && this.textComponent instanceof JTextField) {
            ((JTextField)this.textComponent).addActionListener(this.handler);
        }
        this.document = this.textComponent.getDocument();
        this.installDocumentListener();
        this.updateComponentEnabledFromBinding();
    }

    public void unbind(Binding.BindingController controller, String property) {
        assert (controller == this.controller && property == "text");
        this.textComponent.removePropertyChangeListener(this.handler);
        if (this.getChangeStrategy() != SwingBindingSupport.TextChangeStrategy.CHANGE_ON_TYPE) {
            this.textComponent.removeFocusListener(this.handler);
        }
        if (this.getChangeStrategy() == SwingBindingSupport.TextChangeStrategy.CHANGE_ON_ACTION_OR_FOCUS_LOST && this.textComponent instanceof JTextField) {
            ((JTextField)this.textComponent).removeActionListener(this.handler);
        }
        this.uninstallDocumentListener();
        this.controller = null;
        this.document = null;
    }

    public void sourceValueStateChanged(Binding.BindingController controller, String property) {
        this.updateComponentEnabledFromBinding();
    }

    protected Component getComponent() {
        return this.textComponent;
    }

    protected Binding getBinding() {
        return this.controller.getBinding();
    }

    protected void setComponentEnabled(boolean enable) {
        this.getComponent().setEnabled(enable);
        if (!enable) {
            this.setText("");
        }
    }

    private SwingBindingSupport.TextChangeStrategy getChangeStrategy() {
        return this.controller.getBinding().getValue(SwingBindingSupport.TextChangeStrategyParameter, SwingBindingSupport.TextChangeStrategy.CHANGE_ON_ACTION_OR_FOCUS_LOST);
    }

    private void installDocumentListener() {
        if (this.preferFilter && this.document instanceof AbstractDocument && ((AbstractDocument)this.document).getDocumentFilter() == null) {
            ((AbstractDocument)this.document).setDocumentFilter(this.handler);
            this.installedFilter = true;
        } else {
            this.document.addDocumentListener(this.handler);
            this.installedFilter = false;
        }
    }

    private void uninstallDocumentListener() {
        if (this.document != null) {
            if (this.installedFilter) {
                AbstractDocument ad = (AbstractDocument)this.document;
                if (ad.getDocumentFilter() == this.handler) {
                    ad.setDocumentFilter(null);
                }
            } else {
                this.document.removeDocumentListener(this.handler);
            }
        }
    }

    private void setText(String text) {
        this.changingText = true;
        this.textComponent.setText(text);
        this.textComponent.setCaretPosition(0);
        this.changingText = false;
    }

    private void documentChanged() {
        this.uninstallDocumentListener();
        this.document = this.textComponent.getDocument();
        this.installDocumentListener();
    }

    private void textChanged() {
        if (!this.changingText) {
            if (this.getChangeStrategy() == SwingBindingSupport.TextChangeStrategy.CHANGE_ON_TYPE) {
                this.delegate.fireTextChanged();
            } else {
                this.controller.valueEdited();
            }
        }
    }

    private boolean isUncommitted() {
        return this.controller.getBinding().getTargetValueState() != Binding.ValueState.VALID;
    }

    private final class ChangeTextRunnable
    implements Runnable {
        private final String text;

        ChangeTextRunnable(String text) {
            this.text = text;
        }

        public void run() {
            JTextComponentBindingHelper.this.setText(this.text);
        }
    }

    private final class Handler
    extends DocumentFilter
    implements ActionListener,
    DocumentListener,
    FocusListener,
    PropertyChangeListener {
        private Handler() {
        }

        public void insertUpdate(DocumentEvent e) {
            this.documentListenerTextChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.documentListenerTextChanged();
        }

        public void changedUpdate(DocumentEvent e) {
        }

        private void documentListenerTextChanged() {
            if (!JTextComponentBindingHelper.this.changingText) {
                JTextComponentBindingHelper.this.inDocumentListener = true;
                JTextComponentBindingHelper.this.textChanged();
                JTextComponentBindingHelper.this.inDocumentListener = false;
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            String property = e.getPropertyName();
            if (property == "document") {
                JTextComponentBindingHelper.this.documentChanged();
            }
        }

        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            JTextComponentBindingHelper.this.filterBypass = fb;
            super.replace(fb, offset, length, text, attrs);
            JTextComponentBindingHelper.this.textChanged();
            JTextComponentBindingHelper.this.filterBypass = null;
        }

        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            JTextComponentBindingHelper.this.filterBypass = fb;
            super.insertString(fb, offset, string, attr);
            JTextComponentBindingHelper.this.textChanged();
            JTextComponentBindingHelper.this.filterBypass = null;
        }

        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            JTextComponentBindingHelper.this.filterBypass = fb;
            super.remove(fb, offset, length);
            JTextComponentBindingHelper.this.textChanged();
            JTextComponentBindingHelper.this.filterBypass = null;
        }

        public void actionPerformed(ActionEvent e) {
            if (JTextComponentBindingHelper.this.getChangeStrategy() != SwingBindingSupport.TextChangeStrategy.CHANGE_ON_TYPE && JTextComponentBindingHelper.this.isUncommitted()) {
                JTextComponentBindingHelper.this.delegate.fireTextChanged();
            }
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (!e.isTemporary() && JTextComponentBindingHelper.this.getChangeStrategy() != SwingBindingSupport.TextChangeStrategy.CHANGE_ON_TYPE && JTextComponentBindingHelper.this.isUncommitted()) {
                JTextComponentBindingHelper.this.delegate.fireTextChanged();
            }
        }
    }

    public class PropertyDelegate
    extends AbstractBindingHelper.DelegateBase {
        public void setText(String text) {
            if (JTextComponentBindingHelper.this.inDocumentListener) {
                SwingUtilities.invokeLater(new ChangeTextRunnable(text));
            } else {
                JTextComponentBindingHelper.this.setText(text);
            }
        }

        public String getText() {
            return JTextComponentBindingHelper.this.textComponent.getText();
        }

        private void fireTextChanged() {
            this.firePropertyChange("text", null, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PropertyDelegateBeanInfo
    extends BindingBeanInfo {
        @Override
        protected Class<?> getPropertyDelegateClass() {
            return PropertyDelegate.class;
        }

        @Override
        protected BindingBeanInfo.Property[] getPreferredProperties() {
            return new BindingBeanInfo.Property[]{new BindingBeanInfo.Property("text", "The context of the text component")};
        }
    }
}

