/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.binding;

import com.sun.java.swing.binding.AbstractBindingHelper;
import com.sun.java.swing.binding.BindingBeanInfo;
import com.sun.java.util.ObservableList;
import com.sun.java.util.ObservableListListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.beans.binding.Binding;
import javax.beans.binding.ELPropertyResolver;
import javax.el.Expression;
import javax.swing.JTree;
import javax.swing.binding.SwingBindingSupport;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JTreeBindingHelper
extends AbstractBindingHelper
implements TreeSelectionListener {
    private final JTree tree;
    private final Map<Object, BindingNode> nodeMap;
    private final Map<Class<?>, Binding> elementMap;
    private final BindingTreeModel model;
    private Binding.BindingController controller;
    private BindingNode root;
    private PropertyDelegate delegate;
    private List<Object> selectedElements;
    private Object selectedElement;
    private boolean changingSelection;
    private boolean emptyNodesTreatedAsLeafs;

    public JTreeBindingHelper(JTree tree) {
        this.tree = tree;
        this.elementMap = new HashMap();
        this.nodeMap = new HashMap<Object, BindingNode>();
        this.root = new BindingNode(null, null);
        this.model = new BindingTreeModel();
        this.delegate = new PropertyDelegate();
        tree.addTreeSelectionListener(this);
    }

    @Override
    public Object getPropertyDelegate() {
        return this.delegate;
    }

    @Override
    protected boolean shouldCreateBindingTarget(String property) {
        return property == "root";
    }

    @Override
    public void bind(Binding.BindingController controller, String property) {
        if (property == "root") {
            this.bindRoot(controller);
        }
    }

    @Override
    public void unbind(Binding.BindingController controller, String property) {
        if (property == "root") {
            this.unbindRoot();
        }
    }

    private void bindRoot(Binding.BindingController controller) {
        if (this.controller != null) {
            throw new IllegalStateException("Already bound");
        }
        this.controller = controller;
        this.emptyNodesTreatedAsLeafs = controller.getBinding().getValue(SwingBindingSupport.EmptyNodeTreatedAsLeafParameter, Boolean.FALSE);
        this.calculateChildMapping(controller.getBinding());
        if (this.tree.getModel() != this.model) {
            this.tree.setModel(this.model);
        }
    }

    private void unbindRoot() {
        this.controller = null;
        this.tree.setModel(null);
        this.elementMap.clear();
    }

    private void setRoot(Object root) {
        HashSet<BindingNode> nodes = new HashSet<BindingNode>(this.nodeMap.values());
        for (BindingNode node : nodes) {
            node.dispose();
        }
        BindingNode node = new BindingNode(null, root);
        this.nodeMap.put(root, node);
        this.root = node;
        this.model.fireRootChanged();
    }

    private void updateSelectElements() {
        TreePath[] selectedPaths = this.tree.getSelectionModel().getSelectionPaths();
        if (selectedPaths == null) {
            this.selectedElements = new ArrayList<Object>(1);
        } else {
            this.selectedElements = new ArrayList<Object>(selectedPaths.length);
            for (TreePath path : selectedPaths) {
                this.selectedElements.add(path.getLastPathComponent());
            }
        }
        this.selectedElements = Collections.unmodifiableList(this.selectedElements);
        this.selectedElement = this.selectedElements.size() == 0 ? null : this.selectedElements.get(0);
    }

    private BindingNode getBindingNode(Object e) {
        return this.nodeMap.get(e);
    }

    private void createBindingNodeIfNecessary(BindingNode parentBindingNode, Object child) {
        BindingNode childNode = this.getBindingNode(child);
        if (childNode == null) {
            childNode = new BindingNode(parentBindingNode, child);
            this.nodeMap.put(child, childNode);
        }
    }

    private Binding getElementsBinding(Object source) {
        if (source != null) {
            return this.getElementsBinding(source.getClass());
        }
        return null;
    }

    private Binding getElementsBinding(Class<?> type) {
        Binding binding = this.elementMap.get(type);
        if (binding == null) {
            Class<?> superType = type.getSuperclass();
            binding = superType == null ? null : this.getElementsBinding(superType);
            this.elementMap.put(type, binding);
        }
        return binding;
    }

    private void nodeStructureChanged(BindingNode node) {
        this.model.fireTreeStructureChanged(node.getPathToRoot());
    }

    private void nodeElementsAdded(BindingNode node, int index, int length) {
        this.model.fireTreeNodesInserted(node.getPathToRoot(), index, length);
    }

    private void nodeElementsRemoved(BindingNode bindingNode, int index, List oldElements) {
        this.model.fireTreeNodesRemoved(bindingNode.getPathToRoot(), index, oldElements);
    }

    private void nodeElementReplaced(BindingNode bindingNode, int index, Object oldElement) {
        this.model.handleReplace(bindingNode, index, oldElement);
    }

    private void nodeElementPropertyChanged(BindingNode parent, int index) {
        this.model.fireTreeNodesChanged(parent, index);
    }

    private void calculateChildMapping(Binding binding) {
        this.elementMap.clear();
        for (Binding childBinding : binding.getBindings()) {
            Class type = childBinding.getValue(SwingBindingSupport.TreeNodeClassParameter, null);
            if (type == null) {
                throw new IllegalArgumentException("Must specify a class the binding is applicable to using the key SwingBindingSupport.TreeNodeClassKey");
            }
            this.elementMap.put(type, childBinding);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (!this.changingSelection) {
            Object lastSelectedElement = this.selectedElement;
            List<Object> lastSelectedElements = this.selectedElements;
            this.selectedElements = null;
            this.selectedElement = null;
            this.delegate.firePropertyChange("selectedElement", lastSelectedElement, null);
            this.delegate.firePropertyChange("selectedElements", lastSelectedElements, null);
        }
    }

    private void setSelectedElements(List<?> selection) {
        List newSelection;
        this.changingSelection = true;
        Object lastSelectedElement = this.selectedElement;
        List<Object> oldSelection = this.selectedElements;
        TreeSelectionModel selectionModel = this.tree.getSelectionModel();
        selectionModel.clearSelection();
        if (selection == null || selection.size() == 0) {
            newSelection = Collections.emptyList();
        } else {
            newSelection = new ArrayList(selection.size());
            for (Object elem : selection) {
                BindingNode node = this.getBindingNode(elem);
                if (node == null) continue;
                newSelection.add(elem);
                selectionModel.addSelectionPath(node.getPathToRoot());
            }
        }
        this.selectedElement = newSelection.size() == 0 ? null : newSelection.get(0);
        this.selectedElements = Collections.unmodifiableList(newSelection);
        this.changingSelection = false;
        this.delegate.firePropertyChange("selectedElement", lastSelectedElement, this.selectedElement);
        this.delegate.firePropertyChange("selectedElements", oldSelection, this.selectedElements);
    }

    private List<?> getSelectedElements() {
        if (this.selectedElements == null) {
            this.updateSelectElements();
        }
        return this.selectedElements;
    }

    private Object getSelectedElement() {
        if (this.selectedElement == null) {
            this.updateSelectElements();
        }
        return this.selectedElement;
    }

    private boolean getEmptyNodesTreatedAsLeafs() {
        return this.emptyNodesTreatedAsLeafs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BindingNode
    extends ELPropertyResolver.Delegate
    implements ObservableListListener {
        private final BindingNode parent;
        private final Object source;
        private boolean loaded;
        private List<?> elements;
        private ELPropertyResolver resolver;

        private BindingNode(BindingNode parent, Object source) {
            this.parent = parent;
            this.source = source;
        }

        boolean isLeaf() {
            if (this.elements == null) {
                return JTreeBindingHelper.this.getElementsBinding(this.source) == null;
            }
            return false;
        }

        private Object getSource() {
            return this.source;
        }

        public TreePath getPathToRoot() {
            if (this.parent == null) {
                return new TreePath(this.source);
            }
            return this.parent.getPathToRoot().pathByAddingChild(this.source);
        }

        public BindingNode getParent() {
            return this.parent;
        }

        private void setElements(List<?> elements) {
            if (this.elements != null) {
                if (this.elements instanceof ObservableList) {
                    ((ObservableList)this.elements).removeObservableListListener(this);
                }
                this.disposeChildren();
            }
            this.elements = elements;
            if (elements instanceof ObservableList) {
                ((ObservableList)elements).addObservableListListener(this);
            }
            if (this.loaded) {
                JTreeBindingHelper.this.nodeStructureChanged(this);
            }
        }

        public List<?> getElements() {
            if (!this.loaded) {
                this.loadElements();
            }
            return this.elements;
        }

        private void loadElements() {
            Binding binding = JTreeBindingHelper.this.getElementsBinding(this.source);
            if (binding != null) {
                this.resolver = JTreeBindingHelper.this.controller.createResolver();
                this.resolver.setSource(this.source);
                this.resolver.setPath(binding.getSourcePath());
                this.resolver.bind();
                this.resolver.setDelegate(this);
                this.valueChanged(this.resolver);
            }
            this.loaded = true;
        }

        private void dispose() {
            JTreeBindingHelper.this.nodeMap.remove(this);
            if (this.elements instanceof ObservableList) {
                ((ObservableList)this.elements).removeObservableListListener(this);
            }
            this.elements = null;
            if (this.resolver != null) {
                this.resolver.unbind();
                this.resolver = null;
            }
        }

        private void disposeChildren() {
            if (this.elements != null) {
                for (Object elem : this.elements) {
                    BindingNode childNode = JTreeBindingHelper.this.getBindingNode(elem);
                    if (childNode == null) continue;
                    childNode.disposeChildren();
                    childNode.dispose();
                }
            }
        }

        @Override
        public void valueChanged(ELPropertyResolver resolver) {
            if (resolver.getEvaluationResultType() == Expression.Result.Type.SINGLE_VALUE) {
                this.setElements((List)resolver.getValueOfLastProperty());
            }
        }

        @Override
        public void listElementsAdded(ObservableList list, int index, int length) {
            JTreeBindingHelper.this.nodeElementsAdded(this, index, length);
        }

        @Override
        public void listElementsRemoved(ObservableList list, int index, List oldElements) {
            for (Object elem : oldElements) {
                BindingNode node = JTreeBindingHelper.this.getBindingNode(elem);
                if (node == null) continue;
                node.disposeChildren();
                node.dispose();
            }
            JTreeBindingHelper.this.nodeElementsRemoved(this, index, oldElements);
        }

        @Override
        public void listElementReplaced(ObservableList list, int index, Object oldElement) {
            BindingNode node = JTreeBindingHelper.this.getBindingNode(oldElement);
            if (node != null) {
                node.disposeChildren();
                node.dispose();
            }
            JTreeBindingHelper.this.nodeElementReplaced(this, index, oldElement);
        }

        @Override
        public void listElementPropertyChanged(ObservableList list, int index) {
            JTreeBindingHelper.this.nodeElementPropertyChanged(this, index);
        }
    }

    private class BindingTreeModel
    implements TreeModel {
        private final List<TreeModelListener> listeners = new CopyOnWriteArrayList<TreeModelListener>();
        private BindingNode removeParent;
        private int removeHole;

        public Object getRoot() {
            return JTreeBindingHelper.this.root.getSource();
        }

        public Object getChild(Object parent, int index) {
            BindingNode parentBindingNode = JTreeBindingHelper.this.getBindingNode(parent);
            if (parentBindingNode == this.removeParent && index >= this.removeHole) {
                --index;
            }
            Object child = parentBindingNode.getElements().get(index);
            JTreeBindingHelper.this.createBindingNodeIfNecessary(parentBindingNode, child);
            return child;
        }

        public int getChildCount(Object parent) {
            BindingNode node = JTreeBindingHelper.this.getBindingNode(parent);
            List<?> elements = node.getElements();
            if (node == this.removeParent) {
                return elements.size() - 1;
            }
            return elements == null ? 0 : elements.size();
        }

        public boolean isLeaf(Object node) {
            boolean isLeaf = JTreeBindingHelper.this.getBindingNode(node).isLeaf();
            if (!isLeaf && JTreeBindingHelper.this.getEmptyNodesTreatedAsLeafs() && this.getChildCount(node) == 0) {
                return true;
            }
            return isLeaf;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public int getIndexOfChild(Object parent, Object child) {
            BindingNode node = JTreeBindingHelper.this.getBindingNode(parent);
            int index = node.getElements().indexOf(child);
            if (node == this.removeParent && index > this.removeHole) {
                --index;
            }
            return index;
        }

        public void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        public void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }

        private void fireTreeStructureChanged(TreePath treePath) {
            TreeModelEvent e = new TreeModelEvent((Object)this, treePath);
            for (TreeModelListener l : this.listeners) {
                l.treeStructureChanged(e);
            }
        }

        private void fireTreeNodesInserted(TreePath treePath, int index, int length) {
            int[] indices = new int[length];
            Object[] children = new Object[length];
            List<?> elements = JTreeBindingHelper.this.getBindingNode(treePath.getLastPathComponent()).getElements();
            for (int i = 0; i < length; ++i) {
                indices[i] = index + i;
                children[i] = elements.get(index + i);
            }
            TreeModelEvent e = new TreeModelEvent((Object)this, treePath, indices, children);
            for (TreeModelListener l : this.listeners) {
                l.treeNodesInserted(e);
            }
        }

        private void fireTreeNodesRemoved(TreePath treePath, int index, List oldElements) {
            int length = oldElements.size();
            int[] indices = new int[length];
            Object[] children = new Object[length];
            for (int i = 0; i < length; ++i) {
                indices[i] = index + i;
                children[i] = oldElements.get(i);
            }
            TreeModelEvent e = new TreeModelEvent((Object)this, treePath, indices, children);
            for (TreeModelListener l : this.listeners) {
                l.treeNodesRemoved(e);
            }
        }

        private void handleReplace(BindingNode node, int index, Object oldElement) {
            this.removeParent = node;
            this.removeHole = index;
            this.fireTreeNodesRemoved(node.getPathToRoot(), index, Arrays.asList(oldElement));
            this.removeParent = null;
            this.removeHole = -1;
            this.fireTreeNodesInserted(node.getPathToRoot(), index, 1);
        }

        private void fireTreeNodesChanged(BindingNode parent, int index) {
            TreeModelEvent e;
            if (parent == JTreeBindingHelper.this.root) {
                e = new TreeModelEvent((Object)this, parent.getPathToRoot(), null, null);
            } else {
                int[] indices = new int[]{index};
                Object[] children = new Object[]{parent.getElements().get(index)};
                e = new TreeModelEvent((Object)this, parent.getPathToRoot(), indices, children);
            }
            for (TreeModelListener l : this.listeners) {
                l.treeNodesChanged(e);
            }
        }

        private void fireRootChanged() {
            this.fireTreeStructureChanged(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class PropertyDelegate
    extends AbstractBindingHelper.DelegateBase {
        public void setRoot(Object root) {
            JTreeBindingHelper.this.setRoot(root);
        }

        public Object getRoot() {
            return JTreeBindingHelper.this.root;
        }

        public void setSelectedElements(List<?> elements) {
            JTreeBindingHelper.this.setSelectedElements(elements);
        }

        public List<?> getSelectedElements() {
            return JTreeBindingHelper.this.getSelectedElements();
        }

        public void setSelectedElement(Object element) {
            if (element == null) {
                JTreeBindingHelper.this.setSelectedElements(Collections.emptyList());
            } else {
                JTreeBindingHelper.this.setSelectedElements(Arrays.asList(element));
            }
        }

        public Object getSelectedElement() {
            return JTreeBindingHelper.this.getSelectedElement();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PropertyDelegateBeanInfo
    extends BindingBeanInfo {
        @Override
        protected Class<?> getPropertyDelegateClass() {
            return PropertyDelegate.class;
        }

        @Override
        protected BindingBeanInfo.Property[] getPreferredProperties() {
            return new BindingBeanInfo.Property[]{new BindingBeanInfo.Property("root", "The root of the tree"), new BindingBeanInfo.Property("selectedElement", "The selected element"), new BindingBeanInfo.Property("selectedElements", "The selected elements")};
        }
    }
}

