/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.binding;

import com.sun.java.util.ObservableList;
import com.sun.java.util.ObservableListListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.beans.binding.Binding;
import javax.beans.binding.ELPropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ListBindingManager
implements ObservableListListener {
    private Binding.BindingController controller;
    private List<?> elements;
    private List<ColumnDescriptionManager> managers;
    private ColumnDescription[] columns;

    public ListBindingManager(Binding.BindingController controller) {
        this.controller = controller;
    }

    protected Binding.BindingController getController() {
        return this.controller;
    }

    public final void refresh() {
        this.setElements(this.getElements());
    }

    protected final ColumnDescription getValueColumnDescription(int column) {
        return this.columns[column];
    }

    private void calculateValueColumns(List<ColumnDescription> columns) {
        int max = -1;
        for (ColumnDescription column : columns) {
            max = Math.max(column.getColumn(), max);
        }
        this.columns = new ColumnDescription[max + 1];
        for (ColumnDescription column : columns) {
            if (!column.isValue()) continue;
            this.columns[((ColumnDescription)column).getColumn()] = column;
        }
    }

    private List<ColumnDescriptionManager> createManagers(List<ColumnDescription> columns) {
        ArrayList<ColumnDescriptionManager> managers = new ArrayList<ColumnDescriptionManager>(columns.size());
        for (ColumnDescription description : columns) {
            managers.add(new ColumnDescriptionManager(description));
        }
        return managers;
    }

    public final void setElements(List<?> elements) {
        boolean addListeners;
        int oldSize = this.size();
        if (this.elements != null) {
            if (this.elements instanceof ObservableList) {
                ((ObservableList)this.elements).removeObservableListListener(this);
            }
            for (ColumnDescriptionManager manager : this.managers) {
                manager.unbind();
            }
        }
        this.managers = null;
        int newSize = 0;
        if (elements == null) {
            elements = Collections.emptyList();
        }
        this.elements = elements;
        LinkedList<ColumnDescription> columns = new LinkedList<ColumnDescription>();
        this.createColumnDescriptions(columns);
        if (columns.size() == 0) {
            columns.add(new ColumnDescription(null, 0, true, Object.class));
        }
        this.calculateValueColumns(columns);
        newSize = this.size();
        if (elements instanceof ObservableList) {
            ((ObservableList)elements).addObservableListListener(this);
            addListeners = !((ObservableList)elements).supportsElementPropertyChanged();
        } else {
            addListeners = true;
        }
        if (addListeners) {
            this.managers = this.createManagers(columns);
            for (ColumnDescriptionManager manager : this.managers) {
                manager.bind(newSize);
            }
        }
        this.allChanged();
    }

    public final Object getElement(int index) {
        return this.elements.get(index);
    }

    public final List<?> getElements() {
        return this.elements;
    }

    public final int size() {
        return this.elements == null ? 0 : this.elements.size();
    }

    public final Object valueAt(int row, int column) {
        return this.valueAt(row, column, false);
    }

    public final Object valueAt(int row, int column, boolean returnElementIfNoBinding) {
        ColumnDescription cd;
        if (this.managers != null) {
            for (ColumnDescriptionManager manager : this.managers) {
                manager.validateBinding(row);
            }
        }
        if ((cd = this.columns[column]) != null) {
            ELPropertyResolver resolver = cd.getPropertyResolver();
            String path = resolver.getPath();
            if (path == null || "".equals(path)) {
                return this.getElement(row);
            }
            resolver.setSource(this.getElement(row));
            return this.controller.getValueForTarget(cd.getBinding(), resolver, cd.getTargetType());
        }
        if (returnElementIfNoBinding) {
            return this.getElement(row);
        }
        return null;
    }

    public final int columnCount() {
        return this.columns.length;
    }

    @Override
    public final void listElementsAdded(ObservableList list, int index, int length) {
        if (this.managers != null) {
            for (ColumnDescriptionManager manager : this.managers) {
                manager.add(index, length);
            }
        }
        this.added(index, length);
    }

    @Override
    public final void listElementsRemoved(ObservableList list, int index, List elements) {
        if (this.managers != null) {
            for (ColumnDescriptionManager manager : this.managers) {
                manager.remove(index, elements.size());
            }
        }
        this.removed(index, elements.size());
    }

    @Override
    public final void listElementReplaced(ObservableList list, int index, Object oldElement) {
        if (this.managers != null) {
            for (ColumnDescriptionManager manager : this.managers) {
                manager.replaced(index);
            }
        }
        this.changed(index);
    }

    @Override
    public final void listElementPropertyChanged(ObservableList list, int index) {
        this.changed(index);
    }

    protected abstract void createColumnDescriptions(List<ColumnDescription> var1);

    protected abstract void allChanged();

    protected abstract void valueChanged(int var1, int var2);

    protected abstract void added(int var1, int var2);

    protected abstract void removed(int var1, int var2);

    protected abstract void changed(int var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ColumnDescription {
        private final Binding binding;
        private final int column;
        private final boolean isValue;
        private final Class<?> targetType;
        private ELPropertyResolver resolver;

        protected ColumnDescription(Binding binding, int column, boolean isValue, Class<?> targetType) {
            this.binding = binding;
            this.column = column;
            this.isValue = isValue;
            this.targetType = targetType;
        }

        public Binding getBinding() {
            return this.binding;
        }

        private int getColumn() {
            return this.column;
        }

        private boolean isValue() {
            return this.isValue;
        }

        private ELPropertyResolver getPropertyResolver() {
            if (this.resolver == null) {
                this.resolver = this.createPropertyResolver();
            }
            return this.resolver;
        }

        private ELPropertyResolver createPropertyResolver() {
            ELPropertyResolver resolver = ListBindingManager.this.getController().createResolver();
            if (this.binding != null) {
                resolver.setPath(this.binding.getSourcePath());
            }
            return resolver;
        }

        public Class<?> getTargetType() {
            return this.targetType;
        }

        public String toString() {
            return "ColumnDescription [ binding=" + this.binding + "," + " column=" + this.column + "," + " isValue=" + this.isValue + " targetType=" + this.targetType + "]";
        }
    }

    private final class ColumnDescriptionManager {
        private final ColumnDescription description;
        private List<EntryWrapper> wrappers;

        ColumnDescriptionManager(ColumnDescription description) {
            this.description = description;
        }

        public void bind(int newSize) {
            this.wrappers = new ArrayList<EntryWrapper>(newSize);
            for (int i = 0; i < newSize; ++i) {
                this.wrappers.add(null);
            }
        }

        public void unbind() {
            if (this.wrappers != null) {
                for (EntryWrapper wrapper : this.wrappers) {
                    if (wrapper == null) continue;
                    wrapper.unbind();
                }
                this.wrappers = null;
            }
        }

        public void validateBinding(int row) {
            if (this.wrappers.get(row) == null) {
                EntryWrapper wrapper = new EntryWrapper(ListBindingManager.this.getElement(row));
                this.wrappers.set(row, wrapper);
            }
        }

        void wrapperChanged(EntryWrapper wrapper) {
            int row = this.wrappers.indexOf(wrapper);
            ListBindingManager.this.valueChanged(row, this.description.getColumn());
        }

        private void add(int index, int length) {
            if (this.wrappers != null) {
                for (int i = 0; i < length; ++i) {
                    this.wrappers.add(index, null);
                }
            }
        }

        private void remove(int index, int length) {
            if (this.wrappers != null) {
                while (length-- > 0) {
                    EntryWrapper wrapper = this.wrappers.remove(index);
                    if (wrapper == null) continue;
                    wrapper.unbind();
                }
            }
        }

        private void replaced(int index) {
            if (this.wrappers != null) {
                EntryWrapper wrapper = this.wrappers.get(index);
                if (wrapper != null) {
                    wrapper.unbind();
                }
                this.wrappers.set(index, null);
            }
        }

        public String toString() {
            return "ColumnDescriptionManager [description=" + this.description + "]";
        }

        private final class EntryWrapper
        extends ELPropertyResolver.Delegate {
            private ELPropertyResolver resolver;

            EntryWrapper(Object source) {
                this.resolver = ColumnDescriptionManager.this.description.createPropertyResolver();
                this.resolver.setSource(source);
                this.resolver.bind();
                this.resolver.setDelegate(this);
            }

            public void unbind() {
                this.resolver.unbind();
            }

            public void valueChanged(ELPropertyResolver resolver) {
                ColumnDescriptionManager.this.wrapperChanged(this);
            }
        }
    }
}

