/*
 * Decompiled with CFR 0.152.
 */
package javax.beans.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.beans.binding.BindingContext;
import javax.beans.binding.BindingConverter;
import javax.beans.binding.BindingListener;
import javax.beans.binding.BindingValidator;
import javax.beans.binding.ELPropertyResolver;
import javax.beans.binding.ListCondenser;
import javax.beans.binding.PropertyPath;
import javax.beans.binding.PropertyResolver;
import javax.beans.binding.PropertyResolverException;
import javax.beans.binding.ValidationResult;
import javax.beans.binding.ext.BindingTarget;
import javax.beans.binding.ext.BindingTargetProvider;
import javax.beans.binding.ext.PropertyDelegateFactory;
import javax.el.ELContext;
import javax.el.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Binding {
    private List<BindingListener> bindingListeners;
    private Map<Parameter<?>, Object> properties;
    private Object source;
    private String sourcePath;
    private Object target;
    private String targetPath;
    private Object tmpSource;
    private Object tmpTarget;
    private String tmpTargetPath;
    private BindingValidator validator;
    private BindingConverter converter;
    private Object nullSourceValue;
    private Object nullTargetValue;
    private Object incompleteSourcePathValue;
    private Object incompleteTargetPathValue;
    private UpdateStrategy updateStrategy;
    private ListCondenser condenser;
    private BindingContext context;
    private boolean bound;
    private ELPropertyResolver sourceResolver;
    private PropertyResolver targetResolver;
    private boolean changingValue;
    private ValueState targetValueState;
    private ValueState sourceValueState;
    private List<Binding> childBindings;
    private boolean keepUncommitted;
    private BindingTarget bindingTarget;
    private BindingTargetProvider bindingProvider;
    private Binding parentBinding;
    private boolean unbindOnCommit;
    private BindingController bindingController;
    private boolean completeTargetPath;
    private Object lastTarget;

    public Binding() {
        this(null, null, new Object[0]);
    }

    public Binding(String sourcePath, String targetPath, Object ... args) {
        this((Object)null, sourcePath, (Object)null, targetPath, args);
    }

    public Binding(Object source, String sourcePath, Object target, String targetPath, Object ... args) {
        this.setUpdateStrategy(UpdateStrategy.READ_WRITE);
        this.setSource(source);
        this.setSourcePath(sourcePath);
        this.setTarget(target);
        this.setTargetPath(targetPath);
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("Args must be of even length");
        }
        for (int i = 0; i < args.length; i += 2) {
            Parameter key = (Parameter)args[i];
            Object value = args[i + 1];
            this.setValue(key, key.getValueClass().cast(value));
        }
    }

    public final void setSource(Object source) {
        this.throwIfBound();
        this.source = source;
    }

    public final Object getSource() {
        return this.source;
    }

    private Object getSource0() {
        return this.tmpSource != null ? this.tmpSource : this.source;
    }

    public final void setSourcePath(String path) {
        this.throwIfBound();
        this.sourcePath = path;
    }

    public final String getSourcePath() {
        return this.sourcePath;
    }

    public final void setTarget(Object target) {
        this.throwIfBound();
        this.target = target;
    }

    public final Object getTarget() {
        return this.target;
    }

    private Object getTarget0() {
        return this.tmpTarget != null ? this.tmpTarget : this.target;
    }

    public final void setTargetPath(String path) {
        this.throwIfBound();
        if (path != null && path.length() == 0) {
            throw new IllegalArgumentException("Target path must be non-empty");
        }
        this.targetPath = path;
    }

    public final String getTargetPath() {
        return this.targetPath;
    }

    private String getTargetPath0() {
        return this.tmpTargetPath != null ? this.tmpTargetPath : this.targetPath;
    }

    public final void setValidator(BindingValidator validator) {
        this.throwIfBound();
        this.validator = validator;
    }

    public final BindingValidator getValidator() {
        return this.validator;
    }

    public final void setConverter(BindingConverter converter) {
        this.throwIfBound();
        this.converter = converter;
    }

    public final BindingConverter getConverter() {
        return this.converter;
    }

    public final void setValueForIncompleteSourcePath(Object value) {
        this.throwIfBound();
        this.incompleteSourcePathValue = value;
    }

    public final Object getValueForIncompleteSourcePath() {
        return this.incompleteSourcePathValue;
    }

    public final void setValueForIncompleteTargetPath(Object value) {
        this.throwIfBound();
        this.incompleteTargetPathValue = value;
    }

    public final Object getValueForIncompleteTargetPath() {
        return this.incompleteTargetPathValue;
    }

    public final void setNullSourceValue(Object value) {
        this.throwIfBound();
        this.nullSourceValue = value;
    }

    public final Object getNullSourceValue() {
        return this.nullSourceValue;
    }

    public final void setNullTargetValue(Object value) {
        this.throwIfBound();
        this.nullTargetValue = value;
    }

    public final Object getNullTargetValue() {
        return this.nullTargetValue;
    }

    public final void setUpdateStrategy(UpdateStrategy strategy) {
        this.throwIfBound();
        if (strategy == null) {
            throw new IllegalArgumentException("UpdateStrategy must be non-null");
        }
        this.updateStrategy = strategy;
    }

    public final UpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    public final void setListCondenser(ListCondenser condenser) {
        this.throwIfBound();
        this.condenser = condenser;
    }

    public final ListCondenser getListCondenser() {
        return this.condenser;
    }

    public final <T> void setValue(Parameter<T> key, T value) {
        this.throwIfBound();
        if (value == null) {
            if (this.properties != null) {
                this.properties.remove(key);
            }
        } else {
            key.getValueClass().cast(value);
            if (this.properties == null) {
                this.properties = new HashMap(1);
            }
            this.properties.put(key, value);
        }
    }

    public final <T> T getValue(Parameter<T> key, T defaultValue) {
        Class<T> valueType = key.getValueClass();
        if (this.properties == null) {
            return defaultValue;
        }
        Object value = this.properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        return valueType.cast(value);
    }

    final void throwIfBound() {
        if (this.isBound()) {
            throw new IllegalStateException("Can not change Binding once bound");
        }
    }

    public BindingConverter getSourceToTargetConverter(Class<?> sourceType, Object sourceValue, Class<?> targetType) {
        BindingConverter converter = this.getConverter();
        if (converter == null) {
            converter = this.getConverter(sourceType, targetType);
        }
        return converter;
    }

    public BindingConverter getTargetToSourceConverter(Class<?> targetType, Object targetValue, Class<?> sourceType) {
        BindingConverter converter = this.getConverter();
        if (converter == null) {
            converter = this.getConverter(sourceType, targetType);
        }
        return converter;
    }

    private final boolean isIntClass(Class<?> type) {
        return type == Integer.TYPE || type == Integer.class;
    }

    private final boolean isBooleanClass(Class<?> type) {
        return type == Boolean.TYPE || type == Boolean.class;
    }

    private BindingConverter getConverter(Class<?> sourceType, Class<?> targetType) {
        if (sourceType == String.class && this.isIntClass(targetType)) {
            return BindingConverter.STRING_TO_INT_CONVERTER;
        }
        if (this.isIntClass(sourceType) && targetType == String.class) {
            return BindingConverter.INT_TO_STRING_CONVERTER;
        }
        if (this.isIntClass(sourceType) && this.isBooleanClass(targetType)) {
            return BindingConverter.INT_TO_BOOLEAN_CONVERTER;
        }
        if (this.isBooleanClass(sourceType) && this.isIntClass(targetType)) {
            return BindingConverter.BOOLEAN_TO_INT_CONVERTER;
        }
        if (this.isIntClass(targetType)) {
            return BindingConverter.OBJECT_TO_INT_CONVERTER;
        }
        return null;
    }

    Binding getParentBinding() {
        return this.parentBinding;
    }

    final void setContext(BindingContext context) {
        this.context = context;
    }

    public final BindingContext getContext() {
        return this.context;
    }

    public final boolean isBound() {
        return this.bound;
    }

    public final void bind() {
        this.throwIfBound();
        if (this.getSource0() == null || this.getTarget0() == null) {
            throw new IllegalStateException("Source and target must be non-null");
        }
        this.completeTargetPath = false;
        this.bound = true;
        BindingContext context = this.getContext();
        if (context != null) {
            context.bindingBecameBound(this);
        }
        this.targetValueState = ValueState.VALID;
        this.sourceResolver = new ELPropertyResolver(this.getELContext(), this.getSource0(), this.getSourcePath());
        this.sourceResolver.bind();
        this.sourceValueState = this.sourceResolver.getEvaluationResultType() == Expression.Result.Type.INCOMPLETE_PATH ? ValueState.INCOMPLETE_PATH : ValueState.VALID;
        this.sourceResolver.setDelegate(new ELPropertyResolverDelegate());
        this.targetResolver = PropertyResolver.createPropertyResolver(this.getTarget0(), this.getTargetPath0());
        this.targetResolver.bind();
        this.targetResolver.setDelegate(new PropertyResolverDelegate());
        this.updateBindingTargetIfNecessary();
        this.setTargetValueFromSourceValue();
    }

    public final void unbind() {
        BindingContext context;
        if (!this.isBound()) {
            throw new IllegalStateException("Binding is not bound");
        }
        this.unbindBindingTarget();
        this.bound = false;
        this.sourceResolver.unbind();
        this.targetResolver.unbind();
        this.sourceResolver = null;
        this.targetResolver = null;
        this.targetValueState = null;
        this.sourceValueState = null;
        if (this.childBindings != null) {
            ArrayList<Binding> childBindings = new ArrayList<Binding>(this.childBindings);
            for (Binding binding : childBindings) {
                if (!binding.isBound()) continue;
                binding.unbind();
            }
        }
        if ((context = this.getContext()) != null) {
            context.bindingBecameUnbound(this);
        }
    }

    public final void setSourceValueFromTargetValue() {
        this.throwIfNotBound();
        this.targetToSource();
    }

    public final void setTargetValueFromSourceValue() {
        this.throwIfNotBound();
        this.sourceToTarget();
    }

    public void addBindingListener(BindingListener listener) {
        if (this.bindingListeners == null) {
            this.bindingListeners = new CopyOnWriteArrayList<BindingListener>();
        }
        this.bindingListeners.add(listener);
    }

    public void removeBindingListener(BindingListener listener) {
        if (this.bindingListeners != null) {
            this.bindingListeners.remove(listener);
        }
    }

    private void updateBindingTargetIfNecessary() {
        boolean completeTargetPath = this.targetResolver.hasAllPathValues();
        Object newTarget = null;
        this.completeTargetPath = completeTargetPath;
        if (completeTargetPath) {
            newTarget = this.targetResolver.getLastSource();
        }
        if (this.lastTarget != newTarget) {
            this.unbindBindingTarget();
            this.bindBindingTarget(newTarget);
        }
    }

    private void sourceChanged() throws PropertyResolverException {
        if (!this.changingValue) {
            if (this.getUpdateStrategy() != UpdateStrategy.READ_ONCE) {
                this.sourceToTarget();
            } else {
                ValueState[] oldState = this.getValueState();
                if (this.sourceResolver.getEvaluationResultType() != Expression.Result.Type.INCOMPLETE_PATH) {
                    this.setSourceValueState(ValueState.UNCOMMITTED);
                } else {
                    this.setSourceValueState(ValueState.INCOMPLETE_PATH);
                }
                this.notifyBindingContextIfNecessary(oldState, null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void targetChanged() throws PropertyResolverException {
        if (this.changingValue) return;
        boolean wasCompleteTargetPath = this.completeTargetPath;
        boolean completeTargetPath = this.targetResolver.hasAllPathValues();
        Object newTarget = null;
        this.completeTargetPath = completeTargetPath;
        if (completeTargetPath) {
            newTarget = this.targetResolver.getLastSource();
        }
        if (this.lastTarget != newTarget) {
            this.unbindBindingTarget();
            this.bindBindingTarget(newTarget);
        }
        if (!wasCompleteTargetPath && completeTargetPath) {
            if (this.getUpdateStrategy() == UpdateStrategy.READ_WRITE) {
                this.sourceToTarget();
                return;
            }
        }
        if (this.getUpdateStrategy() == UpdateStrategy.READ_WRITE) {
            this.targetToSource();
            this.targetEdited();
            return;
        }
        ValueState[] oldState = this.getValueState();
        if (completeTargetPath) {
            this.targetEdited();
            this.setTargetValueState(ValueState.UNCOMMITTED);
        } else {
            this.setTargetValueState(ValueState.INCOMPLETE_PATH);
        }
        this.notifyBindingContextIfNecessary(oldState, null);
        this.unbindIfNecessary();
    }

    private void unbindBindingTarget() {
        if (this.bindingTarget != null) {
            this.bindingTarget.unbind(this.getBindingController(), this.getTargetProperty());
            this.bindingTarget = null;
            this.bindingProvider = null;
            this.lastTarget = null;
        }
    }

    private void bindBindingTarget(Object target) {
        this.lastTarget = target;
        if (this.lastTarget != null) {
            String lastProperty = this.getTargetProperty();
            Object delegate = PropertyDelegateFactory.getPropertyDelegate(this.lastTarget, lastProperty);
            if (delegate != null) {
                if (delegate instanceof BindingTargetProvider) {
                    this.bindingProvider = (BindingTargetProvider)delegate;
                }
            } else if (this.lastTarget instanceof BindingTargetProvider) {
                this.bindingProvider = (BindingTargetProvider)this.lastTarget;
            }
            if (this.bindingProvider != null) {
                this.bindingTarget = this.bindingProvider.createBindingTarget(lastProperty);
                if (this.bindingTarget != null) {
                    this.bindingTarget.bind(this.getBindingController(), lastProperty);
                } else {
                    this.bindingProvider = null;
                }
            }
        }
    }

    private void targetToSource() throws PropertyResolverException {
        ValueState[] state = this.getValueState();
        ValueState sourceState = null;
        ValueState targetState = null;
        RuntimeException conversionException = null;
        ValidationResult validationResult = null;
        if (this.sourceResolver.getEvaluationResultType() != Expression.Result.Type.INCOMPLETE_PATH) {
            Object newValue;
            boolean setValue = true;
            sourceState = this.getSourceValueState();
            if (this.targetResolver.hasAllPathValues()) {
                boolean converted = false;
                newValue = null;
                try {
                    newValue = this.getValueForSource();
                    converted = true;
                }
                catch (ClassCastException cce) {
                    conversionException = cce;
                }
                catch (IllegalArgumentException iae) {
                    conversionException = iae;
                }
                if (!converted) {
                    targetState = ValueState.INVALID;
                    setValue = false;
                } else {
                    validationResult = this.validate(newValue);
                    if (validationResult != null) {
                        setValue = false;
                        switch (validationResult.getType()) {
                            case DO_NOTHING: {
                                targetState = ValueState.INVALID;
                                break;
                            }
                            case SET_TARGET_FROM_SOURCE: {
                                converted = false;
                                newValue = null;
                                try {
                                    newValue = this.getValueForTarget();
                                    converted = true;
                                }
                                catch (ClassCastException cce) {
                                    conversionException = cce;
                                }
                                catch (IllegalArgumentException iae) {
                                    conversionException = iae;
                                }
                                if (converted) {
                                    this.changingValue = true;
                                    newValue = this.coerceValue(this.targetResolver.getTypeOfLastProperty(), newValue);
                                    this.targetResolver.setValueOfLastProperty(newValue);
                                    this.changingValue = false;
                                    targetState = ValueState.VALID;
                                    sourceState = ValueState.VALID;
                                    break;
                                }
                                sourceState = ValueState.INVALID;
                                targetState = ValueState.INVALID;
                            }
                        }
                    } else {
                        sourceState = ValueState.VALID;
                        targetState = ValueState.VALID;
                    }
                }
            } else {
                newValue = this.getValueForIncompleteTargetPath();
                if (newValue == null) {
                    setValue = false;
                } else {
                    sourceState = ValueState.VALID;
                }
                targetState = ValueState.INCOMPLETE_PATH;
            }
            if (setValue) {
                this.changingValue = true;
                this.sourceResolver.setValueOfLastProperty(this.coerceValue(this.sourceResolver.getTypeOfLastProperty(), newValue));
                this.changingValue = false;
            }
        } else {
            sourceState = ValueState.INCOMPLETE_PATH;
            targetState = this.targetResolver.hasAllPathValues() ? ValueState.UNCOMMITTED : ValueState.INCOMPLETE_PATH;
        }
        this.setSourceValueState(sourceState);
        this.setTargetValueState(targetState);
        if (validationResult != null) {
            if (this.bindingListeners != null) {
                for (BindingListener listener : this.bindingListeners) {
                    listener.validationFailed(this, validationResult);
                }
            }
            if (this.context != null) {
                this.context.notifyValidationListeners(this, validationResult);
            }
        }
        this.notifyBindingContextIfNecessary(state, conversionException);
        this.unbindIfNecessary();
    }

    private void sourceToTarget() throws PropertyResolverException {
        ValueState targetState;
        ValueState sourceState;
        ValueState[] state = this.getValueState();
        RuntimeException converterException = null;
        if (this.targetResolver.hasAllPathValues()) {
            this.completeTargetPath = true;
            if (this.sourceResolver.getEvaluationResultType() != Expression.Result.Type.INCOMPLETE_PATH) {
                boolean converted = false;
                Object newValue = null;
                try {
                    newValue = this.getValueForTarget();
                    converted = true;
                }
                catch (ClassCastException cce) {
                    converterException = cce;
                }
                catch (IllegalArgumentException iae) {
                    converterException = iae;
                }
                if (converted) {
                    sourceState = ValueState.VALID;
                    targetState = ValueState.VALID;
                    this.changingValue = true;
                    this.targetResolver.setValueOfLastProperty(this.coerceValue(this.targetResolver.getTypeOfLastProperty(), newValue));
                    this.changingValue = false;
                } else {
                    sourceState = ValueState.INVALID;
                    targetState = this.getTargetValueState();
                }
            } else {
                Object newValue = this.getValueForIncompleteSourcePath();
                if (newValue != null) {
                    this.changingValue = true;
                    this.targetResolver.setValueOfLastProperty(newValue);
                    this.changingValue = false;
                }
                sourceState = ValueState.INCOMPLETE_PATH;
                targetState = ValueState.VALID;
            }
        } else {
            targetState = ValueState.INCOMPLETE_PATH;
            sourceState = this.sourceResolver.getEvaluationResultType() != Expression.Result.Type.INCOMPLETE_PATH ? ValueState.UNCOMMITTED : ValueState.INCOMPLETE_PATH;
            this.completeTargetPath = false;
        }
        this.setTargetValueState(targetState);
        this.setSourceValueState(sourceState);
        this.notifyBindingContextIfNecessary(state, converterException);
        this.unbindIfNecessary();
    }

    private BindingValidator getValidator0() {
        BindingContext context;
        BindingValidator validator = this.getValidator();
        if (validator == null && (context = this.getContext()) != null) {
            validator = context.getValidator(this);
        }
        return validator;
    }

    private ValidationResult validate(Object value) throws PropertyResolverException {
        BindingValidator validator = this.getValidator0();
        if (validator != null) {
            return validator.validate(this, value);
        }
        return null;
    }

    private Object getValueForTarget() throws PropertyResolverException {
        assert (this.sourceResolver.getEvaluationResultType() != Expression.Result.Type.INCOMPLETE_PATH && this.targetResolver.hasAllPathValues());
        return this.getValueForTarget(this.sourceResolver, this.targetResolver.getTypeOfLastProperty());
    }

    private Object getValueForTarget(ELPropertyResolver resolver, Class<?> targetType) throws PropertyResolverException {
        Object value;
        if (!resolver.isBound()) {
            Expression.Result result = resolver.evaluate();
            value = result.getResult();
        } else {
            value = resolver.getValueOfLastProperty();
            if (resolver.getEvaluationResultType() != Expression.Result.Type.SINGLE_VALUE) {
                ListCondenser condenser = this.getListCondenser();
                if (condenser != null) {
                    List values = (List)value;
                    ArrayList<Object> convertedValues = new ArrayList<Object>(values.size());
                    Class<?> sourceType = resolver.getTypeOfLastProperty();
                    for (int i = 0; i < values.size(); ++i) {
                        Object e = values.get(i);
                        if (e == null) {
                            convertedValues.add(this.getNullSourceValue());
                            continue;
                        }
                        BindingConverter converter = this.getSourceToTargetConverter(sourceType, e, targetType);
                        if (converter != null) {
                            e = converter.sourceToTarget(e);
                        }
                        convertedValues.add(e);
                    }
                    value = condenser.condense(convertedValues);
                    return value;
                }
                value = ((List)value).get(0);
            }
        }
        if (value == null) {
            value = this.getNullSourceValue();
        } else {
            BindingConverter converter = this.getSourceToTargetConverter(resolver.getTypeOfLastProperty(), value, targetType);
            if (converter != null) {
                value = converter.sourceToTarget(value);
            }
        }
        return value;
    }

    private Object getValueForSource() throws PropertyResolverException {
        assert (this.sourceResolver.getEvaluationResultType() != Expression.Result.Type.INCOMPLETE_PATH && this.targetResolver.hasAllPathValues());
        Object value = this.targetResolver.getValueOfLastProperty();
        if (value == null) {
            value = this.getNullTargetValue();
        } else {
            BindingConverter converter = this.getTargetToSourceConverter(this.targetResolver.getTypeOfLastProperty(), value, this.sourceResolver.getTypeOfLastProperty());
            if (converter != null) {
                value = converter.targetToSource(value);
            }
        }
        return value;
    }

    private void unbindIfNecessary() {
        if (this.unbindOnCommit && this.targetValueState == ValueState.VALID) {
            this.unbindOnCommit = false;
            this.parentBinding.removeListBinding(this);
        }
    }

    private void setTargetValueState(ValueState state) {
        this.targetValueState = this.adjustTargetValueState(state);
    }

    public final ValueState getTargetValueState() {
        return this.targetValueState;
    }

    private void setSourceValueState(ValueState state) {
        this.sourceValueState = state;
    }

    public final ValueState getSourceValueState() {
        return this.sourceValueState;
    }

    private ValueState[] getValueState() {
        return new ValueState[]{this.getSourceValueState(), this.getTargetValueState()};
    }

    private ValueState adjustTargetValueState(ValueState state) {
        if (this.keepUncommitted && !this.unbindOnCommit && state == ValueState.VALID) {
            return ValueState.UNCOMMITTED;
        }
        return state;
    }

    private void notifyBindingContextIfNecessary(ValueState[] state, Exception conversionException) {
        BindingContext context = this.getContext();
        if (this.isBound() && (state[0] != this.getSourceValueState() || state[1] != this.getTargetValueState())) {
            if (this.bindingTarget != null && state[0] != this.getSourceValueState()) {
                this.bindingTarget.sourceValueStateChanged(this.getBindingController(), this.getTargetProperty());
            }
            if (context != null) {
                context.bindingValueStateChanged(this);
            }
        }
        if (conversionException != null) {
            if (this.bindingListeners != null) {
                for (BindingListener listener : this.bindingListeners) {
                    listener.converterFailed(this, conversionException);
                }
            }
            if (context != null) {
                context.converterFailed(this, conversionException);
            }
        }
    }

    private String getTargetProperty() {
        PropertyPath path = this.targetResolver.getPath();
        return path.get(path.length() - 1);
    }

    public final Binding addBinding(String sourcePath, String targetPath, Object ... args) {
        Binding binding = new Binding(sourcePath, targetPath, args);
        this.addBinding(binding);
        return binding;
    }

    public final void addBinding(Binding binding) {
        this.throwIfBound();
        if (binding.getParentBinding() != null) {
            throw new IllegalArgumentException("Can not add a Binding to two separate Bindings");
        }
        binding.setParentBinding(this);
        ArrayList<Object> childBindings = this.childBindings == null ? new ArrayList(1) : new ArrayList<Binding>(this.childBindings);
        childBindings.add(binding);
        this.childBindings = Collections.unmodifiableList(childBindings);
    }

    public final void removeBinding(Binding binding) {
        this.throwIfBound();
        if (binding.getParentBinding() != this) {
            throw new IllegalArgumentException("Binding is not a child of this Binding");
        }
        binding.setParentBinding(null);
        ArrayList<Binding> bindings = new ArrayList<Binding>(this.childBindings);
        bindings.remove(binding);
        this.childBindings = Collections.unmodifiableList(bindings);
    }

    public final List<Binding> getBindings() {
        if (this.childBindings == null) {
            return Collections.emptyList();
        }
        return this.childBindings;
    }

    private void removeListBinding(Binding binding) throws PropertyResolverException {
        this.throwIfNotBound();
        if (binding.isBound()) {
            binding.unbind();
        }
    }

    private void setParentBinding(Binding parentBinding) {
        this.parentBinding = parentBinding;
    }

    private void unbindChildOnCommit(Binding binding) {
        if (binding.getParentBinding() != this) {
            throw new IllegalArgumentException();
        }
        binding.unbindOnCommit();
    }

    private void unbindOnCommit() {
        this.unbindOnCommit = true;
    }

    private BindingController getBindingController() {
        if (this.bindingController == null) {
            this.bindingController = new BindingController();
        }
        return this.bindingController;
    }

    private void throwIfNotBound() {
        if (!this.bound) {
            throw new IllegalStateException("Must be bound to use this method");
        }
    }

    private void targetEdited() {
        BindingContext context = this.getContext();
        if (context != null) {
            context.targetEdited(this);
        }
    }

    private Object coerceValue(Class<?> type, Object value) {
        if (value == null && type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (type == Byte.TYPE) {
                return (byte)0;
            }
            if (type == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
            if (type == Short.TYPE) {
                return (short)0;
            }
            if (type == Integer.TYPE) {
                return 0;
            }
            if (type == Long.TYPE) {
                return 0L;
            }
            if (type == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (type == Double.TYPE) {
                return 0.0;
            }
        }
        return value;
    }

    private void bindTo(Object source, Object target, String targetPath, boolean keepUncommitted) {
        this.throwIfBound();
        this.tmpSource = source;
        this.tmpTarget = target;
        this.tmpTargetPath = targetPath;
        this.keepUncommitted = keepUncommitted;
        this.bind();
    }

    private ELContext getELContext() {
        BindingContext context = this.getContext();
        if (context != null) {
            return context.getContext();
        }
        return new BindingContext().getContext();
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.paramString() + "]";
    }

    private String paramString() {
        return "source=" + this.getSource() + ", sourcePath=" + this.getSourcePath() + ", target=" + this.getTarget() + ", targetPath=" + this.getTargetPath0() + ", bound=" + this.isBound() + ", validator=" + this.validator + ", converter=" + this.converter + ", valueForIncompleteTargetPath=" + this.incompleteTargetPathValue + ", valueForIncompleteSourcePath=" + this.incompleteSourcePathValue + ", updateStrategy=" + (Object)((Object)this.updateStrategy) + ", sourceValueState=" + (Object)((Object)this.sourceValueState) + ", targetValueState=" + (Object)((Object)this.targetValueState) + ", childBindings=" + this.childBindings + ", keepUncommited=" + this.keepUncommitted + ", properties=" + this.properties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class BindingController {
        private BindingController() {
        }

        public ELPropertyResolver createResolver() {
            return new ELPropertyResolver(Binding.this.getELContext());
        }

        public Object getValueForTarget(Binding binding, ELPropertyResolver resolver, Class<?> targetType) {
            BindingContext.throwIfNull(binding, resolver, targetType);
            return binding.getValueForTarget(resolver, targetType);
        }

        public void valueEdited() {
            Binding.this.throwIfNotBound();
            ValueState[] oldState = Binding.this.getValueState();
            Binding.this.setTargetValueState(ValueState.UNCOMMITTED);
            Binding.this.notifyBindingContextIfNecessary(oldState, null);
            Binding.this.targetEdited();
        }

        public Binding getBinding() {
            return Binding.this;
        }

        public void unbindOnCommit(Binding binding) {
            Binding.this.unbindChildOnCommit(binding);
        }

        public void bind(Binding binding, Object source, Object target, String targetPath, boolean keepUncommited) {
            if (binding.getParentBinding() != Binding.this) {
                throw new IllegalArgumentException();
            }
            binding.bindTo(source, target, targetPath, keepUncommited);
        }
    }

    private final class ELPropertyResolverDelegate
    extends ELPropertyResolver.Delegate {
        private ELPropertyResolverDelegate() {
        }

        public void valueChanged(ELPropertyResolver resolver) {
            Binding.this.sourceChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Parameter<T> {
        private final Class<T> valueClass;
        private final String description;

        public Parameter(Class<T> valueClass, String description) {
            if (valueClass == null || description == null) {
                throw new IllegalArgumentException("Value class and description must be non-null");
            }
            this.valueClass = valueClass;
            this.description = description;
        }

        public final Class<T> getValueClass() {
            return this.valueClass;
        }

        public final String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.getClass() + " [" + " description=" + this.description + ", " + " valueClass=" + this.getValueClass() + "]";
        }
    }

    private final class PropertyResolverDelegate
    extends PropertyResolver.Delegate {
        private PropertyResolverDelegate() {
        }

        public void valueChanged(PropertyResolver resolver) {
            Binding.this.targetChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateStrategy {
        READ_FROM_SOURCE,
        READ_ONCE,
        READ_WRITE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValueState {
        INCOMPLETE_PATH,
        UNCOMMITTED,
        INVALID,
        VALID;

    }
}

