/*
 * Decompiled with CFR 0.152.
 */
package javax.beans.binding;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListCondenser {
    public static ListCondenser concatenatingCondenser(String leading, String trailing, String separator) {
        return new UnioningCondenser(leading, trailing, separator);
    }

    public abstract Object condense(List<?> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnioningCondenser
    extends ListCondenser {
        private final String leading;
        private final String trailing;
        private final String separator;

        public UnioningCondenser() {
            this("\"", "\"", ", ");
        }

        public UnioningCondenser(String leading, String trailing, String separator) {
            if (leading == null) {
                leading = "";
            }
            if (trailing == null) {
                trailing = "";
            }
            if (separator == null) {
                separator = "";
            }
            this.leading = leading;
            this.trailing = trailing;
            this.separator = separator;
        }

        @Override
        public Object condense(List<?> elements) {
            StringBuilder builder = new StringBuilder(this.leading);
            Object e = elements.get(0);
            if (e != null) {
                builder.append(e.toString());
            }
            builder.append(this.trailing);
            for (int i = 1; i < elements.size(); ++i) {
                builder.append(this.separator);
                builder.append(this.leading);
                e = elements.get(i);
                if (e != null) {
                    builder.append(e.toString());
                }
                builder.append(this.trailing);
            }
            return builder.toString();
        }
    }
}

