/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.netbeans.spi.options.OptionsCategory;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CategoryModel
implements LookupListener {
    private static Reference<CategoryModel> INSTANCE = new WeakReference<CategoryModel>(new CategoryModel());
    private final RequestProcessor RP = new RequestProcessor();
    private static String currentCategoryID = null;
    private String highlitedCategoryID = null;
    private boolean categoriesValid = true;
    private final Map<String, Category> id2Category = Collections.synchronizedMap(new LinkedHashMap());
    private MasterLookup masterLookup;
    private final RequestProcessor.Task masterLookupTask = this.RP.create(new Runnable(){

        public void run() {
            String[] categoryIDs = CategoryModel.this.getCategoryIDs();
            ArrayList<Lookup> all = new ArrayList<Lookup>();
            for (int i = 0; i < categoryIDs.length; ++i) {
                Category item = CategoryModel.this.getCategory(categoryIDs[i]);
                Lookup lkp = item.getLookup();
                assert (lkp != null);
                if (lkp == Lookup.EMPTY) continue;
                all.add(lkp);
            }
            CategoryModel.this.getMasterLookup().setLookups(all);
        }
    }, true);
    private final RequestProcessor.Task categoryTask = this.RP.create(new Runnable(){

        public void run() {
            Map all = CategoryModel.this.loadOptionsCategories();
            LinkedHashMap<String, Category> temp = new LinkedHashMap<String, Category>();
            for (Map.Entry entry : all.entrySet()) {
                OptionsCategory oc = (OptionsCategory)entry.getValue();
                String id = (String)entry.getKey();
                Category cat = new Category(id, oc);
                temp.put(cat.getID(), cat);
            }
            CategoryModel.this.id2Category.clear();
            CategoryModel.this.id2Category.putAll(temp);
            CategoryModel.this.masterLookupTask.schedule(0);
        }
    }, true);

    private CategoryModel() {
        this.categoryTask.schedule(0);
    }

    public static CategoryModel getInstance() {
        CategoryModel retval = INSTANCE.get();
        if (retval == null) {
            retval = new CategoryModel();
            INSTANCE = new WeakReference<CategoryModel>(retval);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean needsReinit() {
        Class<CategoryModel> clazz = CategoryModel.class;
        synchronized (CategoryModel.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return !this.categoriesValid;
        }
    }

    boolean isInitialized() {
        return this.categoryTask.isFinished();
    }

    boolean isLookupInitialized() {
        return this.masterLookupTask.isFinished();
    }

    void waitForInitialization() {
        this.categoryTask.waitFinished();
    }

    public String getCurrentCategoryID() {
        return this.verifyCategoryID(currentCategoryID);
    }

    public void setCurrentCategoryID(String categoryID) {
        currentCategoryID = this.verifyCategoryID(categoryID);
    }

    String getHighlitedCategoryID() {
        return this.verifyCategoryID(this.highlitedCategoryID);
    }

    private String verifyCategoryID(String categoryID) {
        String[] categoryIDs;
        String retval;
        String string = retval = this.findCurrentCategoryID(categoryID) != -1 ? categoryID : null;
        if (retval == null && (categoryIDs = this.getCategoryIDs()).length > 0) {
            retval = categoryID = categoryIDs[0];
        }
        return retval;
    }

    private int findCurrentCategoryID(String categoryID) {
        return categoryID == null ? -1 : Arrays.asList(this.getCategoryIDs()).indexOf(categoryID);
    }

    public String[] getCategoryIDs() {
        this.categoryTask.waitFinished();
        Set<String> keys = this.id2Category.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    Category getCurrent() {
        String categoryID = this.getCurrentCategoryID();
        return categoryID == null ? null : this.getCategory(categoryID);
    }

    void setCurrent(Category item) {
        item.setCurrent();
    }

    void setHighlited(Category item) {
        item.setHighlited();
    }

    HelpCtx getHelpCtx() {
        Category category = this.getCurrent();
        return category == null ? null : category.getHelpCtx();
    }

    void update(PropertyChangeListener l, boolean force) {
        String[] categoryIDs = this.getCategoryIDs();
        for (int i = 0; i < categoryIDs.length; ++i) {
            Category item = this.getCategory(categoryIDs[i]);
            item.update(l, force);
        }
    }

    void save() {
        String[] categoryIDs = this.getCategoryIDs();
        for (int i = 0; i < categoryIDs.length; ++i) {
            Category item = this.getCategory(categoryIDs[i]);
            item.applyChanges();
        }
    }

    void cancel() {
        String[] categoryIDs = this.getCategoryIDs();
        for (int i = 0; i < categoryIDs.length; ++i) {
            Category item = this.getCategory(categoryIDs[i]);
            item.cancel();
        }
    }

    boolean dataValid() {
        boolean retval = true;
        String[] categoryIDs = this.getCategoryIDs();
        for (int i = 0; retval && i < categoryIDs.length; ++i) {
            Category item = this.getCategory(categoryIDs[i]);
            retval = item.isValid();
        }
        return retval;
    }

    boolean isChanged() {
        boolean retval = false;
        String[] categoryIDs = this.getCategoryIDs();
        for (int i = 0; !retval && i < categoryIDs.length; ++i) {
            Category item = this.getCategory(categoryIDs[i]);
            retval = item.isChanged();
        }
        return retval;
    }

    void setNextCategoryAsCurrent() {
        int idx = this.findCurrentCategoryID(this.getCurrentCategoryID());
        String[] categoryIDs = this.getCategoryIDs();
        currentCategoryID = idx >= 0 && idx + 1 < categoryIDs.length ? categoryIDs[idx + 1] : null;
    }

    void setPreviousCategoryAsCurrent() {
        int idx = this.findCurrentCategoryID(this.getCurrentCategoryID());
        String[] categoryIDs = this.getCategoryIDs();
        currentCategoryID = idx >= 0 && idx < categoryIDs.length && categoryIDs.length > 0 ? (idx - 1 >= 0 ? categoryIDs[idx - 1] : categoryIDs[categoryIDs.length - 1]) : null;
    }

    Category getCategory(String categoryID) {
        this.categoryTask.waitFinished();
        return this.id2Category.get(categoryID);
    }

    private MasterLookup getMasterLookup() {
        if (this.masterLookup == null) {
            this.masterLookup = new MasterLookup();
        }
        return this.masterLookup;
    }

    private Map<String, OptionsCategory> loadOptionsCategories() {
        Lookup lookup = Lookups.forPath((String)"OptionsDialog");
        Lookup.Result result = lookup.lookup(new Lookup.Template(OptionsCategory.class));
        result.addLookupListener((LookupListener)this);
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Lookup.Item item : result.allItems()) {
            m.put(item.getId().substring("OptionsDialog".length() + 1), item.getInstance());
        }
        return Collections.unmodifiableMap(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultChanged(LookupEvent ev) {
        Class<CategoryModel> clazz = CategoryModel.class;
        synchronized (CategoryModel.class) {
            this.categoriesValid = false;
            INSTANCE = new WeakReference<CategoryModel>(new CategoryModel());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    final class Category {
        private OptionsCategory category;
        private OptionsPanelController controller;
        private boolean isUpdated;
        private HelpCtx helpCtx;
        private JComponent component;
        private Lookup lookup;
        private final String id;

        private Category(String id, OptionsCategory category) {
            this.category = category;
            this.id = id;
        }

        boolean isCurrent() {
            return this.getID().equals(CategoryModel.this.getCurrentCategoryID());
        }

        boolean isHighlited() {
            return this.getID().equals(CategoryModel.this.getHighlitedCategoryID());
        }

        private void setCurrent() {
            CategoryModel.this.setCurrentCategoryID(this.getID());
        }

        private void setHighlited() {
            CategoryModel.this.highlitedCategoryID = this.getID();
        }

        public Icon getIcon() {
            return this.category.getIcon();
        }

        public String getID() {
            return this.id;
        }

        public String getCategoryName() {
            return this.category.getCategoryName();
        }

        public String getTitle() {
            return this.category.getTitle();
        }

        private synchronized OptionsPanelController create() {
            if (this.controller == null) {
                this.controller = this.category.create();
            }
            return this.controller;
        }

        final void update(PropertyChangeListener l, boolean forceUpdate) {
            if (!this.isUpdated && !forceUpdate || this.isUpdated && forceUpdate) {
                this.isUpdated = true;
                this.getComponent();
                this.create().update();
                if (l != null) {
                    this.create().addPropertyChangeListener(l);
                }
            }
        }

        private void applyChanges() {
            if (this.isUpdated) {
                this.create().applyChanges();
            }
        }

        private void cancel() {
            if (this.isUpdated) {
                this.create().cancel();
            }
        }

        private boolean isValid() {
            boolean retval = true;
            if (this.isUpdated) {
                retval = this.create().isValid();
            }
            return retval;
        }

        private boolean isChanged() {
            boolean retval = false;
            if (this.isUpdated) {
                retval = this.create().isChanged();
            }
            return retval;
        }

        public JComponent getComponent() {
            if (this.component == null) {
                this.component = this.create().getComponent((Lookup)CategoryModel.this.getMasterLookup());
            }
            return this.component;
        }

        private HelpCtx getHelpCtx() {
            if (this.helpCtx == null && this.isUpdated) {
                this.helpCtx = this.create().getHelpCtx();
            }
            return this.helpCtx;
        }

        private Lookup getLookup() {
            if (this.lookup == null) {
                this.lookup = this.create().getLookup();
            }
            return this.lookup;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MasterLookup
    extends ProxyLookup {
        private MasterLookup() {
        }

        private void setLookups(List<Lookup> lookups) {
            this.setLookups(lookups.toArray(new Lookup[lookups.size()]));
        }

        protected void beforeLookup(Lookup.Template template) {
            super.beforeLookup(template);
            CategoryModel.this.masterLookupTask.waitFinished();
        }
    }
}

