/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.options.OptionsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;

public class OptionsDisplayerImpl {
    private static Dialog dialog;
    private static WeakReference<DialogDescriptor> descriptorRef;
    private static String title;
    private static Logger log;
    private boolean modal;

    public OptionsDisplayerImpl(boolean modal) {
        this.modal = modal;
    }

    public boolean isOpen() {
        return dialog != null;
    }

    public void showOptionsDialog(String categoryID) {
        if (this.isOpen()) {
            dialog.setVisible(true);
            dialog.toFront();
            log.fine("Front Options Dialog");
            return;
        }
        DialogDescriptor descriptor = (DialogDescriptor)descriptorRef.get();
        OptionsPanel optionsPanel = null;
        if (descriptor == null) {
            optionsPanel = categoryID == null ? new OptionsPanel() : new OptionsPanel(categoryID);
            JButton bOK = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_OK");
            JButton bClassic = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_Classic");
            boolean isMac = Utilities.isMac();
            Object[] options = new Object[]{isMac ? DialogDescriptor.CANCEL_OPTION : bOK, isMac ? bOK : DialogDescriptor.CANCEL_OPTION};
            descriptor = new DialogDescriptor((Object)optionsPanel, title, this.modal, options, DialogDescriptor.OK_OPTION, 0, null, null);
            descriptor.setAdditionalOptions(new Object[]{bClassic});
            descriptor.setHelpCtx(optionsPanel.getHelpCtx());
            OptionsPanelListener listener = new OptionsPanelListener(descriptor, optionsPanel, bOK, bClassic);
            descriptor.setButtonListener((ActionListener)listener);
            optionsPanel.addPropertyChangeListener(listener);
            descriptorRef = new WeakReference<DialogDescriptor>(descriptor);
            log.fine("Create new Options Dialog");
        } else {
            optionsPanel = (OptionsPanel)descriptor.getMessage();
            optionsPanel.update();
            log.fine("Reopen Options Dialog");
        }
        dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        optionsPanel.initCurrentCategory(categoryID);
        dialog.addWindowListener(new MyWindowListener(optionsPanel));
        dialog.setVisible(true);
    }

    private static String loc(String key) {
        return NbBundle.getMessage(OptionsDisplayerImpl.class, (String)key);
    }

    private static Component loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)OptionsDisplayerImpl.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)OptionsDisplayerImpl.loc(key));
        }
        return c;
    }

    static {
        descriptorRef = new WeakReference<Object>(null);
        title = OptionsDisplayerImpl.loc("CTL_Options_Dialog_Title");
        log = Logger.getLogger(OptionsDisplayerImpl.class.getName());
    }

    private class MyWindowListener
    implements WindowListener {
        private OptionsPanel optionsPanel;
        private Dialog originalDialog;

        MyWindowListener(OptionsPanel optionsPanel) {
            this.optionsPanel = optionsPanel;
            this.originalDialog = dialog;
        }

        public void windowClosing(WindowEvent e) {
            if (dialog == null) {
                return;
            }
            log.fine("Options Dialog - windowClosing ");
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    MyWindowListener.this.optionsPanel.cancel();
                }
            });
            if (this.originalDialog == dialog) {
                dialog = null;
            }
        }

        public void windowClosed(WindowEvent e) {
            this.optionsPanel.storeUserSize();
            if (this.optionsPanel.needsReinit()) {
                descriptorRef = new WeakReference<Object>(null);
            }
            if (this.originalDialog == dialog) {
                dialog = null;
            }
            log.fine("Options Dialog - windowClosed");
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }
    }

    class OpenOptionsListener
    implements ActionListener {
        OpenOptionsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            log.fine("Options Dialog - Back to modern.");
                            OptionsDisplayer.getDefault().open();
                        }
                    });
                }
            });
        }
    }

    private class OptionsPanelListener
    implements PropertyChangeListener,
    ActionListener {
        private DialogDescriptor descriptor;
        private OptionsPanel optionsPanel;
        private JButton bOK;
        private JButton bClassic;

        OptionsPanelListener(DialogDescriptor descriptor, OptionsPanel optionsPanel, JButton bOK, JButton bClassic) {
            this.descriptor = descriptor;
            this.optionsPanel = optionsPanel;
            this.bOK = bOK;
            this.bClassic = bClassic;
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (ev.getPropertyName().equals("buranhelpCtx")) {
                this.descriptor.setHelpCtx(this.optionsPanel.getHelpCtx());
            } else if (ev.getPropertyName().equals("buranvalid")) {
                this.bOK.setEnabled(this.optionsPanel.dataValid());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent e) {
            if (!OptionsDisplayerImpl.this.isOpen()) {
                return;
            }
            if (e.getSource() == this.bOK) {
                log.fine("Options Dialog - Ok pressed.");
                Dialog d = dialog;
                dialog = null;
                d.dispose();
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        OptionsPanelListener.this.optionsPanel.save();
                    }
                });
                return;
            }
            if (e.getSource() == DialogDescriptor.CANCEL_OPTION || e.getSource() == DialogDescriptor.CLOSED_OPTION) {
                log.fine("Options Dialog - Cancel pressed.");
                Dialog d = dialog;
                dialog = null;
                d.dispose();
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        OptionsPanelListener.this.optionsPanel.cancel();
                    }
                });
                return;
            }
            if (e.getSource() != this.bClassic) return;
            log.fine("Options Dialog - Classic pressed.");
            Dialog d = dialog;
            dialog = null;
            if (this.optionsPanel.isChanged()) {
                NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)OptionsDisplayerImpl.loc("CTL_Some_values_changed"), 1, 3);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                if (result == NotifyDescriptor.YES_OPTION) {
                    d.dispose();
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            OptionsPanelListener.this.optionsPanel.save();
                        }
                    });
                } else {
                    if (result != NotifyDescriptor.NO_OPTION) {
                        dialog = d;
                        return;
                    }
                    d.dispose();
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            OptionsPanelListener.this.optionsPanel.cancel();
                        }
                    });
                }
            } else {
                d.dispose();
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        OptionsPanelListener.this.optionsPanel.cancel();
                    }
                });
            }
            try {
                ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                Class<?> clz = cl.loadClass("org.netbeans.core.actions.OptionsAction");
                CallableSystemAction a = (CallableSystemAction)SystemAction.findObject(clz, (boolean)true);
                a.putValue("additionalActionName", (Object)OptionsDisplayerImpl.loc("CTL_Modern"));
                a.putValue("optionsDialogTitle", (Object)OptionsDisplayerImpl.loc("CTL_Classic_Title"));
                a.putValue("additionalActionListener", (Object)new OpenOptionsListener());
                a.performAction();
                return;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

