/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.modules.options.CategoryModel;
import org.netbeans.modules.options.ui.LoweredBorder;
import org.netbeans.modules.options.ui.VariableBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class OptionsPanel
extends JPanel {
    private CategoryModel model = CategoryModel.getInstance();
    private JPanel pCategories;
    private JPanel pCategories2;
    private JPanel pOptions;
    private JLabel lTitle;
    private JPanel pTitle;
    private Map<String, CategoryButton> buttons = new LinkedHashMap<String, CategoryButton>();
    private final boolean isMac = UIManager.getLookAndFeel().getID().equals("Aqua");
    private Color selected = this.isMac ? new Color(221, 221, 221) : new Color(193, 210, 238);
    private Color selectedB = this.isMac ? new Color(183, 183, 183) : new Color(149, 106, 197);
    private Color highlighted = this.isMac ? new Color(221, 221, 221) : new Color(224, 232, 246);
    private Color highlightedB = new Color(152, 180, 226);
    private Color iconViewBorder = new Color(127, 157, 185);
    private ControllerListener coltrollerListener = new ControllerListener();
    private final Color borderMac = new Color(141, 141, 141);
    private final Font labelFontMac = new Font("Lucida Grande", 0, 10);

    private static String loc(String key) {
        return NbBundle.getMessage(OptionsPanel.class, (String)key);
    }

    public OptionsPanel() {
        this((String)null);
    }

    public OptionsPanel(String categoryID) {
        this.initUI(categoryID);
    }

    private String getCategoryID(String categoryID) {
        return categoryID == null ? this.model.getCurrentCategoryID() : categoryID;
    }

    void initCurrentCategory(final String categoryID) {
        boolean isGeneralPanel = "General".equals(this.getCategoryID(categoryID));
        if (this.model.isLookupInitialized() || isGeneralPanel) {
            this.setCurrentCategory(this.model.getCategory(this.getCategoryID(categoryID)), false);
            this.initActions();
        } else {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Frame frame = WindowManager.getDefault().getMainWindow();
                            Cursor cursor = frame.getCursor();
                            frame.setCursor(Cursor.getPredefinedCursor(3));
                            OptionsPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                            OptionsPanel.this.setCurrentCategory(OptionsPanel.this.model.getCategory(OptionsPanel.this.getCategoryID(categoryID)), true);
                            OptionsPanel.this.initActions();
                            frame.setCursor(cursor);
                            OptionsPanel.this.setCursor(cursor);
                        }
                    });
                }
            }, 500);
        }
    }

    private void setCurrentCategory(CategoryModel.Category category, final boolean repaintAllowed) {
        CategoryModel.Category oldCategory = this.model.getCurrent();
        if (oldCategory != null) {
            this.buttons.get(oldCategory.getID()).setNormal();
        }
        if (category != null) {
            this.buttons.get(category.getID()).setSelected();
        }
        this.model.setCurrent(category);
        this.pOptions.removeAll();
        JComponent component = category.getComponent();
        category.update(this.coltrollerListener, false);
        final Dimension size = component.getSize();
        this.pOptions.add("Center", component);
        Icon icon = category.getIcon();
        if (icon != null) {
            this.lTitle.setIcon(icon);
        }
        this.lTitle.setText(category.getTitle());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!OptionsPanel.this.checkSize(size) && repaintAllowed) {
                    OptionsPanel.this.revalidate();
                    OptionsPanel.this.repaint();
                }
                if (OptionsPanel.this.model.getCurrent() != null) {
                    ((CategoryButton)OptionsPanel.this.buttons.get(OptionsPanel.this.model.getCurrentCategoryID())).requestFocus();
                }
            }
        });
        this.firePropertyChange("buranhelpCtx", null, null);
    }

    HelpCtx getHelpCtx() {
        return this.model.getHelpCtx();
    }

    void update() {
        this.model.update(this.coltrollerListener, true);
    }

    void save() {
        this.model.save();
    }

    void cancel() {
        this.model.cancel();
    }

    boolean dataValid() {
        return this.model.dataValid();
    }

    boolean isChanged() {
        return this.model.isChanged();
    }

    boolean needsReinit() {
        return this.model.needsReinit();
    }

    private void initUI(String categoryName) {
        this.pOptions = new JPanel();
        this.pOptions.setLayout(new BorderLayout());
        this.pOptions.setPreferredSize(this.getUserSize());
        JLabel label = new JLabel(OptionsPanel.loc("CTL_Loading_Options"));
        label.setHorizontalAlignment(0);
        this.pOptions.add("Center", label);
        JPanel pTitle = new JPanel(new BorderLayout());
        this.lTitle = new JLabel();
        if (Utilities.isWindows()) {
            this.lTitle.setBackground(SystemColor.activeCaption);
            this.lTitle.setForeground(SystemColor.activeCaptionText);
        } else {
            this.lTitle.setBackground(Color.white);
            this.lTitle.setForeground(Color.black);
        }
        Font f = this.lTitle.getFont();
        this.lTitle.setFont(new Font(f.getName(), 1, 16));
        this.lTitle.setIconTextGap(8);
        this.lTitle.setOpaque(true);
        if (Utilities.isWindows()) {
            pTitle.setBorder(new CompoundBorder(new LoweredBorder(), new LineBorder(SystemColor.activeCaption, 1)));
        } else {
            pTitle.setBorder(new CompoundBorder(new LineBorder(this.iconViewBorder, 1), new LineBorder(Color.white, 2)));
        }
        pTitle.add("Center", this.lTitle);
        this.pCategories2 = new JPanel(new GridBagLayout());
        this.pCategories2.setBackground(Color.white);
        this.pCategories2.setBorder(null);
        this.addCategoryButtons();
        this.pCategories = new JPanel(new BorderLayout());
        if (this.isMac) {
            this.pCategories.setBorder(new CompoundBorder(new VariableBorder(null, null, this.borderMac, null), BorderFactory.createEmptyBorder(0, 4, 0, 4)));
        } else {
            this.pCategories.setBorder(new LineBorder(this.iconViewBorder));
        }
        this.pCategories.setBackground(Color.white);
        this.pCategories.add("North", this.pCategories2);
        this.setLayout(new BorderLayout(10, 10));
        if (this.isMac) {
            this.pOptions.setBorder(new CompoundBorder(new VariableBorder(null, null, this.borderMac, null), BorderFactory.createEmptyBorder(0, 20, 5, 20)));
            this.add((Component)this.pCategories, "North");
            this.add((Component)this.pOptions, "Center");
        } else {
            JPanel centralPanel = new JPanel(new BorderLayout(10, 10));
            centralPanel.add((Component)pTitle, "North");
            centralPanel.add((Component)this.pOptions, "Center");
            this.add((Component)this.pCategories, "West");
            this.add((Component)centralPanel, "Center");
            this.setBorder(new EmptyBorder(10, 10, 0, 10));
        }
        categoryName = this.getCategoryID(categoryName);
        if (categoryName != null) {
            CategoryModel.Category c = this.model.getCategory(this.getCategoryID(categoryName));
            Icon icon = c.getIcon();
            if (icon != null) {
                this.lTitle.setIcon(icon);
            }
            this.lTitle.setText(c.getTitle());
            CategoryButton b = this.buttons.get(categoryName);
            if (b != null) {
                b.setSelected();
            }
        }
    }

    private void initActions() {
        if (this.getActionMap().get("UP") == null) {
            InputMap inputMap = this.getInputMap(2);
            inputMap.put(this.isMac ? KeyStroke.getKeyStroke(37, 0) : KeyStroke.getKeyStroke(38, 0), "UP");
            this.getActionMap().put("UP", new UpAction());
            inputMap.put(KeyStroke.getKeyStroke(32, 0), "SPACE");
            this.getActionMap().put("SPACE", new SelectCurrentAction());
            inputMap.put(this.isMac ? KeyStroke.getKeyStroke(39, 0) : KeyStroke.getKeyStroke(40, 0), "DOWN");
            this.getActionMap().put("DOWN", new DownAction());
        }
    }

    private void addCategoryButtons() {
        Iterator<CategoryButton> it = this.buttons.values().iterator();
        while (it.hasNext()) {
            this.removeButton(it.next());
        }
        this.pCategories2.removeAll();
        this.buttons = new LinkedHashMap<String, CategoryButton>();
        String[] names = this.model.getCategoryIDs();
        for (int i = 0; i < names.length; ++i) {
            CategoryModel.Category category = this.model.getCategory(names[i]);
            this.addButton(category);
        }
        this.addFakeButton();
    }

    private void addButton(CategoryModel.Category category) {
        int index = this.buttons.size();
        CategoryButton button = new CategoryButton(category);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(button.getDisplayedMnemonic(), 8);
        this.getInputMap(2).put(keyStroke, button);
        this.getActionMap().put(button, new SelectAction(category));
        if (this.isMac) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 3;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            gbc.gridx = index;
            gbc.gridy = 0;
            this.pCategories2.add((Component)button, gbc);
        } else {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.gridx = 0;
            gbc.gridy = index;
            this.pCategories2.add((Component)button, gbc);
        }
        this.buttons.put(category.getID(), button);
    }

    private void removeButton(CategoryButton button) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(button.getDisplayedMnemonic(), 8);
        this.getInputMap(2).remove(keyStroke);
        this.getActionMap().remove(button);
    }

    private void addFakeButton() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        if (this.isMac) {
            gbc.gridy = 0;
        } else {
            gbc.gridx = 0;
        }
        this.pCategories2.add((Component)new JLabel(""), gbc);
    }

    private Dimension getInitSize() {
        return new Dimension(750, 500);
    }

    Dimension getUserSize() {
        int w = NbPreferences.forModule(OptionsPanel.class).getInt("OptionsWidth", this.getInitSize().width);
        int h = NbPreferences.forModule(OptionsPanel.class).getInt("OptionsHeight", this.getInitSize().height);
        return new Dimension(w, h);
    }

    void storeUserSize() {
        Dimension d = this.pOptions.getSize();
        NbPreferences.forModule(OptionsPanel.class).putInt("OptionsWidth", d.width);
        NbPreferences.forModule(OptionsPanel.class).putInt("OptionsHeight", d.height);
        this.pOptions.setPreferredSize(d);
    }

    private boolean checkSize(Dimension componentSize) {
        boolean retval = false;
        Dimension prefSize = this.pOptions.getPreferredSize();
        Dimension userSize = this.getUserSize();
        componentSize = new Dimension(Math.max(componentSize.width, userSize.width), Math.max(componentSize.height, userSize.height));
        if (prefSize.width < componentSize.width || prefSize.height < componentSize.height) {
            Dimension newSize = new Dimension(Math.max(prefSize.width, componentSize.width), Math.max(prefSize.height, componentSize.height));
            this.pOptions.setPreferredSize(newSize);
            Window w = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
            this.invalidate();
            if (w != null) {
                w.pack();
            }
            retval = true;
        }
        return retval;
    }

    class CategoryButton
    extends JLabel
    implements MouseListener {
        private final CategoryModel.Category category;

        CategoryButton(final CategoryModel.Category category) {
            super(category.getIcon());
            this.category = category;
            Mnemonics.setLocalizedText((JLabel)this, (String)category.getCategoryName());
            this.setOpaque(true);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setHorizontalAlignment(0);
            this.addMouseListener(this);
            this.setFocusable(true);
            this.setFocusTraversalKeysEnabled(true);
            this.setForeground(Color.black);
            if (OptionsPanel.this.isMac) {
                this.setFont(OptionsPanel.this.labelFontMac);
                this.setIconTextGap(2);
            }
            this.setNormal();
            this.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    if (OptionsPanel.this.model.getCurrent() != null && !category.isCurrent()) {
                        CategoryButton.this.setHighlighted();
                    }
                }

                public void focusLost(FocusEvent e) {
                    if (OptionsPanel.this.model.getCurrent() != null && !category.isCurrent() && !OptionsPanel.this.isMac) {
                        CategoryButton.this.setNormal();
                    }
                }
            });
        }

        void setNormal() {
            if (OptionsPanel.this.isMac) {
                this.setBorder(new EmptyBorder(5, 6, 3, 6));
            } else {
                this.setBorder(new EmptyBorder(2, 4, 2, 4));
            }
            this.setBackground(Color.white);
        }

        void setSelected() {
            if (OptionsPanel.this.isMac) {
                this.setBorder(new CompoundBorder(new VariableBorder(null, OptionsPanel.this.selectedB, null, OptionsPanel.this.selectedB), BorderFactory.createEmptyBorder(5, 5, 3, 5)));
            } else {
                this.setBorder(new CompoundBorder(new CompoundBorder(new LineBorder(Color.white), new LineBorder(OptionsPanel.this.selectedB)), new EmptyBorder(0, 2, 0, 2)));
            }
            this.setBackground(OptionsPanel.this.selected);
        }

        void setHighlighted() {
            if (!OptionsPanel.this.isMac) {
                this.setBorder(new CompoundBorder(new CompoundBorder(new LineBorder(Color.white), new LineBorder(OptionsPanel.this.highlightedB)), new EmptyBorder(0, 2, 0, 2)));
                this.setBackground(OptionsPanel.this.highlighted);
            }
            if (!this.category.isHighlited()) {
                CategoryButton b;
                if (OptionsPanel.this.model.getHighlitedCategoryID() != null && (b = (CategoryButton)OptionsPanel.this.buttons.get(OptionsPanel.this.model.getHighlitedCategoryID())) != null && !b.category.isCurrent()) {
                    b.setNormal();
                }
                OptionsPanel.this.model.setHighlited(this.category);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (!OptionsPanel.this.isMac && OptionsPanel.this.model.getCurrent() != null) {
                this.setSelected();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (!this.category.isCurrent() && this.category.isHighlited() && OptionsPanel.this.model.getCurrent() != null) {
                OptionsPanel.this.setCurrentCategory(this.category, true);
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (!this.category.isCurrent() && OptionsPanel.this.model.getCurrent() != null) {
                this.setHighlighted();
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!this.category.isCurrent() && !OptionsPanel.this.isMac && OptionsPanel.this.model.getCurrent() != null) {
                this.setNormal();
            }
        }
    }

    class ControllerListener
    implements PropertyChangeListener {
        ControllerListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            OptionsPanel.this.firePropertyChange("buran" + evt.getPropertyName(), null, null);
        }
    }

    private class DownAction
    extends AbstractAction {
        private DownAction() {
        }

        public void actionPerformed(ActionEvent e) {
            OptionsPanel.this.model.setNextCategoryAsCurrent();
            OptionsPanel.this.setCurrentCategory(OptionsPanel.this.model.getCurrent(), true);
        }
    }

    private class SelectAction
    extends AbstractAction {
        private CategoryModel.Category category;

        SelectAction(CategoryModel.Category category) {
            this.category = category;
        }

        public void actionPerformed(ActionEvent e) {
            OptionsPanel.this.setCurrentCategory(this.category, true);
        }
    }

    private class SelectCurrentAction
    extends AbstractAction {
        private SelectCurrentAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Component c = FocusManager.getCurrentManager().getFocusOwner();
            if (c instanceof CategoryButton) {
                OptionsPanel.this.setCurrentCategory(((CategoryButton)c).category, true);
                ((CategoryButton)c).setSelected();
            }
        }
    }

    private class UpAction
    extends AbstractAction {
        private UpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            OptionsPanel.this.model.setPreviousCategoryAsCurrent();
            OptionsPanel.this.setCurrentCategory(OptionsPanel.this.model.getCurrent(), true);
        }
    }
}

