/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.advanced;

import java.awt.Color;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.options.ui.TabbedPanelModel;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class Model
extends TabbedPanelModel {
    private Map<String, AdvancedOption> categoryToOption = new HashMap<String, AdvancedOption>();
    private Map<String, JComponent> categoryToPanel = new HashMap<String, JComponent>();
    private Map<String, OptionsPanelController> categoryToController = new HashMap<String, OptionsPanelController>();
    private Lookup masterLookup;
    private boolean initialized = false;

    public List getCategories() {
        this.init();
        ArrayList<String> l = new ArrayList<String>(this.categoryToOption.keySet());
        Collections.sort(l, Collator.getInstance());
        return l;
    }

    public String getToolTip(String category) {
        AdvancedOption option = this.categoryToOption.get(category);
        return option.getTooltip();
    }

    public JComponent getPanel(String category) {
        this.init();
        JComponent panel = this.categoryToPanel.get(category);
        if (panel != null) {
            return panel;
        }
        AdvancedOption option = this.categoryToOption.get(category);
        OptionsPanelController controller = option.create();
        this.categoryToController.put(category, controller);
        panel = controller.getComponent(this.masterLookup);
        this.categoryToPanel.put(category, panel);
        Border b = panel.getBorder();
        b = b != null ? new CompoundBorder(new EmptyBorder(6, 16, 6, 6), b) : new EmptyBorder(6, 16, 6, 6);
        panel.setBorder(b);
        panel.setBackground(Color.white);
        panel.setMaximumSize(panel.getPreferredSize());
        return panel;
    }

    void update() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            it.next().update();
        }
    }

    void applyChanges() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            it.next().applyChanges();
        }
    }

    void cancel() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            it.next().cancel();
        }
    }

    boolean isValid() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            if (it.next().isValid()) continue;
            return false;
        }
        return true;
    }

    boolean isChanged() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            if (!it.next().isChanged()) continue;
            return true;
        }
        return false;
    }

    Lookup getLookup() {
        ArrayList<Lookup> lookups = new ArrayList<Lookup>();
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            lookups.add(it.next().getLookup());
        }
        return new ProxyLookup(lookups.toArray(new Lookup[lookups.size()]));
    }

    HelpCtx getHelpCtx(JComponent panel) {
        for (String category : this.categoryToPanel.keySet()) {
            if (panel != this.categoryToPanel.get(category)) continue;
            OptionsPanelController controller = this.categoryToController.get(category);
            return controller.getHelpCtx();
        }
        return new HelpCtx("netbeans.optionsDialog.advanced");
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Lookup lookup = Lookups.forPath((String)"OptionsDialog/Advanced");
        for (AdvancedOption option : lookup.lookup(new Lookup.Template(AdvancedOption.class)).allInstances()) {
            this.categoryToOption.put(option.getDisplayName(), option);
        }
    }

    void setLoookup(Lookup masterLookup) {
        this.masterLookup = masterLookup;
    }
}

