/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.guards;

import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.editor.guards.GuardedSectionsImpl;
import org.openide.text.NbDocument;

public final class PositionBounds {
    private Position begin;
    private Position end;
    private final GuardedSectionsImpl guards;

    public PositionBounds(Position begin, Position end, GuardedSectionsImpl guards) {
        this.begin = begin;
        this.end = end;
        this.guards = guards;
    }

    public static PositionBounds create(int begin, int end, GuardedSectionsImpl guards) throws BadLocationException {
        StyledDocument doc = guards.getDocument();
        return new PositionBounds(doc.createPosition(begin), doc.createPosition(end), guards);
    }

    public static PositionBounds createBodyBounds(int begin, int end, GuardedSectionsImpl guards) throws BadLocationException {
        StyledDocument doc = guards.getDocument();
        return new PositionBounds(new BackwardPosition(doc.createPosition(begin - 1)), doc.createPosition(end), guards);
    }

    public static PositionBounds createUnresolved(int begin, int end, GuardedSectionsImpl guards) throws BadLocationException {
        StyledDocument doc = guards.getDocument();
        return new PositionBounds(new UnresolvedPosition(begin), new UnresolvedPosition(end), guards);
    }

    public static PositionBounds createBodyUnresolved(int begin, int end, GuardedSectionsImpl guards) throws BadLocationException {
        return new PositionBounds(new BackwardPosition(new UnresolvedPosition(begin - 1)), new UnresolvedPosition(end), guards);
    }

    public void resolvePositions() throws BadLocationException {
        StyledDocument doc = this.guards.getDocument();
        if (this.end instanceof UnresolvedPosition) {
            Position b = this.begin instanceof BackwardPosition ? (((BackwardPosition)this.begin).delegate = doc.createPosition(((BackwardPosition)this.begin).delegate.getOffset())) : doc.createPosition(this.begin.getOffset());
            Position e = doc.createPosition(this.end.getOffset());
            this.begin = b;
            this.end = e;
        }
    }

    public Position getBegin() {
        return this.begin;
    }

    public Position getEnd() {
        return this.end;
    }

    public void setText(final String text) throws BadLocationException {
        final StyledDocument doc = this.guards.getDocument();
        final BadLocationException[] hold = new BadLocationException[]{null};
        Runnable run = new Runnable(){

            public void run() {
                try {
                    int p1 = PositionBounds.this.begin.getOffset();
                    int p2 = PositionBounds.this.end.getOffset();
                    int len = text.length();
                    if (len == 0) {
                        if (p2 > p1) {
                            doc.remove(p1, p2 - p1);
                        }
                    } else {
                        int docLen = doc.getLength();
                        if (p2 - p1 >= 1) {
                            doc.insertString(p1 + 1, text, null);
                            len = doc.getLength() - docLen;
                            doc.remove(p1 + 1 + len, p2 - p1 - 1);
                            doc.remove(p1, 1);
                        } else {
                            doc.insertString(p1, text, null);
                            len = doc.getLength() - docLen;
                            if (p2 > p1) {
                                doc.remove(p1 + len, p2 - p1);
                            }
                            if (PositionBounds.this.begin.getOffset() != p1) {
                                PositionBounds.this.begin = doc.createPosition(p1);
                            }
                            if (PositionBounds.this.end.getOffset() - p1 != len) {
                                PositionBounds.this.end = doc.createPosition(p1 + len);
                            }
                        }
                    }
                }
                catch (BadLocationException e) {
                    hold[0] = e;
                }
            }
        };
        NbDocument.runAtomic((StyledDocument)doc, (Runnable)run);
        if (hold[0] != null) {
            throw hold[0];
        }
    }

    public String getText() throws BadLocationException {
        StyledDocument doc = this.guards.getDocument();
        int p1 = this.begin.getOffset();
        int p2 = this.end.getOffset();
        return doc.getText(p1, p2 - p1);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("Position bounds[");
        try {
            String content = this.getText();
            buf.append(this.begin);
            buf.append(",");
            buf.append(this.end);
            buf.append(",\"");
            buf.append(content);
            buf.append("\"");
        }
        catch (BadLocationException e) {
            buf.append("Invalid: ");
            buf.append(e.getMessage());
        }
        buf.append("]");
        return buf.toString();
    }

    private static final class BackwardPosition
    implements Position {
        private Position delegate;

        public BackwardPosition(Position delegate) {
            this.delegate = delegate;
        }

        public int getOffset() {
            return this.delegate.getOffset() + 1;
        }
    }

    private static final class UnresolvedPosition
    implements Position {
        private int offset;

        public UnresolvedPosition(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

