/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.guards;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.editor.guards.GuardedSectionImpl;
import org.netbeans.modules.editor.guards.GuardedSectionsImpl;
import org.netbeans.modules.editor.guards.PositionBounds;

public final class SimpleSectionImpl
extends GuardedSectionImpl {
    private PositionBounds bounds;

    SimpleSectionImpl(String name, PositionBounds bounds, GuardedSectionsImpl guards) {
        super(name, guards);
        this.bounds = bounds;
    }

    public void setText(String text) {
        this.setText(this.bounds, text, true);
    }

    void markGuarded(StyledDocument doc) {
        this.markGuarded(doc, this.bounds, true);
    }

    void unmarkGuarded(StyledDocument doc) {
        this.markGuarded(doc, this.bounds, false);
    }

    public Position getCaretPosition() {
        return this.bounds.getBegin();
    }

    public String getText() {
        String text = "";
        try {
            text = this.bounds.getText();
        }
        catch (BadLocationException ex) {
            Logger.getLogger("guards").log(Level.ALL, null, ex);
        }
        return text;
    }

    public Position getEndPosition() {
        return this.bounds.getEnd();
    }

    public boolean contains(Position pos, boolean allowHoles) {
        return this.bounds.getBegin().getOffset() <= pos.getOffset() && this.bounds.getEnd().getOffset() >= pos.getOffset();
    }

    public Position getStartPosition() {
        return this.bounds.getBegin();
    }

    public void resolvePositions() throws BadLocationException {
        this.bounds.resolvePositions();
    }
}

