/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.netbeans.modules.java.j2seplatform.platformdefinition.Util;
import org.netbeans.modules.java.j2seplatform.wizard.J2SEWizardIterator;
import org.netbeans.spi.java.platform.PlatformInstall;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class J2SEInstallImpl
extends PlatformInstall {
    private static final String APPLE_JAVAVM_FRAMEWORK_PATH = "/System/Library/Frameworks/JavaVM.framework/Versions/";
    private boolean winOS;

    J2SEInstallImpl(boolean winOS) {
        this.winOS = winOS;
    }

    static J2SEInstallImpl create() {
        boolean windows = Utilities.isWindows();
        return new J2SEInstallImpl(windows);
    }

    public boolean accept(FileObject dir) {
        File f;
        if (!dir.isFolder()) {
            return false;
        }
        if (Utilities.isMac() && ((f = FileUtil.toFile((FileObject)dir)) == null || !f.getAbsolutePath().startsWith(APPLE_JAVAVM_FRAMEWORK_PATH))) {
            return false;
        }
        FileObject tool = Util.findTool("java", Collections.singleton(dir));
        if (tool == null) {
            return false;
        }
        tool = Util.findTool("javac", Collections.singleton(dir));
        return tool != null;
    }

    public WizardDescriptor.InstantiatingIterator createIterator(FileObject baseFolder) {
        try {
            return new J2SEWizardIterator(baseFolder);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            return null;
        }
    }

    public String getDisplayName() {
        return NbBundle.getMessage(J2SEInstallImpl.class, (String)"TXT_J2SEPlatform");
    }
}

