/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public class J2SELibrarySourceForBinaryQuery
implements SourceForBinaryQueryImplementation {
    private final Map<URL, SourceForBinaryQuery.Result> cache = new HashMap<URL, SourceForBinaryQuery.Result>();
    private final Map<URL, URL> normalizedURLCache = new HashMap<URL, URL>();

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        SourceForBinaryQuery.Result res = this.cache.get(binaryRoot);
        if (res != null) {
            return res;
        }
        boolean isNormalizedURL = J2SELibrarySourceForBinaryQuery.isNormalizedURL(binaryRoot);
        for (Library lib : LibraryManager.getDefault().getLibraries()) {
            String type = lib.getType();
            if (!"j2se".equalsIgnoreCase(type)) continue;
            for (URL entry : lib.getContent("classpath")) {
                URL normalizedEntry = isNormalizedURL ? this.getNormalizedURL(entry) : entry;
                if (normalizedEntry == null || !normalizedEntry.equals(binaryRoot)) continue;
                res = new Result(entry, lib);
                this.cache.put(binaryRoot, res);
                return res;
            }
        }
        return null;
    }

    private URL getNormalizedURL(URL url) {
        FileObject fo;
        if (J2SELibrarySourceForBinaryQuery.isNormalizedURL(url)) {
            return url;
        }
        URL normalizedURL = this.normalizedURLCache.get(url);
        if (normalizedURL == null && (fo = URLMapper.findFileObject((URL)url)) != null) {
            try {
                normalizedURL = fo.getURL();
                this.normalizedURLCache.put(url, normalizedURL);
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return normalizedURL;
    }

    private static boolean isNormalizedURL(URL url) {
        if ("jar".equals(url.getProtocol())) {
            url = FileUtil.getArchiveFile((URL)url);
        }
        return "file".equals(url.getProtocol());
    }

    private static class Result
    implements SourceForBinaryQuery.Result,
    PropertyChangeListener {
        private Library lib;
        private URL entry;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private FileObject[] cache;

        public Result(URL queryFor, Library lib) {
            this.entry = queryFor;
            this.lib = lib;
            this.lib.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.lib));
        }

        public synchronized FileObject[] getRoots() {
            if (this.cache == null) {
                if (this.lib.getContent("classpath").contains(this.entry)) {
                    ArrayList<FileObject> result = new ArrayList<FileObject>();
                    for (URL u : this.lib.getContent("src")) {
                        FileObject sourceRootURL = URLMapper.findFileObject((URL)u);
                        if (sourceRootURL == null) continue;
                        result.add(sourceRootURL);
                    }
                    this.cache = result.toArray(new FileObject[result.size()]);
                } else {
                    this.cache = new FileObject[0];
                }
            }
            return this.cache;
        }

        public synchronized void addChangeListener(ChangeListener l) {
            assert (l != null) : "Listener cannot be null";
            this.cs.addChangeListener(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            assert (l != null) : "Listener cannot be null";
            this.cs.removeChangeListener(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent event) {
            if ("content".equals(event.getPropertyName())) {
                Result result = this;
                synchronized (result) {
                    this.cache = null;
                }
                this.cs.fireChange();
            }
        }
    }
}

