/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class J2SELibrarySourceLevelQueryImpl
implements SourceLevelQueryImplementation {
    private static final String JDK_12 = "1.2";
    private static final String JDK_13 = "1.3";
    private static final String JDK_14 = "1.4";
    private static final String JDK_15 = "1.5";
    private static final String JDK_UNKNOWN = "";
    private static final String CLASS = "class";
    private static final int CF_MAGIC = -889275714;
    private static final int CF_INVALID = -1;
    private static final int CF_11 = 45;
    private static final int CF_12 = 46;
    private static final int CF_13 = 47;
    private static final int CF_14 = 48;
    private static final int CF_15 = 49;
    private Map sourceLevelCache = new WeakHashMap();
    private Reference lastUsedRoot;
    private Reference lastUsedLibrary;

    public String getSourceLevel(FileObject javaFile) {
        Library ll = this.isLastUsed(javaFile);
        if (ll != null) {
            return this.getSourceLevel(ll);
        }
        Library[] libraries = LibraryManager.getDefault().getLibraries();
        for (int i = 0; i < libraries.length; ++i) {
            ClassPath cp;
            FileObject root;
            List sourceRoots;
            if (!"j2se".equalsIgnoreCase(libraries[i].getType()) || (sourceRoots = libraries[i].getContent("src")).size() == 0 || (root = (cp = ClassPathSupport.createClassPath((URL[])sourceRoots.toArray(new URL[sourceRoots.size()]))).findOwnerRoot(javaFile)) == null) continue;
            this.setLastUsedRoot(root, libraries[i]);
            return this.getSourceLevel(libraries[i]);
        }
        return null;
    }

    private String getSourceLevel(Library lib) {
        String slevel = (String)this.sourceLevelCache.get(lib);
        if (slevel == null) {
            slevel = this.getSourceLevel(lib.getContent("classpath"));
            this.sourceLevelCache.put(lib, slevel);
        }
        return slevel == JDK_UNKNOWN ? null : slevel;
    }

    private String getSourceLevel(List cpRoots) {
        FileObject classFile = this.getClassFile(cpRoots);
        if (classFile == null) {
            return JDK_UNKNOWN;
        }
        int version = this.getClassFileMajorVersion(classFile);
        if (version == 45 || version == 46) {
            return JDK_12;
        }
        if (version == 47) {
            return JDK_13;
        }
        if (version == 48) {
            return JDK_14;
        }
        if (version >= 49) {
            return JDK_15;
        }
        return JDK_UNKNOWN;
    }

    private FileObject getClassFile(List cpRoots) {
        Iterator it = cpRoots.iterator();
        while (it.hasNext()) {
            FileObject cf;
            FileObject root = URLMapper.findFileObject((URL)((URL)it.next()));
            if (root == null || (cf = this.findClassFile(root)) == null) continue;
            return cf;
        }
        return null;
    }

    private FileObject findClassFile(FileObject root) {
        if (root.isData()) {
            if (CLASS.equals(root.getExt())) {
                return root;
            }
            return null;
        }
        FileObject[] children = root.getChildren();
        for (int i = 0; i < children.length; ++i) {
            FileObject result = this.findClassFile(children[i]);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getClassFileMajorVersion(FileObject classFile) {
        short s;
        DataInputStream in = null;
        try {
            short major;
            in = new DataInputStream(classFile.getInputStream());
            int magic = in.readInt();
            if (-889275714 != magic) {
                int n = -1;
                return n;
            }
            short minor = in.readShort();
            s = major = in.readShort();
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return s;
    }

    private synchronized void setLastUsedRoot(FileObject root, Library lib) {
        this.lastUsedRoot = new SoftReference<FileObject>(root);
        this.lastUsedLibrary = new WeakReference<Library>(lib);
    }

    private synchronized Library isLastUsed(FileObject javaFile) {
        if (this.lastUsedRoot == null) {
            return null;
        }
        FileObject root = (FileObject)this.lastUsedRoot.get();
        if (root == null) {
            return null;
        }
        if (root.equals(javaFile) || FileUtil.isParentOf((FileObject)root, (FileObject)javaFile)) {
            return (Library)this.lastUsedLibrary.get();
        }
        return null;
    }
}

