/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.java.j2seplatform.platformdefinition.Util;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class J2SEPlatformImpl
extends JavaPlatform {
    public static final String PROP_ANT_NAME = "antName";
    public static final String PLATFORM_J2SE = "j2se";
    protected static final String PLAT_PROP_ANT_NAME = "platform.ant.name";
    protected static final String PLAT_PROP_ARCH_FOLDER = "platform.arch.folder";
    protected static final String SYSPROP_BOOT_CLASSPATH = "sun.boot.class.path";
    protected static final String SYSPROP_JAVA_CLASS_PATH = "java.class.path";
    protected static final String SYSPROP_JAVA_EXT_PATH = "java.ext.dirs";
    private String displayName;
    private Map properties;
    private ClassPath sources;
    private List javadoc;
    private List installFolders;
    Reference bootstrap = new WeakReference<Object>(null);
    Reference standardLibs = new WeakReference<Object>(null);
    private Specification spec;

    J2SEPlatformImpl(String dispName, List installFolders, Map initialProperties, Map sysProperties, List sources, List javadoc) {
        this.displayName = dispName;
        if (installFolders != null) {
            this.installFolders = installFolders;
        } else {
            String home = (String)initialProperties.remove("platform.home");
            if (home != null) {
                this.installFolders = new ArrayList();
                StringTokenizer tk = new StringTokenizer(home, File.pathSeparator);
                while (tk.hasMoreTokens()) {
                    File f = new File(tk.nextToken());
                    try {
                        this.installFolders.add(f.toURI().toURL());
                    }
                    catch (MalformedURLException mue) {
                        ErrorManager.getDefault().notify((Throwable)mue);
                    }
                }
            } else {
                throw new IllegalArgumentException("Invalid platform, platform must have install folder.");
            }
        }
        this.properties = initialProperties;
        this.sources = J2SEPlatformImpl.createClassPath(sources);
        this.javadoc = javadoc != null ? Collections.unmodifiableList(javadoc) : Collections.EMPTY_LIST;
        this.setSystemProperties(sysProperties);
    }

    protected J2SEPlatformImpl(String dispName, String antName, List installFolders, Map initialProperties, Map sysProperties, List sources, List javadoc) {
        this(dispName, installFolders, initialProperties, sysProperties, sources, javadoc);
        this.properties.put(PLAT_PROP_ANT_NAME, antName);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
        this.firePropertyChange("displayName", null, null);
    }

    protected final void internalSetDisplayName(String name) {
        this.displayName = name;
    }

    public String getAntName() {
        return (String)this.properties.get(PLAT_PROP_ANT_NAME);
    }

    public void setAntName(String antName) {
        if (antName == null || antName.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.properties.put(PLAT_PROP_ANT_NAME, antName);
        this.firePropertyChange(PROP_ANT_NAME, null, null);
    }

    public void setArchFolder(String folder) {
        if (folder == null || folder.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.properties.put(PLAT_PROP_ARCH_FOLDER, folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath getBootstrapLibraries() {
        J2SEPlatformImpl j2SEPlatformImpl = this;
        synchronized (j2SEPlatformImpl) {
            ClassPath cp = this.bootstrap == null ? null : this.bootstrap.get();
            if (cp != null) {
                return cp;
            }
            String pathSpec = (String)this.getSystemProperties().get(SYSPROP_BOOT_CLASSPATH);
            String extPathSpec = Util.getExtensions((String)this.getSystemProperties().get(SYSPROP_JAVA_EXT_PATH));
            if (extPathSpec != null) {
                pathSpec = pathSpec + File.pathSeparator + extPathSpec;
            }
            cp = Util.createClassPath(pathSpec);
            this.bootstrap = new WeakReference<ClassPath>(cp);
            return cp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath getStandardLibraries() {
        J2SEPlatformImpl j2SEPlatformImpl = this;
        synchronized (j2SEPlatformImpl) {
            ClassPath cp = this.standardLibs == null ? null : this.standardLibs.get();
            if (cp != null) {
                return cp;
            }
            String pathSpec = (String)this.getSystemProperties().get(SYSPROP_JAVA_CLASS_PATH);
            cp = Util.createClassPath(pathSpec);
            this.standardLibs = new WeakReference<ClassPath>(cp);
            return cp;
        }
    }

    public final Collection getInstallFolders() {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (URL url : this.installFolders) {
            FileObject root = URLMapper.findFileObject((URL)url);
            if (root == null) continue;
            result.add(root);
        }
        return result;
    }

    public final FileObject findTool(String toolName) {
        String archFolder = (String)this.getProperties().get(PLAT_PROP_ARCH_FOLDER);
        FileObject tool = null;
        if (archFolder != null) {
            tool = Util.findTool(toolName, this.getInstallFolders(), archFolder);
        }
        if (tool == null) {
            tool = Util.findTool(toolName, this.getInstallFolders());
        }
        return tool;
    }

    public final ClassPath getSourceFolders() {
        return this.sources;
    }

    public final void setSourceFolders(ClassPath c) {
        assert (c != null);
        this.sources = c;
        this.firePropertyChange("sourceFolders", null, null);
    }

    public final List getJavadocFolders() {
        return this.javadoc;
    }

    public final void setJavadocFolders(List c) {
        assert (c != null);
        List<URL> safeCopy = Collections.unmodifiableList(new ArrayList(c));
        for (URL url : safeCopy) {
            if ("jar".equals(url.getProtocol()) || !FileUtil.isArchiveFile((URL)url)) continue;
            throw new IllegalArgumentException("JavadocFolder must be a folder.");
        }
        this.javadoc = safeCopy;
        this.firePropertyChange("javadocFolders", null, null);
    }

    public String getVendor() {
        String s = (String)this.getSystemProperties().get("java.vm.vendor");
        return s == null ? "" : s;
    }

    public Specification getSpecification() {
        if (this.spec == null) {
            this.spec = new Specification(PLATFORM_J2SE, Util.getSpecificationVersion(this));
        }
        return this.spec;
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    Collection getInstallFolderURLs() {
        return Collections.unmodifiableList(this.installFolders);
    }

    private static ClassPath createClassPath(List urls) {
        ArrayList<PathResourceImplementation> resources = new ArrayList<PathResourceImplementation>();
        if (urls != null) {
            for (URL url : urls) {
                resources.add(ClassPathSupport.createResource((URL)url));
            }
        }
        return ClassPathSupport.createClassPath(resources);
    }
}

