/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javahelp.Installer;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class HelpAction
extends SystemAction {
    private static final long serialVersionUID = 4658008202517094416L;

    public String getName() {
        return NbBundle.getMessage(HelpAction.class, (String)"LBL_HelpAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "org/netbeans/modules/javahelp/resources/show-help.gif";
    }

    protected void initialize() {
        super.initialize();
        Installer.log.fine("HelpAction.initialize");
        this.putProperty("OpenIDE-Transmodal-Action", Boolean.TRUE);
    }

    private static HelpCtx findHelpCtx() {
        Window w = WindowActivatedDetector.getCurrentActivatedWindow();
        Component focused = w != null ? SwingUtilities.findFocusOwner(w) : null;
        HelpCtx help = focused == null ? HelpCtx.DEFAULT_HELP : HelpCtx.findHelp((Component)focused);
        Installer.log.fine(help.toString() + " from " + focused);
        return help;
    }

    public void actionPerformed(ActionEvent ev) {
        HelpCtx help;
        Help h = (Help)Lookup.getDefault().lookup(Help.class);
        if (h == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        final MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
        if (path != null && path.length > 0 && !(path[0].getComponent() instanceof ComboPopup)) {
            help = HelpCtx.findHelp((Component)path[path.length - 1].getComponent());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MenuElement[] newPath = MenuSelectionManager.defaultManager().getSelectedPath();
                    if (newPath.length != path.length) {
                        return;
                    }
                    for (int i = 0; i < newPath.length; ++i) {
                        if (newPath[i] == path[i]) continue;
                        return;
                    }
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
            });
        } else {
            help = HelpAction.findHelpCtx();
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(HelpAction.class, (String)"CTL_OpeningHelp"));
        h.showHelp(help);
    }

    static class WindowActivatedDetector
    implements AWTEventListener {
        private static WeakReference<Window> currentWindowRef;
        private static WindowActivatedDetector detector;

        WindowActivatedDetector() {
        }

        static synchronized void install() {
            if (detector == null) {
                detector = new WindowActivatedDetector();
                Toolkit.getDefaultToolkit().addAWTEventListener(detector, 64L);
            }
        }

        static synchronized void uninstall() {
            if (detector != null) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(detector);
                detector = null;
            }
        }

        static synchronized Window getCurrentActivatedWindow() {
            if (currentWindowRef != null) {
                return (Window)currentWindowRef.get();
            }
            return null;
        }

        private static synchronized void setCurrentActivatedWindow(Window w) {
            currentWindowRef = new WeakReference<Window>(w);
        }

        public void eventDispatched(AWTEvent ev) {
            if (ev.getID() != 205) {
                return;
            }
            WindowActivatedDetector.setCurrentActivatedWindow(((WindowEvent)ev).getWindow());
        }

        static {
            detector = null;
        }
    }
}

