/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.todo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Settings {
    private static Settings theInstance;
    private ArrayList<String> patterns = new ArrayList(10);
    private Map<String, CommentTags> ext2comments = new HashMap<String, CommentTags>(10);
    private boolean scanCommentsOnly = true;

    private Settings() {
        this.patterns.add("@todo");
        this.patterns.add("TODO");
        this.patterns.add("FIXME");
        this.patterns.add("XXX");
        this.patterns.add("PENDING");
        this.patterns.add("<<<<<<<");
        this.ext2comments.put("JAVA", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("C", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("CPP", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("CXX", new CommentTags("//", "/*", "*/"));
        this.ext2comments.put("HTML", new CommentTags("<!--", "-->"));
        this.ext2comments.put("HTM", new CommentTags("<!--", "-->"));
        this.ext2comments.put("XML", new CommentTags("<!--", "-->"));
        this.ext2comments.put("JSP", new CommentTags("<%--", "--%>"));
        this.ext2comments.put("PROPERTIES", new CommentTags("#"));
        this.ext2comments.put("SH", new CommentTags("#"));
    }

    public static final Settings getDefault() {
        if (null == theInstance) {
            theInstance = new Settings();
        }
        return theInstance;
    }

    public Collection<String> getPatterns() {
        return Collections.unmodifiableCollection(this.patterns);
    }

    public boolean isExtensionSupported(String fileExtension) {
        return null != this.ext2comments.get(fileExtension.toUpperCase());
    }

    public String getLineComment(String fileExtension) {
        CommentTags ct = this.ext2comments.get(fileExtension.toUpperCase());
        return null == ct ? null : ct.lineComment;
    }

    public String getBlockCommentStart(String fileExtension) {
        CommentTags ct = this.ext2comments.get(fileExtension.toUpperCase());
        return null == ct ? null : ct.blockCommentStart;
    }

    public String getBlockCommentEnd(String fileExtension) {
        CommentTags ct = this.ext2comments.get(fileExtension.toUpperCase());
        return null == ct ? null : ct.blockCommentEnd;
    }

    public boolean isScanCommentsOnly() {
        return this.scanCommentsOnly;
    }

    private static class CommentTags {
        private String lineComment;
        private String blockCommentStart;
        private String blockCommentEnd;

        public CommentTags(String lineComment, String blockCommentStart, String blockCommentEnd) {
            this.lineComment = lineComment;
            this.blockCommentStart = blockCommentStart;
            this.blockCommentEnd = blockCommentEnd;
        }

        public CommentTags(String blockCommentStart, String blockCommentEnd) {
            this.blockCommentStart = blockCommentStart;
            this.blockCommentEnd = blockCommentEnd;
        }

        public CommentTags(String lineComment) {
            this.lineComment = lineComment;
        }
    }
}

