/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import org.netbeans.beaninfo.editors.DataFolderPanel;
import org.netbeans.core.UIExceptions;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;

public class DataFolderEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private DataFolderPanel dfPanel;
    PropertyEnv env;

    public String getAsText() {
        DataFolder df = (DataFolder)this.getValue();
        String result = df == null ? DataFolderEditor.getString("LAB_DefaultDataFolder") : df.getName();
        if (result.length() == 0) {
            result = File.pathSeparator;
        }
        return result;
    }

    public void setAsText(String text) {
        if (!(text == null || "".equals(text) || text.equals(DataFolderEditor.getString("LAB_DefaultDataFolder")) || File.pathSeparator.equals(text))) {
            IllegalArgumentException iae = new IllegalArgumentException();
            String msg = MessageFormat.format(NbBundle.getMessage(DataFolderEditor.class, (String)"FMT_DF_UNKNOWN"), text);
            UIExceptions.annotateUser(iae, iae.getMessage(), msg, null, new Date());
            throw iae;
        }
        this.setValue(null);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        this.dfPanel = this.getDFPanel();
        Object val = this.getValue();
        if (val instanceof DataFolder) {
            this.dfPanel.setTargetFolder((DataFolder)val);
        }
        return this.dfPanel;
    }

    public void setValue(Object newValue) {
        Object oldValue = this.getValue();
        super.setValue(newValue);
        DataFolderPanel dfp = this.getDFPanel();
        if (newValue != oldValue && dfp != null && newValue instanceof DataFolder) {
            dfp.setTargetFolder((DataFolder)newValue);
        }
    }

    void setDataFolder(DataFolder newDf) {
        super.setValue(newDf);
    }

    public DataFolderPanel getDFPanel() {
        if (this.dfPanel == null) {
            this.dfPanel = new DataFolderPanel(this);
        }
        return this.dfPanel;
    }

    private static String getString(String s) {
        return NbBundle.getBundle(DataFolderEditor.class).getString(s);
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
    }
}

