/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;
import org.netbeans.beaninfo.ExplorerPanel;
import org.netbeans.beaninfo.editors.DataFolderEditor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.windows.TopComponent;

class DataFolderPanel
extends TopComponent
implements DocumentListener,
DataFilter,
PropertyChangeListener,
VetoableChangeListener {
    static Dimension PREF_DIM = new Dimension(450, 250);
    private ChangeListener listener;
    Reference<FileSystem> system = new WeakReference<Object>(null);
    private Node rootNode;
    private DataFolder df;
    private DataFolderEditor editor;
    private static final String PATH_TOKEN_DELIMITER = "/" + File.separatorChar;
    private String last_suggestion = "";
    private BeanTreeView beanTreeView;
    private JButton createButton;
    private JLabel descriptionLabel;
    private JLabel dirLabel;
    private JTextField directoryName;
    private JLabel packageLabel;
    private JTextField packageName;
    private ExplorerPanel packagesPanel;

    public DataFolderPanel(DataFolderEditor ed) {
        this();
        this.editor = ed;
        this.editor.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        this.editor.env.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public DataFolderPanel() {
        this.initComponents();
        this.setName(DataFolderPanel.getString("LAB_TargetLocationPanelName"));
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.rootNode = this.createPackagesNode();
        this.beanTreeView.setRootVisible(false);
        this.packagesPanel.getExplorerManager().setRootContext(this.rootNode);
        this.packagesPanel.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
        this.packagesPanel.getExplorerManager().addVetoableChangeListener((VetoableChangeListener)this);
        this.packageName.getDocument().addDocumentListener(this);
        this.packageName.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.beanTreeView.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_DataFolderTree"));
        this.packageName.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_package"));
        this.directoryName.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_directory"));
        this.createButton.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_Create"));
        this.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_DataFolderPanel"));
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    public void requestFocus() {
    }

    private Node createPackagesNode() {
        Node topNode = RepositoryNodeFactory.getDefault().repository((DataFilter)this);
        Node[] nodes = topNode.getChildren().getNodes(true);
        assert (nodes != null && nodes.length == 1) : "Only one subnode " + topNode + " found, but was " + Arrays.asList(nodes);
        return nodes[0];
    }

    private void initComponents() {
        this.packagesPanel = new ExplorerPanel();
        this.beanTreeView = new BeanTreeView();
        this.descriptionLabel = new JLabel();
        this.packageLabel = new JLabel();
        this.packageName = new JTextField();
        this.dirLabel = new JLabel();
        this.directoryName = new JTextField();
        this.createButton = new JButton();
        this.setLayout(new BorderLayout());
        this.packagesPanel.setLayout(new GridBagLayout());
        this.beanTreeView.setDefaultActionAllowed(false);
        this.beanTreeView.setPopupAllowed(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.packagesPanel.add((Component)this.beanTreeView, gridBagConstraints);
        this.descriptionLabel.setLabelFor((Component)this.beanTreeView);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getBundle(DataFolderPanel.class).getString("LAB_TargetLocationDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.packagesPanel.add(this.descriptionLabel, gridBagConstraints);
        this.packageLabel.setLabelFor(this.packageName);
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getBundle(DataFolderPanel.class).getString("LAB_package"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        this.packagesPanel.add(this.packageLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.packagesPanel.add(this.packageName, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.dirLabel, (String)NbBundle.getBundle(DataFolderPanel.class).getString("LAB_directory"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.packagesPanel.add(this.dirLabel, gridBagConstraints);
        this.directoryName.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.packagesPanel.add(this.directoryName, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.createButton, (String)NbBundle.getBundle(DataFolderPanel.class).getString("CTL_Create"));
        this.createButton.setEnabled(false);
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataFolderPanel.this.createButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.packagesPanel.add(this.createButton, gridBagConstraints);
        this.add((Component)((Object)this.packagesPanel), "Center");
    }

    private void createButtonActionPerformed(ActionEvent evt) {
        try {
            DataFolder newDf = (DataFolder)this.getPropertyValue();
            this.setTargetFolder(newDf);
            this.updateDirectory();
            this.updatePropertyEditor();
            this.enableCreateButton();
        }
        catch (IllegalStateException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public boolean acceptDataObject(DataObject obj) {
        return obj instanceof DataFolder;
    }

    public void vetoableChange(PropertyChangeEvent ev) throws PropertyVetoException {
        Node[] arr;
        if ("selectedNodes".equals(ev.getPropertyName()) && (arr = (Node[])ev.getNewValue()).length > 1) {
            throw new PropertyVetoException("Only single selection allowed", ev);
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if ("selectedNodes".equals(ev.getPropertyName())) {
            Node[] arr = this.packagesPanel.getExplorerManager().getSelectedNodes();
            if (!this.isVisible()) {
                return;
            }
            if (arr.length == 1) {
                if (!this.isValid()) {
                    this.setTargetFolder(null);
                    this.implSetDataFolder(null);
                    return;
                }
                DataFolder df = (DataFolder)arr[0].getCookie(DataFolder.class);
                if (df != null) {
                    this.setTargetFolder(df);
                    this.updatePropertyEditor();
                    this.enableCreateButton();
                    return;
                }
            }
            this.setTargetFolder(null);
            this.implSetDataFolder(null);
        }
        if ("state".equals(ev.getPropertyName()) && ev.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    private void fireStateChanged() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public void changedUpdate(DocumentEvent p1) {
        if (p1.getDocument() == this.packageName.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String text = DataFolderPanel.this.packageName.getText();
                    if (text != null) {
                        if (DataFolderPanel.this.isValid()) {
                            DataFolderPanel.this.setTargetFolder(text, false);
                            DataFolderPanel.this.updatePropertyEditor();
                        }
                        DataFolderPanel.this.updateDirectory();
                    }
                    DataFolderPanel.this.enableCreateButton();
                }
            });
            return;
        }
    }

    public void removeUpdate(DocumentEvent p1) {
        if (p1.getDocument() == this.packageName.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String text;
                    FileSystem fs;
                    if (DataFolderPanel.this.packageName.getText().length() == 0 && (fs = DataFolderPanel.this.system.get()) != null) {
                        DataFolder df = DataFolder.findFolder((FileObject)fs.getRoot());
                        DataFolderPanel.this.setTargetFolder(df);
                        DataFolderPanel.this.packageName.selectAll();
                    }
                    if ((text = DataFolderPanel.this.packageName.getText()) != null) {
                        if (DataFolderPanel.this.isValid()) {
                            DataFolderPanel.this.setTargetFolder(text, true);
                            DataFolderPanel.this.updatePropertyEditor();
                        }
                        DataFolderPanel.this.updateDirectory();
                    }
                    DataFolderPanel.this.enableCreateButton();
                }
            });
        }
    }

    public void insertUpdate(DocumentEvent p1) {
        this.changedUpdate(p1);
    }

    public HelpCtx getHelp() {
        return new HelpCtx(DataFolderPanel.class);
    }

    public boolean isValid() {
        Node[] arr;
        String text = this.packageName.getText();
        return text.length() != 0 || (arr = this.packagesPanel.getExplorerManager().getSelectedNodes()).length != 1 || arr[0] != this.rootNode;
    }

    public void addChangeListener(ChangeListener l) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listener = null;
    }

    private static String computeSuggestion(Node node, String pref, Node[] first) {
        Node[] arr = node.getChildren().getNodes();
        String match = null;
        for (int i = 0; i < arr.length; ++i) {
            int indx;
            String name = arr[i].getName();
            if (!name.startsWith(pref)) continue;
            if (match == null) {
                match = name;
                if (first == null) continue;
                first[0] = arr[i];
                continue;
            }
            int end = Math.min(name.length(), match.length());
            for (indx = pref.length(); indx < end && match.charAt(indx) == name.charAt(indx); ++indx) {
            }
            match = match.substring(0, indx);
        }
        if (match == null) {
            return null;
        }
        return match.substring(pref.length());
    }

    boolean setTargetFolder(DataFolder f) {
        boolean exact;
        String name;
        Node n = null;
        this.df = f;
        if (f != null) {
            FileObject fo = f.getPrimaryFile();
            name = fo.getPath();
            StringTokenizer st = new StringTokenizer(name, PATH_TOKEN_DELIMITER);
            try {
                FileSystem fs = fo.getFileSystem();
                if (fo.isRoot()) {
                    boolean withSubfolder;
                    name = this.packageName.getText().trim();
                    boolean bl = withSubfolder = name.indexOf(File.separatorChar) != -1;
                    if (fo.getFileObject(name) != null || withSubfolder) {
                        name = "";
                    }
                }
                this.system = new WeakReference<FileSystem>(fs);
                n = NodeOp.findPath((Node)this.rootNode, (Enumeration)NbCollections.checkedEnumerationByFilter((Enumeration)st, String.class, (boolean)true));
                exact = true;
            }
            catch (FileStateInvalidException ex) {
                n = this.rootNode;
                name = "";
                exact = false;
            }
            catch (NodeNotFoundException ex) {
                n = ex.getClosestNode();
                DataFolder df = (DataFolder)n.getCookie(DataFolder.class);
                name = df != null ? df.getPrimaryFile().getPath() : "";
                exact = false;
            }
        } else {
            n = this.rootNode;
            name = null;
            exact = true;
        }
        ExplorerManager em = this.packagesPanel.getExplorerManager();
        em.removePropertyChangeListener((PropertyChangeListener)this);
        this.packageName.getDocument().removeDocumentListener(this);
        try {
            em.setSelectedNodes(new Node[]{n});
        }
        catch (PropertyVetoException ex) {
            throw new InternalError();
        }
        this.packageName.setText(name);
        this.updateDirectory();
        this.packageName.getDocument().addDocumentListener(this);
        em.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireStateChanged();
        return exact;
    }

    private DataFolder getTargetFolder(boolean create) throws IOException {
        FileSystem fs;
        if (create && this.isValid() && (fs = this.system.get()) != null) {
            DataFolder folder = DataFolder.findFolder((FileObject)fs.getRoot());
            String currentName = this.packageName.getText().replace('\\', '/');
            if (currentName.length() > 0) {
                folder = DataFolder.create((DataFolder)folder, (String)currentName);
            }
            this.df = folder;
            return folder;
        }
        return this.df;
    }

    private boolean setTargetFolder(String f, boolean afterDelete) {
        NodeNotFoundException closest;
        Node n;
        block16: {
            n = null;
            closest = null;
            HashSet<Node> selected = new HashSet<Node>();
            Node[] nodes = this.packagesPanel.getExplorerManager().getSelectedNodes();
            for (int i = 0; i < nodes.length; ++i) {
                Node n1 = nodes[i];
                if (n1.getParentNode() == null) continue;
                while (n1.getParentNode().getParentNode() != null) {
                    n1 = n1.getParentNode();
                }
                selected.add(n1);
            }
            StringTokenizer st = new StringTokenizer(f, PATH_TOKEN_DELIMITER);
            try {
                n = NodeOp.findPath((Node)this.rootNode, (Enumeration)NbCollections.checkedEnumerationByFilter((Enumeration)st, String.class, (boolean)true));
            }
            catch (NodeNotFoundException ex) {
                String sugg;
                if (st.hasMoreElements() || (sugg = DataFolderPanel.computeSuggestion(ex.getClosestNode(), ex.getMissingChildName(), null)) == null) break block16;
                closest = ex;
            }
        }
        if (n != null) {
            closest = null;
        } else {
            if (closest == null) {
                return false;
            }
            n = closest.getClosestNode();
        }
        ExplorerManager em = this.packagesPanel.getExplorerManager();
        em.removePropertyChangeListener((PropertyChangeListener)this);
        if (closest != null) {
            Node[] first = new Node[1];
            String sugg = DataFolderPanel.computeSuggestion(closest.getClosestNode(), closest.getMissingChildName(), first);
            if (afterDelete && sugg != null && sugg.equals(this.last_suggestion)) {
                sugg = null;
            }
            this.last_suggestion = sugg;
            if (sugg != null) {
                this.packageName.getDocument().removeDocumentListener(this);
                this.packageName.setText(f + sugg);
                this.updateDirectory();
                Caret c = this.packageName.getCaret();
                c.setDot(f.length() + sugg.length());
                c.moveDot(f.length());
                this.packageName.getDocument().addDocumentListener(this);
            }
            if (first[0] != null) {
                n = first[0];
            }
        }
        try {
            em.setSelectedNodes(new Node[]{n});
        }
        catch (PropertyVetoException ex) {
            throw new InternalError();
        }
        this.df = (DataFolder)n.getCookie(DataFolder.class);
        if (this.df != null) {
            try {
                FileSystem fs = this.df.getPrimaryFile().getFileSystem();
                this.system = new WeakReference<FileSystem>(fs);
            }
            catch (FileStateInvalidException ex) {
                // empty catch block
            }
        }
        em.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireStateChanged();
        return closest == null;
    }

    void updateDirectory() {
        FileSystem fs = this.system.get();
        if (fs == null) {
            this.directoryName.setText("");
            return;
        }
        String name = this.packageName.getText();
        FileObject folder = fs.findResource(name);
        if (folder != null) {
            File f = FileUtil.toFile((FileObject)folder);
            if (f != null) {
                this.directoryName.setText(f.getAbsolutePath());
            } else {
                this.directoryName.setText("");
            }
        } else {
            FileObject fo = fs.getRoot();
            assert (fo != null) : fs;
            File f = FileUtil.toFile((FileObject)fo);
            if (f != null) {
                File f2 = new File(f, name.replace('/', File.separatorChar));
                this.directoryName.setText(f2.getAbsolutePath());
            } else {
                this.directoryName.setText("");
            }
        }
    }

    private void implSetDataFolder(DataFolder df) {
        if (this.editor != null) {
            if (!this.isValid()) {
                this.editor.setDataFolder(null);
            } else {
                FileObject fo;
                FileSystem fs = null;
                if (this.system != null) {
                    fs = this.system.get();
                }
                if (df == null && fs != null && (fo = fs.getRoot()) != null) {
                    df = DataFolder.findFolder((FileObject)fo);
                }
                if (df != null) {
                    String name = df.getPrimaryFile().getPath();
                    if (name.equals(this.packageName.getText())) {
                        this.editor.setDataFolder(df);
                    } else {
                        this.editor.setDataFolder(null);
                    }
                } else {
                    this.editor.setDataFolder(null);
                }
            }
        }
    }

    void updatePropertyEditor() {
        try {
            DataFolder newF = this.getTargetFolder(false);
            this.implSetDataFolder(newF);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void enableCreateButton() {
        String name = null;
        name = this.df != null ? this.df.getPrimaryFile().getPath() : "";
        if (name.equals(this.packageName.getText())) {
            this.createButton.setEnabled(false);
        } else {
            this.createButton.setEnabled(this.isValid());
        }
    }

    private Object getPropertyValue() throws IllegalStateException {
        if (this.isValid()) {
            try {
                this.df = this.getTargetFolder(true);
                return this.df;
            }
            catch (IOException x) {
                Exceptions.printStackTrace((Throwable)x);
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException();
    }

    private static String getString(String s) {
        return NbBundle.getBundle(DataFolderPanel.class).getString(s);
    }

    public static class ShadowDirNode
    extends AbstractNode {
        public ShadowDirNode(Children children) {
            super(children);
        }
    }

    public static class ShadowLeafNode
    extends AbstractNode {
        public ShadowLeafNode() {
            super(Children.LEAF);
        }
    }
}

