/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Insets;
import java.beans.PropertyEditorSupport;
import java.util.Vector;
import javax.swing.JPanel;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataObjectPanel
extends JPanel {
    static final int DEFAULT_INSET = 10;
    protected DataFilter folderFilter;
    protected DataFilter dataFilter;
    protected NodeAcceptor nodeFilter;
    protected Insets insets;
    protected String subTitle;
    protected String description;
    protected DataObject rootObject;
    protected Node rootNode;
    protected DataObject dObj;
    protected boolean multiSelection;
    protected int selectionMode = 0;
    protected PropertyEditorSupport myEditor;
    private PropertyEnv env;

    public DataObjectPanel(PropertyEditorSupport my, PropertyEnv env) {
        this.env = env;
        this.myEditor = my;
    }

    public void setEnv(PropertyEnv env) {
        this.env = env;
    }

    public void setDataFilter(DataFilter df) {
        this.dataFilter = df;
    }

    public void setNodeFilter(NodeAcceptor acceptor) {
        this.nodeFilter = acceptor;
    }

    public void setInsetValue(int insetVal) {
        this.insets = new Insets(insetVal, insetVal, insetVal, insetVal);
    }

    public void setText(String text) {
        this.subTitle = text;
    }

    public void setRootObject(DataObject obj) {
        this.rootObject = obj;
    }

    public void setRootNode(Node n) {
        this.rootNode = n;
    }

    public void setFolderFilter(DataFilter f) {
        this.folderFilter = f;
    }

    public DataFilter getFolderFilter() {
        return this.folderFilter;
    }

    public void setDataObject(DataObject d) {
        this.dObj = d;
    }

    public void setMultiSelection(boolean multiSelection) {
        this.multiSelection = multiSelection;
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public void setDescription(String desc) {
    }

    protected Node findNode(Node parent, DataObject val) {
        Node[] allNodes;
        Children children = parent.getChildren();
        Node theNode = children.findChild(val.getName());
        if (theNode == null && (allNodes = children.getNodes()) != null && allNodes.length > 0) {
            for (int i = 0; i < allNodes.length && theNode == null; ++i) {
                DataObject dObj = (DataObject)allNodes[i].getCookie(DataObject.class);
                if (dObj == null || dObj != val) continue;
                theNode = allNodes[i];
            }
        }
        return theNode;
    }

    protected Node findNodeForObj(Node rootNode, DataObject dObj) {
        Node parent;
        Node node = null;
        Vector<DataFolder> v = new Vector<DataFolder>();
        for (DataFolder df = dObj.getFolder(); df != null; df = df.getFolder()) {
            v.addElement(df);
        }
        node = !v.isEmpty() ? ((parent = this.findParentNode(v, rootNode.getChildren())) != null ? this.findNode(parent, dObj) : this.findNode(rootNode, dObj)) : this.findNode(rootNode, dObj);
        return node;
    }

    protected Node findParentNode(Vector<DataFolder> v, Children children) {
        DataFolder df = v.lastElement();
        Node n = children.findChild(df.getNodeDelegate().getName());
        if (n == null) {
            Node[] nodes = children.getNodes();
            for (int i = 0; i < nodes.length && n == null; ++i) {
                DataFolder folder = (DataFolder)nodes[i].getCookie(DataFolder.class);
                if (folder == null || folder != df) continue;
                n = nodes[i];
            }
        }
        if (v.size() > 1) {
            v.removeElement(df);
            if (n != null) {
                return this.findParentNode(v, n.getChildren());
            }
            return this.findParentNode(v, children);
        }
        return n;
    }

    public DataObject getDataObject() {
        return null;
    }

    public Node getNode() {
        return null;
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.getDataObject();
    }

    protected void setOkButtonEnabled(boolean b) {
        if (this.env != null) {
            this.env.setState(b ? PropertyEnv.STATE_VALID : PropertyEnv.STATE_INVALID);
        }
    }

    static class FilteredChildren
    extends FilterNode.Children {
        private NodeAcceptor nodeAcceptor;
        private DataFilter dFilter;

        FilteredChildren(Node n, NodeAcceptor acceptor, DataFilter filter) {
            super(n);
            this.nodeAcceptor = acceptor;
            this.dFilter = filter;
        }

        private Node[] makeFilterNode(Node n) {
            FilteredChildren children = new FilteredChildren(n, this.nodeAcceptor, this.dFilter);
            return new Node[]{new FilterNode(n, (Children)children)};
        }

        protected Node[] createNodes(Node key) {
            if (key != null) {
                DataObject dObj;
                Node[] n = new Node[]{key};
                if (this.dFilter != null && (dObj = (DataObject)n[0].getCookie(DataObject.class)) != null && this.dFilter.acceptDataObject(dObj)) {
                    return this.makeFilterNode(n[0]);
                }
                if (this.nodeAcceptor.acceptNodes(n)) {
                    return this.makeFilterNode(n[0]);
                }
            }
            return new Node[0];
        }
    }
}

