/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.actions.FindAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.InstanceSupport;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

public final class DataSystem
extends AbstractNode
implements RepositoryListener {
    private static DataSystem def;
    private transient Repository fileSystemPool;
    DataFilter filter;

    private DataSystem(Children ch, Repository fsp, DataFilter filter) {
        super(ch);
        this.fileSystemPool = fsp;
        this.filter = filter;
        this.initialize();
        this.setIconBaseWithExtension("org/netbeans/core/resources/repository.gif");
        this.setName(NbBundle.getBundle(DataSystem.class).getString("dataSystemName"));
        this.setShortDescription(NbBundle.getBundle(DataSystem.class).getString("CTL_Repository_Hint"));
        this.getCookieSet().add((Node.Cookie)new InstanceSupport.Instance((Object)fsp));
    }

    private DataSystem(Children ch, DataFilter filter) {
        this(ch, Repository.getDefault(), filter);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(DataSystem.class);
    }

    public static Node getDataSystem(DataFilter filter) {
        if (filter == null) {
            if (def != null) {
                return def;
            }
            def = new DataSystem((Children)new DSMap(), DataFilter.ALL);
            return def;
        }
        return new DataSystem((Children)new DSMap(), filter);
    }

    public static Node getDataSystem() {
        return DataSystem.getDataSystem(null);
    }

    void initialize() {
        this.fileSystemPool.addRepositoryListener((RepositoryListener)WeakListeners.create(RepositoryListener.class, (EventListener)((Object)this), (Object)this.fileSystemPool));
        Enumeration en = this.fileSystemPool.getFileSystems();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            fs.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)((DSMap)this.getChildren()), (Object)fs));
        }
        this.refresh();
    }

    public Node.Handle getHandle() {
        return this.filter == DataFilter.ALL ? new DSHandle(null) : new DSHandle(this.filter);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(FindAction.class), SystemAction.get(ToolsAction.class)};
    }

    public void fileSystemAdded(RepositoryEvent ev) {
        ev.getFileSystem().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)((DSMap)this.getChildren()), (Object)ev.getFileSystem()));
        this.refresh();
    }

    public void fileSystemRemoved(RepositoryEvent ev) {
        this.refresh();
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent ev) {
        this.refresh();
    }

    void refresh() {
        this.refresh(null);
    }

    void refresh(FileSystem fs) {
        URLMapper mapper = DataSystem.getMasterFsURLMapper();
        if (mapper == null) {
            ((DSMap)this.getChildren()).refresh(this.fileSystemPool, fs);
        } else {
            ((DSMap)this.getChildren()).refreshListRoots(mapper);
        }
    }

    private static URLMapper getMasterFsURLMapper() {
        URLMapper retVal = null;
        Lookup.Result result = Lookup.getDefault().lookupResult(URLMapper.class);
        Collection c = result.allInstances();
        for (URLMapper mapper : c) {
            if (mapper == null || !"org.netbeans.modules.masterfs.MasterURLMapper".equals(mapper.getClass().getName())) continue;
            retVal = mapper;
            break;
        }
        return retVal;
    }

    public boolean hasCustomizer() {
        return true;
    }

    private static class DSHandle
    implements Node.Handle {
        DataFilter filter;
        static final long serialVersionUID = -2266375092419944364L;

        public DSHandle(DataFilter f) {
            this.filter = f;
        }

        public Node getNode() {
            return DataSystem.getDataSystem(this.filter);
        }
    }

    static class DSMap
    extends Children.Keys
    implements PropertyChangeListener {
        DSMap() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            DataSystem ds = this.getDS();
            if (ds == null) {
                return;
            }
            if ("root".equals(ev.getPropertyName())) {
                FileSystem fs = (FileSystem)ev.getSource();
                ds.refresh(fs);
                ds.refresh();
            }
        }

        private DataSystem getDS() {
            return (DataSystem)this.getNode();
        }

        protected Node[] createNodes(Object key) {
            DataFolder df = (DataFolder)key;
            FilterNode n = new FilterNode(df.getNodeDelegate(), df.createNodeChildren(this.getDS().filter));
            return new Node[]{n};
        }

        public void refresh(Repository fileSystemPool, FileSystem fs) {
            Enumeration en = fileSystemPool.getFileSystems();
            ArrayList<DataFolder> list = new ArrayList<DataFolder>();
            while (en.hasMoreElements()) {
                FileSystem fsystem = (FileSystem)en.nextElement();
                DataObject root = null;
                try {
                    root = DataObject.find((FileObject)fsystem.getRoot());
                }
                catch (DataObjectNotFoundException e) {
                    Logger.getLogger(DataSystem.class.getName()).log(Level.WARNING, null, e);
                }
                if (!(root instanceof DataFolder) || !this.getDS().filter.acceptDataObject(root)) continue;
                list.add((DataFolder)root);
            }
            this.setKeys(list);
        }

        private void refreshListRoots(URLMapper mapper) {
            File[] files = File.listRoots();
            LinkedHashSet<DataFolder> rootSet = new LinkedHashSet<DataFolder>();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                FileObject fo = this.fetchFileObject(file, mapper);
                if (fo == null) continue;
                try {
                    fo = fo.getFileSystem().getRoot();
                }
                catch (FileStateInvalidException e) {
                    continue;
                }
                DataObject root = null;
                try {
                    root = DataObject.find((FileObject)fo);
                }
                catch (DataObjectNotFoundException e) {
                    Logger.getLogger(DataSystem.class.getName()).log(Level.WARNING, null, e);
                }
                if (!(root instanceof DataFolder) || !this.getDS().filter.acceptDataObject(root)) continue;
                rootSet.add((DataFolder)root);
            }
            this.setKeys(rootSet);
        }

        private FileObject fetchFileObject(File file, URLMapper mapper) {
            FileObject retVal = null;
            try {
                FileObject[] all = mapper.getFileObjects(this.toUrl(file));
                if (all != null && all.length > 0) {
                    retVal = all[0];
                }
            }
            catch (MalformedURLException e) {
                retVal = null;
            }
            return retVal;
        }

        private URL toUrl(File file) throws MalformedURLException {
            return Utilities.isWindows() ? new URL("file:/" + file.getAbsolutePath()) : file.toURI().toURL();
        }
    }

    public static final class NbRepositoryNodeFactory
    extends RepositoryNodeFactory {
        public Node repository(DataFilter f) {
            return DataSystem.getDataSystem(f == DataFilter.ALL ? null : f);
        }
    }
}

