/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.beaninfo.editors.HtmlBrowser;
import org.netbeans.core.UIExceptions;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.BeanNode;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class IDESettings {
    private static final IDESettings INSTANCE = new IDESettings();
    public static final String PROP_SHOW_TOOLTIPS_IN_IDE = "showToolTipsInIDE";
    public static final String PROP_CONFIRM_DELETE = "confirmDelete";
    public static final String PROP_HOME_PAGE = "homePage";
    public static final String PROP_SHOW_FILE_EXTENSIONS = "showFileExtensions";
    public static final String PROP_WWWBROWSER = "WWWBrowser";
    public static final String PROP_IGNORED_FILES = "IgnoredFiles";

    public static IDESettings getInstance() {
        return INSTANCE;
    }

    static Preferences getPreferences() {
        return NbPreferences.forModule(IDESettings.class);
    }

    public boolean getShowToolTipsInIDE() {
        return IDESettings.getPreferences().getBoolean(PROP_SHOW_TOOLTIPS_IN_IDE, true);
    }

    public void setShowToolTipsInIDE(boolean value) {
        IDESettings.getPreferences().putBoolean(PROP_SHOW_TOOLTIPS_IN_IDE, value);
    }

    public boolean getConfirmDelete() {
        return IDESettings.getPreferences().getBoolean(PROP_CONFIRM_DELETE, true);
    }

    public void setConfirmDelete(boolean value) {
        IDESettings.getPreferences().putBoolean(PROP_CONFIRM_DELETE, value);
    }

    public String displayName() {
        return NbBundle.getBundle(IDESettings.class).getString("CTL_IDESettings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(IDESettings.class);
    }

    public String getHomePage() {
        return HtmlBrowser.getHomePage();
    }

    public void setHomePage(String homePage) {
        HtmlBrowser.setHomePage((String)homePage);
    }

    public boolean getShowFileExtensions() {
        return DataNode.getShowFileExtensions();
    }

    public void setShowFileExtensions(boolean s) {
        DataNode.setShowFileExtensions((boolean)s);
    }

    public static HtmlBrowser.Factory getWWWBrowser() {
        block8: {
            try {
                String obj = IDESettings.getPreferences().get(PROP_WWWBROWSER, null);
                if (obj instanceof String && !"".equals(obj)) {
                    Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(HtmlBrowser.Factory.class, obj, null));
                    return item == null ? null : (HtmlBrowser.Factory)item.getInstance();
                }
                if (obj != null && !"".equals(obj)) break block8;
                Lookup.Result res = Lookup.getDefault().lookupResult(HtmlBrowser.Factory.class);
                for (HtmlBrowser.Factory brow : res.allInstances()) {
                    FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Services/Browsers");
                    DataFolder folder = DataFolder.findFolder((FileObject)fo);
                    DataObject[] dobjs = folder.getChildren();
                    for (int i = 0; i < dobjs.length; ++i) {
                        Object o = null;
                        try {
                            InstanceCookie cookie;
                            if (Boolean.TRUE.equals(dobjs[i].getPrimaryFile().getAttribute("hidden")) || (cookie = (InstanceCookie)dobjs[i].getCookie(InstanceCookie.class)) == null || (o = cookie.instanceCreate()) == null || !o.equals(brow)) continue;
                            return brow;
                        }
                        catch (IOException ex) {
                            Logger.getLogger(IDESettings.class.getName()).log(Level.WARNING, null, ex);
                            continue;
                        }
                        catch (ClassNotFoundException ex) {
                            Logger.getLogger(IDESettings.class.getName()).log(Level.WARNING, null, ex);
                        }
                    }
                }
                return null;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public static void setWWWBrowser(HtmlBrowser.Factory brow) {
        try {
            if (brow == null) {
                IDESettings.getPreferences().put(PROP_WWWBROWSER, "");
                return;
            }
            Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(HtmlBrowser.Factory.class, null, (Object)brow));
            if (item != null) {
                IDESettings.getPreferences().put(PROP_WWWBROWSER, item.getId());
            } else {
                Logger.getLogger(IDESettings.class.getName()).warning("IDESettings: Cannot find browser in lookup");
                IDESettings.getPreferences().put(PROP_WWWBROWSER, "");
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getIgnoredFiles() {
        return IDESettings.getPreferences().get(PROP_IGNORED_FILES, "^(CVS|SCCS|vssver\\.scc|#.*#|%.*%|\\.(cvsignore|svn|DS_Store)|_svn)$|~$|^\\..*$");
    }

    public void setIgnoredFiles(String ignoredFiles) throws IllegalArgumentException {
        try {
            Pattern.compile(ignoredFiles);
            IDESettings.getPreferences().put(PROP_IGNORED_FILES, ignoredFiles);
        }
        catch (PatternSyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException();
            iae.initCause(e);
            UIExceptions.annotateUser(iae, e.getMessage(), e.getLocalizedMessage(), null, null);
            throw iae;
        }
    }

    private static BeanNode createViewNode() throws IntrospectionException {
        return new BeanNode((Object)IDESettings.getInstance());
    }

    private static HtmlBrowser.FactoryEditor createHtmlBrowserFactoryEditor() {
        return new HtmlBrowser.FactoryEditor(){

            public void setValue(Object value) {
                IDESettings.setWWWBrowser((HtmlBrowser.Factory)value);
            }

            public Object getValue() {
                return IDESettings.getWWWBrowser();
            }
        };
    }
}

