/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.CLIHandler;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.ExitDialog;
import org.netbeans.core.HtmlBrowserComponent;
import org.netbeans.core.IDESettings;
import org.netbeans.core.LoaderPoolNode;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ModuleSystem;
import org.netbeans.core.startup.layers.SessionManager;
import org.netbeans.core.ui.SwingBrowser;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NbTopManager {
    public static final int IL_MAIN_WINDOW = 1;
    public static final int IL_WINDOWS = 2;
    public static final int IL_WORKSPACES = 4;
    public static final int IL_ALL = 65535;
    private static NbTopManager defaultTopManager;
    private static boolean doingExit;

    public NbTopManager() {
        assert (defaultTopManager == null) : "Only one instance allowed";
        defaultTopManager = this;
        Lookup lookup = Lookup.getDefault();
        if (!(lookup instanceof MainLookup)) {
            throw new ClassCastException("Wrong Lookup impl found: " + lookup);
        }
        MainLookup cfr_ignored_0 = (MainLookup)lookup;
        MainLookup.startedNbTopManager();
    }

    public static NbTopManager get() {
        assert (defaultTopManager != null) : "Must be initialized already";
        return defaultTopManager;
    }

    public static NbTopManager getUninitialized() {
        return NbTopManager.get();
    }

    public static synchronized boolean isInitialized() {
        return defaultTopManager != null;
    }

    public abstract boolean isInteractive(int var1);

    public final void register(Object obj) {
        MainLookup.register((Object)obj);
    }

    public final <T, R> void register(T obj, InstanceContent.Convertor<T, R> conv) {
        MainLookup.register(obj, conv);
    }

    public final void unregister(Object obj) {
        MainLookup.unregister((Object)obj);
    }

    public final <T, R> void unregister(T obj, InstanceContent.Convertor<T, R> conv) {
        MainLookup.unregister(obj, conv);
    }

    public void showHelp(HelpCtx helpCtx) {
        try {
            Class<?> c = ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass("org.netbeans.api.javahelp.Help");
            Object o = Lookup.getDefault().lookup(c);
            if (o != null) {
                Method m = c.getMethod("showHelp", HelpCtx.class);
                m.invoke(o, helpCtx);
                return;
            }
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (Exception e) {
            Logger.getLogger(NbTopManager.class.getName()).log(Level.WARNING, null, e);
        }
        Toolkit.getDefaultToolkit().beep();
    }

    private static void saveAll() {
        DataObject dobj = null;
        ArrayList<DataObject> bad = new ArrayList<DataObject>();
        DataObject[] modifs = DataObject.getRegistry().getModified();
        if (modifs.length == 0) {
            return;
        }
        for (int i = 0; i < modifs.length; ++i) {
            try {
                dobj = modifs[i];
                SaveCookie sc = (SaveCookie)dobj.getCookie(SaveCookie.class);
                if (sc == null) continue;
                StatusDisplayer.getDefault().setStatusText(MessageFormat.format(NbBundle.getBundle(NbTopManager.class).getString("CTL_FMT_SavingMessage"), dobj.getName()));
                sc.save();
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(NbTopManager.class.getName()).log(Level.WARNING, null, ex);
                bad.add(dobj);
            }
        }
        Iterator ee = bad.iterator();
        while (ee.hasNext()) {
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle(NbTopManager.class).getString("CTL_Cannot_save"), ((DataObject)ee.next()).getPrimaryFile().getName()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getBundle(NbTopManager.class).getString("MSG_AllSaved"));
    }

    public static boolean isModalDialogPresent() {
        return NbTopManager.hasModalDialog(WindowManager.getDefault().getMainWindow()) || NbTopManager.hasModalDialog(new JDialog().getOwner());
    }

    private static boolean hasModalDialog(Window w) {
        Window[] ws = w.getOwnedWindows();
        for (int i = 0; i < ws.length; ++i) {
            if (ws[i] instanceof Dialog && ((Dialog)ws[i]).isModal()) {
                return true;
            }
            if (!NbTopManager.hasModalDialog(ws[i])) continue;
            return true;
        }
        return false;
    }

    public static void exit() {
        if (SwingUtilities.isEventDispatchThread()) {
            NbTopManager.doExit();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NbTopManager.doExit();
                }
            });
        }
    }

    public static boolean isExiting() {
        return doingExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doExit() {
        block11: {
            if (doingExit) {
                return;
            }
            doingExit = true;
            try {
                if (System.getProperty("netbeans.close") == null && !ExitDialog.showDialog()) break block11;
                final WindowSystem windowSystem = (WindowSystem)Lookup.getDefault().lookup(WindowSystem.class);
                Runnable hideFrames = new Runnable(){

                    public void run() {
                        CLIHandler.stopServer();
                        if (windowSystem != null) {
                            windowSystem.hide();
                            windowSystem.save();
                        }
                        if (Boolean.getBoolean("netbeans.close.when.invisible")) {
                            TopSecurityManager.exit((int)0);
                        }
                    }
                };
                if (!Main.getModuleSystem().shutDown(hideFrames)) break block11;
                try {
                    try {
                        LoaderPoolNode.store();
                    }
                    catch (IOException ioe) {
                        Logger.getLogger(NbTopManager.class.getName()).log(Level.WARNING, null, ioe);
                    }
                    try {
                        ((MainLookup)Lookup.getDefault()).storeCache();
                    }
                    catch (IOException ioe) {
                        Logger.getLogger(NbTopManager.class.getName()).log(Level.WARNING, null, ioe);
                    }
                    SessionManager.getDefault().close();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    Exceptions.printStackTrace((Throwable)t);
                }
                Task exitTask = new Task(new Runnable(){

                    public void run() {
                        TopSecurityManager.exit((int)0);
                    }
                });
                RequestProcessor.getDefault().post((Runnable)exitTask);
                exitTask.waitFinished();
            }
            finally {
                doingExit = false;
            }
        }
    }

    public abstract ModuleSystem getModuleSystem();

    public static Lookup getModuleLookup() {
        return Main.getModuleSystem().getManager().getModuleLookup();
    }

    public static List getModuleJars() {
        return Main.getModuleSystem().getModuleJars();
    }

    static {
        doingExit = false;
    }

    public static class NbBrowser {
        private HtmlBrowserComponent brComp;
        private PreferenceChangeListener idePCL;
        private static Lookup.Result factoryResult = Lookup.getDefault().lookupResult(HtmlBrowser.Factory.class);

        public NbBrowser() {
            HtmlBrowser.Factory browser = IDESettings.getWWWBrowser();
            if (browser == null) {
                browser = new SwingBrowser();
            }
            if (browser.createHtmlBrowserImpl().getComponent() != null) {
                this.brComp = this.findOpenedBrowserComponent();
            }
            if (this.brComp == null) {
                this.brComp = new HtmlBrowserComponent(browser, true, true);
                this.brComp.putClientProperty("TabPolicy", "HideWhenAlone");
            }
            this.setListener();
        }

        private HtmlBrowserComponent findOpenedBrowserComponent() {
            for (Mode m : WindowManager.getDefault().getModes()) {
                if (!"editor".equals(m.getName())) continue;
                TopComponent[] tcs = m.getTopComponents();
                for (int i = 0; i < tcs.length; ++i) {
                    if (!(tcs[i] instanceof HtmlBrowserComponent)) continue;
                    return (HtmlBrowserComponent)tcs[i];
                }
            }
            return null;
        }

        private void showUrl(URL url) {
            this.brComp.open();
            this.brComp.requestActive();
            this.brComp.setURL(url);
        }

        private void setListener() {
            if (this.idePCL != null) {
                return;
            }
            try {
                this.idePCL = new PreferenceChangeListener(){

                    public void preferenceChange(PreferenceChangeEvent evt) {
                        if ("WWWBrowser".equals(evt.getKey())) {
                            ((NbURLDisplayer)HtmlBrowser.URLDisplayer.getDefault()).htmlViewer = null;
                            if (NbBrowser.this.idePCL != null) {
                                IDESettings.getPreferences().removePreferenceChangeListener(NbBrowser.this.idePCL);
                                NbBrowser.this.idePCL = null;
                                NbBrowser.this.brComp = null;
                            }
                        }
                    }
                };
                IDESettings.getPreferences().addPreferenceChangeListener(this.idePCL);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        static {
            factoryResult.allItems();
            factoryResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    ((NbURLDisplayer)HtmlBrowser.URLDisplayer.getDefault()).htmlViewer = null;
                }
            });
        }
    }

    public static final class NbLifecycleManager
    extends LifecycleManager {
        public void saveAll() {
            NbTopManager.saveAll();
        }

        public void exit() {
            NbTopManager.exit();
        }
    }

    public static final class NbStatusDisplayer
    extends StatusDisplayer {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private String text = "";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStatusText(String text) {
            NbStatusDisplayer nbStatusDisplayer = this;
            synchronized (nbStatusDisplayer) {
                this.text = text;
            }
            this.cs.fireChange();
            Logger.getLogger(NbStatusDisplayer.class.getName()).log(Level.FINE, "Status text updated: {0}", text);
        }

        public synchronized String getStatusText() {
            return this.text;
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }
    }

    public static final class NbURLDisplayer
    extends HtmlBrowser.URLDisplayer {
        private NbBrowser htmlViewer;

        public void showURL(final URL u) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    if (NbURLDisplayer.this.htmlViewer == null) {
                        NbURLDisplayer.this.htmlViewer = new NbBrowser();
                    }
                    NbURLDisplayer.this.htmlViewer.showUrl(u);
                }
            });
        }
    }

    public static interface WindowSystem {
        public void show();

        public void hide();

        public void load();

        public void save();

        public void clear();
    }
}

