/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.openidex.search.CompoundSearchIterator;
import org.openidex.search.SearchInfo;

class CompoundSearchInfo
implements SearchInfo {
    private final SearchInfo[] elements;

    CompoundSearchInfo(SearchInfo[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException();
        }
        this.elements = elements.length != 0 ? elements : null;
    }

    public boolean canSearch() {
        if (this.elements != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (!this.elements[i].canSearch()) continue;
                return true;
            }
        }
        return false;
    }

    public Iterator objectsToSearch() {
        if (this.elements == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList<SearchInfo> searchableElements = new ArrayList<SearchInfo>(this.elements.length);
        for (int i = 0; i < this.elements.length; ++i) {
            if (!this.elements[i].canSearch()) continue;
            searchableElements.add(this.elements[i]);
        }
        return new CompoundSearchIterator(searchableElements.toArray(new SearchInfo[searchableElements.size()]));
    }
}

