/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.XMLAutoupdateType;
import org.openide.ServiceType;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class AutoupdateType
extends ServiceType {
    static final long serialVersionUID = 362844512378569452L;
    static final String PROP_ENABLED = "enabled";
    static final String PROP_LAST_TIME_STAMP = "lastTimeStamp";
    private boolean enabled = true;
    private Date lastTimeStamp;

    public String displayName() {
        return NbBundle.getBundle(AutoupdateType.class).getString("CTL_Settings_Name");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public abstract Updates connectForUpdates();

    public static Enumeration autoupdateTypes() {
        Collection col = Lookup.getDefault().lookup(new Lookup.Template(AutoupdateType.class)).allInstances();
        Iterator it = col.iterator();
        ArrayList<AutoupdateType> lst = new ArrayList<AutoupdateType>();
        while (it.hasNext()) {
            AutoupdateType at = (AutoupdateType)((Object)it.next());
            if (at instanceof XMLAutoupdateType) {
                if (!((XMLAutoupdateType)at).isValid()) continue;
                lst.add(at);
                continue;
            }
            lst.add(at);
        }
        return Collections.enumeration(lst);
    }

    public static AutoupdateType find(Class clazz) {
        return (AutoupdateType)((Object)Lookup.getDefault().lookup(AutoupdateType.class));
    }

    public static AutoupdateType find(String name) {
        for (AutoupdateType at : Lookup.getDefault().lookup(new Lookup.Template(AutoupdateType.class)).allInstances()) {
            if (!name.equals(at.getName())) continue;
            return at;
        }
        return null;
    }

    public static AutoupdateType getDefault() {
        if (AutoupdateType.autoupdateTypes().hasMoreElements()) {
            return (AutoupdateType)((Object)AutoupdateType.autoupdateTypes().nextElement());
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean old = this.enabled;
        this.enabled = enabled;
        this.firePropertyChange(PROP_ENABLED, old ? Boolean.TRUE : Boolean.FALSE, enabled ? Boolean.TRUE : Boolean.FALSE);
    }

    public Date getLastTimeStamp() {
        return this.lastTimeStamp;
    }

    public void setLastTimeStamp(Date lastTimeStamp) {
        Date oldTime = this.lastTimeStamp;
        this.lastTimeStamp = lastTimeStamp;
        this.firePropertyChange(PROP_LAST_TIME_STAMP, oldTime, lastTimeStamp);
    }

    static {
        if (PropertyEditorManager.findEditor(ServiceType.class) != null) {
            PropertyEditorManager.registerEditor(AutoupdateType.class, PropertyEditorManager.findEditor(ServiceType.class).getClass());
        }
    }
}

